/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.hooks;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import me.lucko.spark.api.Spark;
import me.lucko.spark.api.SparkProvider;
import me.lucko.spark.api.statistic.StatisticWindow;
import me.lucko.spark.api.statistic.misc.DoubleAverageInfo;
import me.lucko.spark.api.statistic.types.DoubleStatistic;
import me.lucko.spark.api.statistic.types.GenericStatistic;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.managers.ErrorsManager;
import xyz.lychee.lagfixer.managers.HookManager;
import xyz.lychee.lagfixer.objects.AbstractHook;

public class SparkHook
extends AbstractHook {
    private static SparkMonitor spark;
    private ScheduledTask task;

    public SparkHook(LagFixer plugin, HookManager manager) {
        super(plugin, "spark", manager);
    }

    @Override
    public void load() {
        spark = new SparkMonitor();
        this.task = Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this.getPlugin(), task -> {
            if (ErrorsManager.getInstance().isEnabled() && Bukkit.getOnlinePlayers().size() > 20) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"spark profiler open");
            }
        }, 72000L, 72000L);
    }

    @Override
    public void disable() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    public ScheduledTask getTask() {
        return this.task;
    }

    public static SparkMonitor getSpark() {
        return spark;
    }

    public static class SparkMonitor {
        private final Spark spark = SparkProvider.get();

        public double getTps() {
            DoubleStatistic tps = this.spark.tps();
            if (tps == null) {
                return 0.0;
            }
            return tps.poll((Enum)StatisticWindow.TicksPerSecond.SECONDS_10);
        }

        public double getMspt() {
            GenericStatistic mspt = this.spark.mspt();
            if (mspt == null) {
                return 0.0;
            }
            return ((DoubleAverageInfo)mspt.poll((Enum)StatisticWindow.MillisPerTick.SECONDS_10)).median();
        }

        public double cpuProcess() {
            return this.spark.cpuProcess().poll((Enum)StatisticWindow.CpuUsage.SECONDS_10);
        }

        public double cpuSystem() {
            return this.spark.cpuSystem().poll((Enum)StatisticWindow.CpuUsage.SECONDS_10);
        }
    }
}

