/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.managers;

import java.util.HashMap;
import org.bukkit.Bukkit;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.menu.ConfigMenu;
import xyz.lychee.lagfixer.modules.AbilityLimiterModule;
import xyz.lychee.lagfixer.modules.ConsoleFilterModule;
import xyz.lychee.lagfixer.modules.EntityLimiterModule;
import xyz.lychee.lagfixer.modules.ExplosionOptimizerModule;
import xyz.lychee.lagfixer.modules.InstantLeafDecayModule;
import xyz.lychee.lagfixer.modules.LagShieldModule;
import xyz.lychee.lagfixer.modules.MobAiReducerModule;
import xyz.lychee.lagfixer.modules.RedstoneLimiterModule;
import xyz.lychee.lagfixer.modules.VehicleMotionReducerModule;
import xyz.lychee.lagfixer.modules.WorldCleanerModule;
import xyz.lychee.lagfixer.objects.AbstractManager;
import xyz.lychee.lagfixer.objects.AbstractModule;
import xyz.lychee.lagfixer.utils.TimingUtil;

public class ModuleManager
extends AbstractManager {
    private static ModuleManager instance;
    private final HashMap<String, AbstractModule> modules = new HashMap();

    public ModuleManager(LagFixer plugin) {
        super(plugin);
        instance = this;
        this.addAll(new MobAiReducerModule(plugin, this), new LagShieldModule(plugin, this), new RedstoneLimiterModule(plugin, this), new EntityLimiterModule(plugin, this), new ConsoleFilterModule(plugin, this), new WorldCleanerModule(plugin, this), new VehicleMotionReducerModule(plugin, this), new InstantLeafDecayModule(plugin, this), new AbilityLimiterModule(plugin, this), new ExplosionOptimizerModule(plugin, this));
    }

    public <T extends AbstractModule> T get(Class<T> clazz) {
        return (T)((AbstractModule)clazz.cast(this.modules.get(clazz.getSimpleName())));
    }

    public <T extends AbstractModule> T get(String name) {
        return (T)(this.modules.containsKey(name) ? this.modules.get(name) : null);
    }

    private void addAll(AbstractModule ... arrModules) {
        for (AbstractModule module : arrModules) {
            this.modules.put(module.getClass().getSimpleName(), module);
        }
    }

    @Override
    public void load() {
        for (AbstractModule module : this.modules.values()) {
            try {
                TimingUtil t = TimingUtil.startNew();
                boolean success = module.loadAllConfig();
                boolean enabled = module.getConfig().getBoolean(module.getName() + ".enabled");
                if (enabled) {
                    if (success) {
                        module.load();
                        this.getPlugin().getLogger().info(" &8\u2022 &rSuccessfully loaded module " + module.getName() + " in " + t.stop().getExecutingTime() + "ms.");
                    } else {
                        this.getPlugin().getLogger().info(" &8\u2022 &rSkipping unsupported module " + module.getName() + " for " + Bukkit.getServer().getBukkitVersion() + ".");
                    }
                }
                module.setLoaded(success && enabled);
            }
            catch (Throwable ex) {
                module.setLoaded(false);
                this.getPlugin().getLogger().info(" &8\u2022 &cSkipping module " + module.getName() + ", reason: " + ex.getMessage());
                this.getPlugin().printError(ex);
            }
            ConfigMenu menu = module.getMenu();
            menu.load();
            menu.updateAll();
        }
        if (this.getPlugin().getConfig().isSet("modules")) {
            this.getPlugin().saveConfig();
        }
    }

    @Override
    public void disable() {
        for (AbstractModule module : this.modules.values()) {
            if (!module.isLoaded()) continue;
            try {
                TimingUtil t = TimingUtil.startNew();
                module.disable();
                this.getPlugin().getLogger().info(" \u2022 Successfully disabled module " + module.getName() + " in " + t.stop().getExecutingTime() + "ms.");
            }
            catch (Exception ex) {
                this.getPlugin().getLogger().info(" \u2022 Error with disabling module " + module.getName() + ", reason: " + ex.getMessage());
                this.getPlugin().printError(ex);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public HashMap<String, AbstractModule> getModules() {
        return this.modules;
    }

    public static ModuleManager getInstance() {
        return instance;
    }
}

