/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.managers;

import com.sun.management.OperatingSystemMXBean;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.hooks.SparkHook;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.objects.AbstractManager;
import xyz.lychee.lagfixer.objects.AbstractSupportNms;

public class MonitorManager
extends AbstractManager {
    private static MonitorManager instance;
    private final OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    private final int interval;
    private double tps = 0.0;
    private double mspt = 0.0;
    private double cpuProcess = 0.0;
    private double cpuSystem = 0.0;
    private long ramFree = 0L;
    private long ramUsed = 0L;
    private long ramMax = 0L;
    private long ramTotal = 0L;
    private ScheduledTask task;

    public MonitorManager(LagFixer plugin) {
        super(plugin);
        instance = this;
        this.interval = plugin.getConfig().getInt("main.monitor_interval");
    }

    public double format(double d) {
        return (double)Math.round(d * 100.0) / 100.0;
    }

    public long formatBytes(long bytes) {
        return bytes / 1024L / 1024L;
    }

    @Override
    public void load() throws Exception {
        this.task = Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this.getPlugin(), task -> {
            SparkHook.SparkMonitor spark = SparkHook.getSpark();
            if (spark == null) {
                AbstractSupportNms.TickReport report = SupportManager.getInstance().getNms().getTickReport();
                this.tps = this.format(report.tps());
                this.mspt = this.format(report.mspt());
                this.cpuProcess = this.format(this.osBean.getProcessCpuLoad() * 100.0);
                this.cpuSystem = this.format(this.osBean.getSystemLoadAverage() * 100.0);
            } else {
                this.tps = this.format(spark.getTps());
                this.mspt = this.format(spark.getMspt());
                this.cpuProcess = this.format(spark.cpuProcess() * 100.0);
                this.cpuSystem = this.format(spark.cpuSystem() * 100.0);
            }
            Runtime r = Runtime.getRuntime();
            this.ramFree = this.formatBytes(r.freeMemory());
            this.ramUsed = this.formatBytes(r.totalMemory() - r.freeMemory());
            this.ramMax = this.formatBytes(r.maxMemory());
            this.ramTotal = this.formatBytes(r.totalMemory());
        }, 5L, (long)this.interval, TimeUnit.SECONDS);
    }

    @Override
    public void disable() throws Exception {
        if (this.task != null && !this.task.isCancelled()) {
            this.task.cancel();
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public OperatingSystemMXBean getOsBean() {
        return this.osBean;
    }

    public int getInterval() {
        return this.interval;
    }

    public double getTps() {
        return this.tps;
    }

    public double getMspt() {
        return this.mspt;
    }

    public double getCpuProcess() {
        return this.cpuProcess;
    }

    public double getCpuSystem() {
        return this.cpuSystem;
    }

    public long getRamFree() {
        return this.ramFree;
    }

    public long getRamUsed() {
        return this.ramUsed;
    }

    public long getRamMax() {
        return this.ramMax;
    }

    public long getRamTotal() {
        return this.ramTotal;
    }

    public ScheduledTask getTask() {
        return this.task;
    }

    public void setTps(double tps) {
        this.tps = tps;
    }

    public void setMspt(double mspt) {
        this.mspt = mspt;
    }

    public void setCpuProcess(double cpuProcess) {
        this.cpuProcess = cpuProcess;
    }

    public void setCpuSystem(double cpuSystem) {
        this.cpuSystem = cpuSystem;
    }

    public void setRamFree(long ramFree) {
        this.ramFree = ramFree;
    }

    public void setRamUsed(long ramUsed) {
        this.ramUsed = ramUsed;
    }

    public void setRamMax(long ramMax) {
        this.ramMax = ramMax;
    }

    public void setRamTotal(long ramTotal) {
        this.ramTotal = ramTotal;
    }

    public void setTask(ScheduledTask task) {
        this.task = task;
    }

    public static MonitorManager getInstance() {
        return instance;
    }
}

