/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.managers;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.objects.AbstractManager;
import xyz.lychee.lagfixer.objects.AbstractSupportNms;
import xyz.lychee.lagfixer.objects.RegionsEntityRaport;
import xyz.lychee.lagfixer.utils.ReflectionUtils;

public class SupportManager
extends AbstractManager {
    private static SupportManager instance;
    private final Map<String, String> versions = new HashMap<String, String>();
    private final RegionsEntityRaport regionsReport = new RegionsEntityRaport();
    private AbstractSupportNms nms = null;
    private ScheduledTask task = null;

    public SupportManager(LagFixer plugin) {
        super(plugin);
        instance = this;
        this.versions.put("1.20.5", "v1_20_R4");
        this.versions.put("1.20.6", "v1_20_R4");
        this.versions.put("1.21", "v1_21_R1");
        this.versions.put("1.21.1", "v1_21_R1");
        this.versions.put("1.21.2", "v1_21_R2");
        this.versions.put("1.21.3", "v1_21_R2");
        this.versions.put("1.21.4", "v1_21_R3");
        this.versions.put("1.21.5", "v1_21_R4");
        this.versions.put("1.21.6", "v1_21_R5");
        this.versions.put("1.21.7", "v1_21_R5");
        this.versions.put("1.21.8", "v1_21_R5");
        this.versions.put("1.21.9", "v1_21_R6");
        this.versions.put("1.21.10", "v1_21_R6");
    }

    @Override
    public void load() {
        try {
            String version = ReflectionUtils.getVersion("SupportNms");
            Class<?> clazz = Class.forName("xyz.lychee.lagfixer.nms." + version + ".SupportNms");
            this.nms = (AbstractSupportNms)clazz.getConstructor(LagFixer.class).newInstance(new Object[]{this.getPlugin()});
            this.getPlugin().getLogger().info(" &8\u2022 &rLoaded nms support ~ " + this.nms.getClass().getCanonicalName());
        }
        catch (Throwable ex) {
            this.getPlugin().getLogger().info("   &cOptimal support folia not found!");
            this.getPlugin().getLogger().info("   &7Supported versions: &e1.20.1 - 1.21.8");
            Bukkit.getPluginManager().disablePlugin((Plugin)this.getPlugin());
            return;
        }
        this.task = Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this.getPlugin(), t -> this.nms.updateRegionsStats(this.regionsReport), 10L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public void disable() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public Map<String, String> getVersions() {
        return this.versions;
    }

    public RegionsEntityRaport getRegionsReport() {
        return this.regionsReport;
    }

    public AbstractSupportNms getNms() {
        return this.nms;
    }

    public ScheduledTask getTask() {
        return this.task;
    }

    public void setNms(AbstractSupportNms nms) {
        this.nms = nms;
    }

    public void setTask(ScheduledTask task) {
        this.task = task;
    }

    public static SupportManager getInstance() {
        return instance;
    }
}

