/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.nms.v1_20_R3;

import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.world.ChunkEntitySlices;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.LongAdder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Projectile;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import xyz.lychee.lagfixer.managers.HookManager;
import xyz.lychee.lagfixer.modules.WorldCleanerModule;
import xyz.lychee.lagfixer.objects.RegionsEntityRaport;

public class WorldCleaner
extends WorldCleanerModule.NMS {
    public WorldCleaner(WorldCleanerModule module) {
        super(module);
    }

    @Override
    public void purgeAll(World world, List<CompletableFuture<Void>> into, RegionsEntityRaport raport) {
        ServerLevel level = ((CraftWorld)world).getHandle();
        HookManager.StackerContainer stacker = HookManager.getInstance().getStacker();
        level.regioniser.computeForAllRegions(region -> {
            LongArrayList chunks = region.getOwnedChunks();
            if (chunks.isEmpty()) {
                return;
            }
            CompletableFuture future = new CompletableFuture();
            into.add(future);
            ChunkPos pos = new ChunkPos(((Long)chunks.getFirst()).longValue());
            Bukkit.getRegionScheduler().execute((Plugin)this.getModule().getPlugin(), world, pos.x, pos.z, () -> {
                try {
                    ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                    EnumSet<Material> bl = this.getModule().getItems_abyss_blacklist();
                    LongListIterator longListIterator = chunks.iterator();
                    while (longListIterator.hasNext()) {
                        long l = (Long)longListIterator.next();
                        ChunkEntitySlices slices = level.getEntityLookup().getChunk(CoordinateUtils.getChunkX((long)l), CoordinateUtils.getChunkZ((long)l));
                        if (slices == null) continue;
                        Entity[] entities = slices.getChunkEntities();
                        raport.getEntities().add(entities.length);
                        for (Entity ent : entities) {
                            if (ent instanceof Mob) {
                                Mob creature = (Mob)ent;
                                if (!this.getModule().isCreatures_enabled() || !this.getModule().clearCreature((Entity)creature)) continue;
                                if (this.getModule().isCreatures_dropitems()) {
                                    creature.damage(Double.MAX_VALUE);
                                } else {
                                    creature.remove();
                                }
                                raport.getCreatures().increment();
                                continue;
                            }
                            if (ent instanceof Item) {
                                Item item = (Item)ent;
                                if (!this.getModule().isItems_enabled() || !this.getModule().clearItem((Entity)item)) continue;
                                if (this.getModule().isItems_abyss_enabled() && !this.getModule().getItems_abyss_blacklist().contains(item.getItemStack().getType()) && !bl.contains(item.getItemStack().getType())) {
                                    if (stacker != null) {
                                        stacker.addItemsToList(item, items);
                                    } else {
                                        items.add(item.getItemStack());
                                    }
                                }
                                item.remove();
                                raport.getItems().increment();
                                continue;
                            }
                            if (!(ent instanceof Projectile)) continue;
                            Projectile projectile = (Projectile)ent;
                            if (!this.getModule().isProjectiles_enabled() || !this.getModule().clearProjectile((Entity)projectile)) continue;
                            projectile.remove();
                            raport.getProjectiles().increment();
                        }
                    }
                    this.getModule().getItems().addAll(items);
                    future.complete(null);
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
            });
        });
    }

    @Override
    public void purgeCreatures(World world, List<CompletableFuture<Void>> into, LongAdder size) {
        ServerLevel level = ((CraftWorld)world).getHandle();
        level.regioniser.computeForAllRegions(region -> {
            LongArrayList chunks = region.getOwnedChunks();
            if (chunks.isEmpty()) {
                return;
            }
            CompletableFuture future = new CompletableFuture();
            into.add(future);
            ChunkPos pos = new ChunkPos(((Long)chunks.getFirst()).longValue());
            Bukkit.getRegionScheduler().execute((Plugin)this.getModule().getPlugin(), world, pos.x, pos.z, () -> {
                try {
                    LongListIterator longListIterator = chunks.iterator();
                    while (longListIterator.hasNext()) {
                        long l = (Long)longListIterator.next();
                        ChunkEntitySlices slices = level.getEntityLookup().getChunk(CoordinateUtils.getChunkX((long)l), CoordinateUtils.getChunkZ((long)l));
                        if (slices == null) continue;
                        for (Entity ent : slices.getChunkEntities()) {
                            if (!(ent instanceof Mob)) continue;
                            Mob creature = (Mob)ent;
                            if (!this.getModule().isCreatures_enabled() || !this.getModule().clearCreature((Entity)creature)) continue;
                            if (this.getModule().isCreatures_dropitems()) {
                                creature.damage(Double.MAX_VALUE);
                            } else {
                                creature.remove();
                            }
                            size.increment();
                        }
                    }
                    future.complete(null);
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
            });
        });
    }

    @Override
    public void purgeItems(World world, List<CompletableFuture<Void>> into, LongAdder size) {
        ServerLevel level = ((CraftWorld)world).getHandle();
        level.regioniser.computeForAllRegions(region -> {
            LongArrayList chunks = region.getOwnedChunks();
            if (chunks.isEmpty()) {
                return;
            }
            CompletableFuture future = new CompletableFuture();
            into.add(future);
            ChunkPos pos = new ChunkPos(((Long)chunks.getFirst()).longValue());
            Bukkit.getRegionScheduler().execute((Plugin)this.getModule().getPlugin(), world, pos.x, pos.z, () -> {
                try {
                    LongListIterator longListIterator = chunks.iterator();
                    while (longListIterator.hasNext()) {
                        long l = (Long)longListIterator.next();
                        ChunkEntitySlices slices = level.getEntityLookup().getChunk(CoordinateUtils.getChunkX((long)l), CoordinateUtils.getChunkZ((long)l));
                        if (slices == null) continue;
                        for (Entity ent : slices.getChunkEntities()) {
                            if (!(ent instanceof Item)) continue;
                            Item item = (Item)ent;
                            if (!this.getModule().isItems_enabled() || !this.getModule().clearItem((Entity)item)) continue;
                            item.remove();
                            size.increment();
                        }
                    }
                    future.complete(null);
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
            });
        });
    }

    @Override
    public void purgeProjectiles(World world, List<CompletableFuture<Void>> into, LongAdder size) {
        ServerLevel level = ((CraftWorld)world).getHandle();
        level.regioniser.computeForAllRegions(region -> {
            LongArrayList chunks = region.getOwnedChunks();
            if (chunks.isEmpty()) {
                return;
            }
            CompletableFuture future = new CompletableFuture();
            into.add(future);
            ChunkPos pos = new ChunkPos(((Long)chunks.getFirst()).longValue());
            Bukkit.getRegionScheduler().execute((Plugin)this.getModule().getPlugin(), world, pos.x, pos.z, () -> {
                try {
                    LongListIterator longListIterator = chunks.iterator();
                    while (longListIterator.hasNext()) {
                        long l = (Long)longListIterator.next();
                        ChunkEntitySlices slices = level.getEntityLookup().getChunk(CoordinateUtils.getChunkX((long)l), CoordinateUtils.getChunkZ((long)l));
                        if (slices == null) continue;
                        for (Entity ent : slices.getChunkEntities()) {
                            if (!(ent instanceof Projectile)) continue;
                            Projectile projectile = (Projectile)ent;
                            if (!this.getModule().isProjectiles_enabled() || !this.getModule().clearProjectile((Entity)projectile)) continue;
                            projectile.remove();
                            size.increment();
                        }
                    }
                    future.complete(null);
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
            });
        });
    }
}

