/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.nms.v1_21_R1;

import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.ChunkEntitySlices;
import io.papermc.paper.threadedregions.TickData;
import io.papermc.paper.threadedregions.TickRegions;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Vehicle;
import org.bukkit.plugin.Plugin;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.objects.AbstractSupportNms;
import xyz.lychee.lagfixer.objects.RegionsEntityRaport;

public class SupportNms
extends AbstractSupportNms {
    public SupportNms(LagFixer plugin) {
        super(plugin);
    }

    @Override
    public AbstractSupportNms.TickReport getTickReport() {
        double medMspt;
        double medTps;
        long currTime = System.nanoTime();
        DoubleArrayList tpsByRegion = new DoubleArrayList();
        DoubleArrayList msptByRegion = new DoubleArrayList();
        for (World world : Bukkit.getWorlds()) {
            ((CraftWorld)world).getHandle().regioniser.computeForAllRegions(region -> {
                TickData.TickReportData report = ((TickRegions.TickRegionData)region.getData()).getRegionSchedulingHandle().getTickReport15s(currTime);
                if (report != null) {
                    tpsByRegion.add(report.tpsData().segmentAll().average());
                    msptByRegion.add(report.timePerTickData().segmentAll().average() / 1000000.0);
                }
            });
        }
        if (tpsByRegion.isEmpty()) {
            return new AbstractSupportNms.TickReport(20.0, 0.0);
        }
        int middle = tpsByRegion.size() >> 1;
        if ((tpsByRegion.size() & 1) == 0) {
            medTps = (tpsByRegion.getDouble(middle - 1) + tpsByRegion.getDouble(middle)) / 2.0;
            medMspt = (msptByRegion.getDouble(middle - 1) + msptByRegion.getDouble(middle)) / 2.0;
        } else {
            medTps = tpsByRegion.getDouble(middle);
            medMspt = msptByRegion.getDouble(middle);
        }
        return new AbstractSupportNms.TickReport(medMspt, medTps);
    }

    @Override
    public void updateRegionsStats(RegionsEntityRaport stats) {
        LongAdder chunks = new LongAdder();
        LongAdder entities = new LongAdder();
        LongAdder players = new LongAdder();
        LongAdder creatures = new LongAdder();
        LongAdder items = new LongAdder();
        LongAdder vehicles = new LongAdder();
        LongAdder projectiles = new LongAdder();
        ArrayList futures = new ArrayList();
        for (World world : Bukkit.getWorlds()) {
            WorldServer level = ((CraftWorld)world).getHandle();
            if (level.x().isEmpty()) continue;
            level.regioniser.computeForAllRegions(region -> {
                LongArrayList ownedChunks = region.getOwnedChunks();
                TickRegions.TickRegionData data = (TickRegions.TickRegionData)region.getData();
                if (data != null) {
                    TickRegions.RegionStats rs = data.getRegionStats();
                    chunks.add(rs.getChunkCount());
                    entities.add(rs.getEntityCount());
                    players.add(rs.getPlayerCount());
                }
                if (ownedChunks.isEmpty()) {
                    return;
                }
                CompletableFuture future = new CompletableFuture();
                futures.add(future);
                ChunkCoordIntPair firstPos = new ChunkCoordIntPair(((Long)ownedChunks.getFirst()).longValue());
                Bukkit.getRegionScheduler().execute((Plugin)this.getPlugin(), world, firstPos.e, firstPos.f, () -> {
                    try {
                        LongListIterator longListIterator = ownedChunks.iterator();
                        while (longListIterator.hasNext()) {
                            long chunkKey = (Long)longListIterator.next();
                            int chunkX = CoordinateUtils.getChunkX((long)chunkKey);
                            int chunkZ = CoordinateUtils.getChunkZ((long)chunkKey);
                            ChunkEntitySlices slices = level.moonrise$getEntityLookup().getChunk(chunkX, chunkZ);
                            if (slices == null) continue;
                            for (Entity ent : slices.getChunkEntities()) {
                                if (ent instanceof Mob) {
                                    creatures.increment();
                                    continue;
                                }
                                if (ent instanceof Item) {
                                    items.increment();
                                    continue;
                                }
                                if (ent instanceof Projectile) {
                                    projectiles.increment();
                                    continue;
                                }
                                if (!(ent instanceof Vehicle)) continue;
                                vehicles.increment();
                            }
                        }
                        future.complete(null);
                    }
                    catch (Throwable t) {
                        future.completeExceptionally(t);
                    }
                });
            });
        }
        ((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).orTimeout(5L, TimeUnit.SECONDS).thenAccept(v -> {
            stats.setChunks(chunks);
            stats.setEntities(entities);
            stats.setPlayers(players);
            stats.setCreatures(creatures);
            stats.setItems(items);
            stats.setProjectiles(projectiles);
            stats.setVehicles(vehicles);
        })).exceptionally(ex -> {
            this.getPlugin().printError((Throwable)ex);
            return null;
        });
    }
}

