/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.nms.v1_21_R3;

import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.ChunkEntitySlices;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.LongAdder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.level.ChunkCoordIntPair;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import xyz.lychee.lagfixer.managers.HookManager;
import xyz.lychee.lagfixer.modules.WorldCleanerModule;
import xyz.lychee.lagfixer.objects.RegionsEntityRaport;

public class WorldCleaner
extends WorldCleanerModule.NMS {
    public WorldCleaner(WorldCleanerModule module) {
        super(module);
    }

    @Override
    public void purgeAll(World world, List<CompletableFuture<Void>> into, RegionsEntityRaport raport) {
        WorldServer level = ((CraftWorld)world).getHandle();
        HookManager.StackerContainer stacker = HookManager.getInstance().getStacker();
        level.regioniser.computeForAllRegions(region -> {
            LongArrayList chunks = region.getOwnedChunks();
            if (chunks.isEmpty()) {
                return;
            }
            CompletableFuture future = new CompletableFuture();
            into.add(future);
            ChunkCoordIntPair pos = new ChunkCoordIntPair(((Long)chunks.getFirst()).longValue());
            Bukkit.getRegionScheduler().execute((Plugin)this.getModule().getPlugin(), world, pos.h, pos.i, () -> {
                try {
                    ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                    EnumSet<Material> bl = this.getModule().getItems_abyss_blacklist();
                    LongListIterator longListIterator = chunks.iterator();
                    while (longListIterator.hasNext()) {
                        long l = (Long)longListIterator.next();
                        ChunkEntitySlices slices = level.moonrise$getEntityLookup().getChunk(CoordinateUtils.getChunkX((long)l), CoordinateUtils.getChunkZ((long)l));
                        if (slices == null) continue;
                        List entities = slices.getAllEntities();
                        raport.getEntities().add(entities.size());
                        for (net.minecraft.world.entity.Entity ent : entities) {
                            if (ent instanceof EntityInsentient) {
                                EntityInsentient creature = (EntityInsentient)ent;
                                if (!this.getModule().isCreatures_enabled() || !this.getModule().clearCreature((Entity)creature.getBukkitEntity())) continue;
                                if (this.getModule().isCreatures_dropitems()) {
                                    creature.c(level);
                                } else {
                                    creature.a(Entity.RemovalReason.a);
                                }
                                raport.getCreatures().increment();
                                continue;
                            }
                            if (ent instanceof EntityItem) {
                                Item bukkit;
                                EntityItem item = (EntityItem)ent;
                                if (!this.getModule().isItems_enabled() || !this.getModule().clearItem((Entity)item.getBukkitEntity())) continue;
                                if (this.getModule().isItems_abyss_enabled() && !this.getModule().getItems_abyss_blacklist().contains(item.l().getBukkitStack().getType()) && !bl.contains((bukkit = (Item)item.getBukkitEntity()).getItemStack().getType())) {
                                    if (stacker != null) {
                                        stacker.addItemsToList(bukkit, items);
                                    } else {
                                        items.add(bukkit.getItemStack());
                                    }
                                }
                                item.a(Entity.RemovalReason.a);
                                raport.getItems().increment();
                                continue;
                            }
                            if (!(ent instanceof IProjectile)) continue;
                            IProjectile projectile = (IProjectile)ent;
                            if (!this.getModule().isProjectiles_enabled() || !this.getModule().clearProjectile((Entity)projectile.getBukkitEntity())) continue;
                            projectile.a(Entity.RemovalReason.a);
                            raport.getProjectiles().increment();
                        }
                    }
                    this.getModule().getItems().addAll(items);
                    future.complete(null);
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
            });
        });
    }

    @Override
    public void purgeCreatures(World world, List<CompletableFuture<Void>> into, LongAdder size) {
        WorldServer level = ((CraftWorld)world).getHandle();
        level.regioniser.computeForAllRegions(region -> {
            LongArrayList chunks = region.getOwnedChunks();
            if (chunks.isEmpty()) {
                return;
            }
            CompletableFuture future = new CompletableFuture();
            into.add(future);
            ChunkCoordIntPair pos = new ChunkCoordIntPair(((Long)chunks.getFirst()).longValue());
            Bukkit.getRegionScheduler().execute((Plugin)this.getModule().getPlugin(), world, pos.h, pos.i, () -> {
                try {
                    LongListIterator longListIterator = chunks.iterator();
                    while (longListIterator.hasNext()) {
                        long l = (Long)longListIterator.next();
                        ChunkEntitySlices slices = level.moonrise$getEntityLookup().getChunk(CoordinateUtils.getChunkX((long)l), CoordinateUtils.getChunkZ((long)l));
                        if (slices == null) continue;
                        for (net.minecraft.world.entity.Entity ent : slices.getAllEntities()) {
                            if (!(ent instanceof EntityInsentient)) continue;
                            EntityInsentient creature = (EntityInsentient)ent;
                            if (!this.getModule().isCreatures_enabled() || !this.getModule().clearCreature((Entity)creature.getBukkitEntity())) continue;
                            if (this.getModule().isCreatures_dropitems()) {
                                creature.c(level);
                            } else {
                                creature.a(Entity.RemovalReason.a);
                            }
                            size.increment();
                        }
                    }
                    future.complete(null);
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
            });
        });
    }

    @Override
    public void purgeItems(World world, List<CompletableFuture<Void>> into, LongAdder size) {
        WorldServer level = ((CraftWorld)world).getHandle();
        level.regioniser.computeForAllRegions(region -> {
            LongArrayList chunks = region.getOwnedChunks();
            if (chunks.isEmpty()) {
                return;
            }
            CompletableFuture future = new CompletableFuture();
            into.add(future);
            ChunkCoordIntPair pos = new ChunkCoordIntPair(((Long)chunks.getFirst()).longValue());
            Bukkit.getRegionScheduler().execute((Plugin)this.getModule().getPlugin(), world, pos.h, pos.i, () -> {
                try {
                    LongListIterator longListIterator = chunks.iterator();
                    while (longListIterator.hasNext()) {
                        long l = (Long)longListIterator.next();
                        ChunkEntitySlices slices = level.moonrise$getEntityLookup().getChunk(CoordinateUtils.getChunkX((long)l), CoordinateUtils.getChunkZ((long)l));
                        if (slices == null) continue;
                        for (net.minecraft.world.entity.Entity ent : slices.getAllEntities()) {
                            if (!(ent instanceof EntityItem)) continue;
                            EntityItem item = (EntityItem)ent;
                            if (!this.getModule().isItems_enabled() || !this.getModule().clearItem((Entity)item.getBukkitEntity())) continue;
                            item.a(Entity.RemovalReason.a);
                            size.increment();
                        }
                    }
                    future.complete(null);
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
            });
        });
    }

    @Override
    public void purgeProjectiles(World world, List<CompletableFuture<Void>> into, LongAdder size) {
        WorldServer level = ((CraftWorld)world).getHandle();
        level.regioniser.computeForAllRegions(region -> {
            LongArrayList chunks = region.getOwnedChunks();
            if (chunks.isEmpty()) {
                return;
            }
            CompletableFuture future = new CompletableFuture();
            into.add(future);
            ChunkCoordIntPair pos = new ChunkCoordIntPair(((Long)chunks.getFirst()).longValue());
            Bukkit.getRegionScheduler().execute((Plugin)this.getModule().getPlugin(), world, pos.h, pos.i, () -> {
                try {
                    LongListIterator longListIterator = chunks.iterator();
                    while (longListIterator.hasNext()) {
                        long l = (Long)longListIterator.next();
                        ChunkEntitySlices slices = level.moonrise$getEntityLookup().getChunk(CoordinateUtils.getChunkX((long)l), CoordinateUtils.getChunkZ((long)l));
                        if (slices == null) continue;
                        for (net.minecraft.world.entity.Entity ent : slices.getAllEntities()) {
                            if (!(ent instanceof IProjectile)) continue;
                            IProjectile projectile = (IProjectile)ent;
                            if (!this.getModule().isProjectiles_enabled() || !this.getModule().clearProjectile((Entity)projectile.getBukkitEntity())) continue;
                            projectile.a(Entity.RemovalReason.a);
                            size.increment();
                        }
                    }
                    future.complete(null);
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
            });
        });
    }
}

