/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;
import xyz.lychee.lagfixer.Language;
import xyz.lychee.lagfixer.hooks.PlaceholderAPIHook;
import xyz.lychee.lagfixer.managers.ConfigManager;
import xyz.lychee.lagfixer.managers.HookManager;

public class MessageUtils
extends JavaPlugin {
    private static final Map<String, String> REPLACEMENTS;

    public static String fixColors(@Nullable CommandSender sender, String message) {
        if (message == null) {
            return "";
        }
        String processed = MessageUtils.applyPapi(sender, MessageUtils.applyReplacements(message));
        return ChatColor.translateAlternateColorCodes((char)'&', (String)processed);
    }

    public static TextComponent colors(@Nullable CommandSender sender, String message) {
        if (message == null || message.isEmpty()) {
            return Component.empty();
        }
        String processed = MessageUtils.applyPapi(sender, MessageUtils.applyReplacements(message));
        return Language.getSerializer().deserialize(processed);
    }

    private static String applyReplacements(String text) {
        for (Map.Entry<String, String> entry : REPLACEMENTS.entrySet()) {
            text = StringUtils.replace((String)text, (String)entry.getKey(), (String)entry.getValue());
        }
        return text;
    }

    private static String applyPapi(@Nullable CommandSender sender, String text) {
        PlaceholderAPIHook papi;
        if (sender instanceof Player && (papi = HookManager.getInstance().getHook(PlaceholderAPIHook.class)) != null) {
            text = papi.applyPlaceholders((Player)sender, text);
        }
        return text;
    }

    public static boolean sendMessage(boolean prefix, CommandSender sender, String message) {
        sender.sendMessage(MessageUtils.fixColors(sender, (prefix ? ConfigManager.getInstance().getLegacyPrefix() : "") + "&f" + MessageUtils.applyReplacements(message)));
        return false;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("{*}", "\u2022");
        map.put("{>>}", "\u00bb");
        map.put("{<<}", "\u00ab");
        REPLACEMENTS = Collections.unmodifiableMap(map);
    }
}

