/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.managers;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Item;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.Language;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.Component;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import xyz.lychee.lagfixer.managers.ConfigManager;
import xyz.lychee.lagfixer.managers.ErrorsManager;
import xyz.lychee.lagfixer.managers.ModuleManager;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.map.MapHandler;
import xyz.lychee.lagfixer.menu.HardwareMenu;
import xyz.lychee.lagfixer.menu.MainMenu;
import xyz.lychee.lagfixer.menu.ModuleMenu;
import xyz.lychee.lagfixer.menu.ModulesMenu;
import xyz.lychee.lagfixer.modules.WorldCleanerModule;
import xyz.lychee.lagfixer.objects.AbstractManager;
import xyz.lychee.lagfixer.objects.AbstractModule;
import xyz.lychee.lagfixer.objects.AbstractMonitor;
import xyz.lychee.lagfixer.utils.MessageUtils;
import xyz.lychee.lagfixer.utils.TimingUtil;

public class CommandManager
extends AbstractManager
implements Listener,
TabExecutor {
    private static CommandManager instance;
    private final HashMap<UUID, ConfigChange> playerchange = new HashMap();
    private MainMenu mainMenu;
    private ModulesMenu modulesMenu;
    private HardwareMenu hardwareMenu;
    private MapHandler mapHandler;
    private String permission;
    private boolean benchmark = false;

    public CommandManager(LagFixer plugin) {
        super(plugin);
        instance = this;
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent e) {
        if (this.playerchange.containsKey(e.getPlayer().getUniqueId())) {
            e.setCancelled(true);
            ConfigChange change = this.playerchange.get(e.getPlayer().getUniqueId());
            this.playerchange.remove(e.getPlayer().getUniqueId());
            if (e.getMessage().equalsIgnoreCase("-cancel") || e.getMessage().equalsIgnoreCase("cancel")) {
                SupportManager.getInstance().getFork().runNow(false, e.getPlayer().getLocation(), () -> e.getPlayer().openInventory(change.getModule().getMenu().getInv()));
                MessageUtils.sendMessage(true, (CommandSender)e.getPlayer(), "Config editor has been successfully canceled!");
                return;
            }
            AbstractModule module = change.getModule();
            ConfigurationSection section = change.getModule().getSection();
            String key = change.getKey();
            String msg = e.getMessage();
            try {
                if (section.isString(key)) {
                    section.set(key, (Object)msg);
                } else if (section.isInt(key)) {
                    int i = Integer.parseInt(msg);
                    section.set(key, (Object)i);
                } else if (section.isDouble(key)) {
                    double d = Double.parseDouble(msg);
                    section.set(key, (Object)d);
                } else if (section.isLong(key)) {
                    long l = Long.parseLong(msg);
                    section.set(key, (Object)l);
                } else if (section.isBoolean(key)) {
                    boolean b = Boolean.parseBoolean(msg);
                    section.set(key, (Object)b);
                } else if (section.isList(key)) {
                    List list = section.getStringList(key);
                    if (list.contains(msg)) {
                        list.remove(msg);
                    } else {
                        list.add(msg);
                    }
                    section.set(key, (Object)list);
                }
                module.getConfig().save(new File(this.getPlugin().getDataFolder(), "modules/" + module.getName() + ".yml"));
                module.loadAllConfig();
                MessageUtils.sendMessage(true, (CommandSender)e.getPlayer(), "&fConfiguration successfully saved!\n &8{*} &e" + change.getValue() + " &8\u2192 &e" + section.get(key) + "\n ");
                ModuleMenu menu = module.getMenu();
                menu.update();
                SupportManager.getInstance().getFork().runNow(false, e.getPlayer().getLocation(), () -> e.getPlayer().openInventory(menu.getInv()));
            }
            catch (Exception ex) {
                MessageUtils.sendMessage(true, (CommandSender)e.getPlayer(), "&fAn error occurred while saving the configuration, make sure that the given value is correct!");
            }
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        this.playerchange.remove(e.getPlayer().getUniqueId());
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!sender.hasPermission(this.permission)) {
            Component text = Language.getMainValue("no_access", true, Placeholder.unparsed("permission", this.permission));
            if (text == null) {
                return false;
            }
            LagFixer.getInstance().getAudiences().sender(sender).sendMessage(text);
            return false;
        }
        if (args.length > 0) {
            WorldCleanerModule module = ModuleManager.getInstance().get(WorldCleanerModule.class);
            switch (String.join((CharSequence)" ", args).toLowerCase()) {
                case "menu": {
                    if (sender instanceof Player) {
                        ((Player)sender).openInventory(this.mainMenu.getInv());
                    } else {
                        Component text = Language.getMainValue("player_only", true, new TagResolver.Single[0]);
                        if (text != null) {
                            LagFixer.getInstance().getAudiences().sender(sender).sendMessage(text);
                        }
                    }
                    return false;
                }
                case "benchmark": {
                    if (this.benchmark) {
                        return MessageUtils.sendMessage(true, sender, "&7Benchmark is running, wait for results in console!");
                    }
                    if (SupportManager.getInstance().getMonitor().getMspt() > 10.0) {
                        return MessageUtils.sendMessage(true, sender, "&7Server MSPT is too &chigh&7, the result may be incorrect!");
                    }
                    AbstractMonitor monitor = SupportManager.getInstance().getMonitor();
                    long availableRam = monitor.getRamFree() + (monitor.getRamMax() - monitor.getRamTotal());
                    if (availableRam < 2048L) {
                        return MessageUtils.sendMessage(true, sender, "&7Server available RAM is too low, you need &c" + availableRam + "&8/&c2048MB");
                    }
                    BukkitTask task = SupportManager.getInstance().getFork().runTimer(true, () -> {
                        if (this.benchmark) {
                            MessageUtils.sendMessage(true, sender, "&7Async benchmark in progress, wait for results...");
                        }
                    }, 1L, 2L, TimeUnit.SECONDS);
                    this.benchmark = true;
                    Thread thread = new Thread(() -> {
                        try {
                            TimingUtil t = TimingUtil.startNew();
                            System.gc();
                            System.runFinalization();
                            Benchmark b = this.runBenchmarks(10, 20, 100000000, 10);
                            task.cancel();
                            String result = b.getResult().toString();
                            ErrorsManager.getInstance().sendBenchmark(b);
                            MessageUtils.sendMessage(true, sender, "&7Benchmark done in &f" + t.stop().getExecutingTime() + "&7ms, results:&f" + result);
                            this.getPlugin().getLogger().info(result);
                        }
                        catch (Exception e) {
                            MessageUtils.sendMessage(true, sender, "&cBenchmark error: " + e.getMessage());
                        }
                        this.benchmark = false;
                    });
                    thread.setName("LagFixer Benchmark");
                    thread.setPriority(10);
                    thread.start();
                    return false;
                }
                case "reload": {
                    TimingUtil t = TimingUtil.startNew();
                    this.getPlugin().reloadConfig();
                    try {
                        ConfigManager.getInstance().load();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    ModuleManager.getInstance().getModules().forEach((clazz, m) -> {
                        boolean enabled = m.getConfig().getBoolean(m.getName() + ".enabled");
                        try {
                            if (enabled) {
                                if (!m.isLoaded()) {
                                    m.load();
                                    m.setLoaded(true);
                                }
                                m.loadAllConfig();
                                this.getPlugin().getLogger().info("&rConfiguration for &e" + m.getName() + " &rsuccessfully reloaded!");
                            } else if (m.isLoaded()) {
                                m.disable();
                                m.setLoaded(false);
                                this.getPlugin().getLogger().info("&rSuccessfully disabled module &e" + m.getName() + "&r!");
                            }
                            m.getMenu().update();
                        }
                        catch (Exception ex) {
                            this.getPlugin().printError(ex);
                            this.getPlugin().getLogger().info("&rError reloading configuration for &c" + m.getName() + "&r!");
                        }
                    });
                    MessageUtils.sendMessage(true, sender, "&7Reloaded some configurations in &f" + t.stop().getExecutingTime() + "&7ms.\n \n &7Working methods to apply all changes:\n  &8{*} &7Server restart (&frecommended&7)\n  &8{*} &7All plugins reload, command: &f/reload confirm\n  &8{*} &7Plugman reload, command: &f/plugman reload LagFixer");
                    return false;
                }
                case "tps": 
                case "mspt": 
                case "monitor": {
                    AbstractMonitor monitor = SupportManager.getInstance().getMonitor();
                    return MessageUtils.sendMessage(true, sender, "&7Command result: \n &8{*} &fTps: &e" + monitor.getTps() + "\n &8{*} &fMspt: &e" + monitor.getMspt() + "\n &8{*} &fMemory: &e" + monitor.getRamUsed() + "&8/&e" + monitor.getRamTotal() + "&8/&e" + monitor.getRamMax() + " MB\n &8{*} &fCpu process: &e" + monitor.getCpuProcess() + "%\n &8{*} &fCpu system: &e" + monitor.getCpuSystem() + "%");
                }
                case "free": {
                    Runtime runtime = Runtime.getRuntime();
                    long oram = runtime.totalMemory() - runtime.freeMemory();
                    runtime.gc();
                    long nram = runtime.totalMemory() - runtime.freeMemory();
                    return MessageUtils.sendMessage(true, sender, "&7Command result:\n&8{*} &fGarbage collector cleared &e" + (oram - nram) + "bytes &fram!");
                }
                case "ping": {
                    double averagePing = Bukkit.getOnlinePlayers().stream().mapToInt(Player::getPing).average().orElse(-1.0);
                    return MessageUtils.sendMessage(true, sender, "&7Command result:\n&8{*} &fAverage players ping: &e" + averagePing);
                }
                case "clear items": {
                    if (module != null && module.isLoaded()) {
                        AtomicInteger ai = new AtomicInteger();
                        module.getAllowedWorldsStream().flatMap(w -> w.getEntitiesByClass(Item.class).stream()).filter(module::clearItem).forEach(ent -> {
                            ent.remove();
                            ai.incrementAndGet();
                        });
                        MessageUtils.sendMessage(true, sender, "&7Successfully removed &e" + ai.get() + " &7items.");
                    } else {
                        MessageUtils.sendMessage(true, sender, "&7WorldCleaner module is disabled, so LagFixer cannot remove the items from the indicated rules!");
                    }
                    return false;
                }
                case "clear creatures": {
                    if (module != null && module.isLoaded()) {
                        AtomicInteger ai = new AtomicInteger();
                        module.getAllowedWorldsStream().flatMap(w -> w.getEntitiesByClass(Mob.class).stream()).filter(module::clearCreature).forEach(ent -> {
                            ent.remove();
                            ai.incrementAndGet();
                        });
                        MessageUtils.sendMessage(true, sender, "&7Successfully removed &e" + ai.get() + " &7creatures.");
                    } else {
                        MessageUtils.sendMessage(true, sender, "&7WorldCleaner module is disabled, so LagFixer cannot remove the mobs from the indicated rules!");
                    }
                    return false;
                }
                case "clear projectiles": {
                    if (module != null && module.isLoaded()) {
                        AtomicInteger ai = new AtomicInteger();
                        module.getAllowedWorldsStream().flatMap(w -> w.getEntitiesByClass(Projectile.class).stream()).filter(module::clearProjectile).forEach(ent -> {
                            ent.remove();
                            ai.incrementAndGet();
                        });
                        MessageUtils.sendMessage(true, sender, "&7Successfully removed &e" + ai.get() + " &7projectiles.");
                    } else {
                        MessageUtils.sendMessage(true, sender, "&7WorldCleaner module is disabled, so LagFixer cannot remove the mobs from the indicated rules!");
                    }
                    return false;
                }
                case "map": {
                    if (this.mapHandler == null) {
                        MessageUtils.sendMessage(true, sender, "&7The map is currently unavailable.\nYou need to add the &e&n-Djava.awt.headless=true&7 flag when starting the application to resolve the issue.\nThis will enable headless mode and avoid the X11 display connection problem.\nPlease restart the server with this flag and check if the issue persists.");
                        return false;
                    }
                    if (sender instanceof Player) {
                        this.mapHandler.giveMap((Player)sender);
                    } else {
                        Component text = Language.getMainValue("player_only", true, new TagResolver.Single[0]);
                        if (text != null) {
                            LagFixer.getInstance().getAudiences().sender(sender).sendMessage(text);
                        }
                    }
                    return false;
                }
            }
            return false;
        }
        return MessageUtils.sendMessage(true, sender, "Subcommands list:\n&8{*} &f/lagfixer &emenu &8- &7open lagfixer menu, and edit configuration\n&8{*} &f/lagfixer &ereload &8- &7reload all plugin configuration\n&8{*} &f/lagfixer &etps &8- &7check server load statistics\n&8{*} &f/lagfixer &ebenchmark &8- &7run benchmark and compare it with other servers\n&8{*} &f/lagfixer &eping &8- &7calculate average players ping\n&8{*} &f/lagfixer &efree &8- &7clear free ram from memory\n&8{*} &f/lagfixer &eclear items &8- &7remove items using rules in WorldCleaner\n&8{*} &f/lagfixer &eclear creatures &8- &7remove mobs using rules in WorldCleaner\n&8{*} &f/lagfixer &eclear projectiles &8- &7remove projectiles using rules in WorldCleaner\n&8{*} &f/lagfixer &emap &8- &7server load map monitor with mspt chart");
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length == 1) {
            ArrayList completions = Lists.newArrayList((Object[])new String[]{"menu", "benchmark", "reload", "tps", "free", "ping", "clear items", "clear creatures", "map"});
            if (!args[0].isEmpty()) {
                completions.removeIf(str -> !str.startsWith(args[0]));
            }
            Collections.sort(completions);
            return completions;
        }
        return Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toList());
    }

    @Override
    public void load() {
        this.mainMenu = new MainMenu(this.getPlugin(), 27, MessageUtils.fixColors(null, "&8[&e&l\u26a1&8] &fMenu! &8| &eLagFixer"));
        this.mainMenu.load();
        this.modulesMenu = new ModulesMenu(this.getPlugin(), 45, MessageUtils.fixColors(null, "&8[&e&l\u26a1&8] &fModules! &8| &eLagFixer"));
        this.modulesMenu.load();
        this.modulesMenu.update();
        try {
            this.hardwareMenu = new HardwareMenu(this.getPlugin(), 27, MessageUtils.fixColors(null, "&8[&e&l\u26a1&8] &fHardware! &8| &eLagFixer"));
            this.hardwareMenu.load();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.mapHandler = new MapHandler(this.getPlugin());
            this.mapHandler.load();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.permission = this.getPlugin().getConfig().getString("main.command.permission");
        SupportManager.getInstance().getFork().registerCommand((Plugin)this.getPlugin(), "lagfixer", this.getPlugin().getConfig().getStringList("main.command.aliases"), (CommandExecutor)this);
        this.getPlugin().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        this.mainMenu.unload();
        this.modulesMenu.unload();
        if (this.hardwareMenu != null) {
            this.hardwareMenu.unload();
        }
        if (this.mapHandler != null) {
            this.mapHandler.unload();
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public Benchmark runBenchmarks(int warmup, int cpu, int arrayLength, int memoryPasses) {
        Benchmark benchmark = new Benchmark(cpu);
        benchmark.getResult().append("\n \n&8&m    &r&8[ &eLagFixer Advanced CPU Benchmark &8]&m    &r\n ");
        for (int i = 0; i < warmup; ++i) {
            this.cpuTest(1000000);
        }
        double totalScore = 0.0;
        long bestScore = Long.MAX_VALUE;
        long worstScore = Long.MIN_VALUE;
        double checksum = 0.0;
        for (int i = 0; i < cpu; ++i) {
            double score;
            long startTime = System.nanoTime();
            double result = this.cpuTest(10000000);
            long duration = System.nanoTime() - startTime;
            ((Benchmark)benchmark).scores[i] = score = 1.0E10 / (double)duration;
            totalScore += score;
            bestScore = Math.min(bestScore, duration);
            worstScore = Math.max(worstScore, duration);
            checksum += result;
        }
        benchmark.getResult().append("\n &8\u2022 &fAverage performance: &e").append(totalScore / (double)cpu).append(" Gop/s").append("\n &8\u2022 &fBest time: &e").append((double)bestScore / 1.0E9).append(" s").append("\n &8\u2022 &fWorst time: &e").append((double)worstScore / 1.0E9).append(" s");
        benchmark.setCpu_checksum(checksum);
        benchmark.setTotalScore(totalScore / (double)cpu);
        benchmark.setBestScore(bestScore);
        benchmark.setWorstScore(worstScore);
        benchmark.getResult().append("\n \n&8&m    &r&8[ &eLagFixer Advanced RAM Benchmark &8]&m    &r\n ");
        long[] array = new long[arrayLength];
        int[] randomIndices = new int[arrayLength];
        Random rand = new Random(2137L);
        for (int i = 0; i < arrayLength; ++i) {
            randomIndices[i] = rand.nextInt(arrayLength);
        }
        long writeTime = 0L;
        for (int pass = 0; pass < memoryPasses; ++pass) {
            long start = System.nanoTime();
            for (int i = 0; i < arrayLength; ++i) {
                array[i] = i + pass;
            }
            writeTime += System.nanoTime() - start;
        }
        double writeSpeed = (double)arrayLength * 4.0 * (double)memoryPasses / 1048576.0 / ((double)writeTime / 1.0E9);
        benchmark.getResult().append(String.format("\n &8\u2022 &fSequential write: &e%.2f MB/s", writeSpeed));
        benchmark.setWriteSpeed(writeSpeed);
        long readTime = 0L;
        long readChecksum = 0L;
        for (int pass = 0; pass < memoryPasses; ++pass) {
            long start = System.nanoTime();
            for (int i = 0; i < arrayLength; ++i) {
                readChecksum += array[i];
            }
            readTime += System.nanoTime() - start;
        }
        double readSpeed = (double)arrayLength * 4.0 * (double)memoryPasses / 1048576.0 / ((double)readTime / 1.0E9);
        benchmark.getResult().append(String.format("\n &8\u2022 &fSequential read: &e%.2f MB/s", readSpeed));
        benchmark.setReadSpeed(readSpeed);
        long randomTime = 0L;
        long randomChecksum = 0L;
        for (int pass = 0; pass < memoryPasses; ++pass) {
            long start = System.nanoTime();
            for (int i = 0; i < arrayLength; ++i) {
                randomChecksum += array[randomIndices[i]];
            }
            randomTime += System.nanoTime() - start;
        }
        double randomSpeed = (double)arrayLength * 4.0 * (double)memoryPasses / 1048576.0 / ((double)randomTime / 1.0E9);
        benchmark.getResult().append(String.format("\n &8\u2022 &fRandom access: &e%.2f MB/s\n ", randomSpeed));
        benchmark.setRandomSpeed(randomSpeed);
        return benchmark;
    }

    private double cpuTest(int iterations) {
        double sum = 0.0;
        for (int i = 1; i <= iterations; ++i) {
            sum += Math.sqrt(i);
            sum -= Math.sin(i);
            sum *= Math.cos(i);
            sum /= Math.log(i + 1);
        }
        return sum;
    }

    public HashMap<UUID, ConfigChange> getPlayerchange() {
        return this.playerchange;
    }

    public MainMenu getMainMenu() {
        return this.mainMenu;
    }

    public ModulesMenu getModulesMenu() {
        return this.modulesMenu;
    }

    public HardwareMenu getHardwareMenu() {
        return this.hardwareMenu;
    }

    public MapHandler getMapHandler() {
        return this.mapHandler;
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean isBenchmark() {
        return this.benchmark;
    }

    public static CommandManager getInstance() {
        return instance;
    }

    public static class ConfigChange {
        private final AbstractModule module;
        private final String key;
        private final Object value;

        public ConfigChange(AbstractModule module, String key, Object value) {
            this.module = module;
            this.key = key;
            this.value = value;
        }

        public AbstractModule getModule() {
            return this.module;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigChange)) {
                return false;
            }
            ConfigChange other = (ConfigChange)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AbstractModule this$module = this.getModule();
            AbstractModule other$module = other.getModule();
            if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConfigChange;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AbstractModule $module = this.getModule();
            result = result * 59 + ($module == null ? 43 : $module.hashCode());
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "CommandManager.ConfigChange(module=" + this.getModule() + ", key=" + this.getKey() + ", value=" + this.getValue() + ")";
        }
    }

    public static class Benchmark {
        private final double[] scores;
        private StringBuilder result = new StringBuilder();
        private double cpu_checksum;
        private double bestScore;
        private double worstScore;
        private double totalScore;
        private double memory_checksum;
        private double writeSpeed;
        private double readSpeed;
        private double randomSpeed;
        private double compressionSpeed;
        private double decompressionSpeed;

        public Benchmark(int cpu) {
            this.scores = new double[cpu];
        }

        public double[] getScores() {
            return this.scores;
        }

        public StringBuilder getResult() {
            return this.result;
        }

        public double getCpu_checksum() {
            return this.cpu_checksum;
        }

        public double getBestScore() {
            return this.bestScore;
        }

        public double getWorstScore() {
            return this.worstScore;
        }

        public double getTotalScore() {
            return this.totalScore;
        }

        public double getMemory_checksum() {
            return this.memory_checksum;
        }

        public double getWriteSpeed() {
            return this.writeSpeed;
        }

        public double getReadSpeed() {
            return this.readSpeed;
        }

        public double getRandomSpeed() {
            return this.randomSpeed;
        }

        public double getCompressionSpeed() {
            return this.compressionSpeed;
        }

        public double getDecompressionSpeed() {
            return this.decompressionSpeed;
        }

        public void setResult(StringBuilder result) {
            this.result = result;
        }

        public void setCpu_checksum(double cpu_checksum) {
            this.cpu_checksum = cpu_checksum;
        }

        public void setBestScore(double bestScore) {
            this.bestScore = bestScore;
        }

        public void setWorstScore(double worstScore) {
            this.worstScore = worstScore;
        }

        public void setTotalScore(double totalScore) {
            this.totalScore = totalScore;
        }

        public void setMemory_checksum(double memory_checksum) {
            this.memory_checksum = memory_checksum;
        }

        public void setWriteSpeed(double writeSpeed) {
            this.writeSpeed = writeSpeed;
        }

        public void setReadSpeed(double readSpeed) {
            this.readSpeed = readSpeed;
        }

        public void setRandomSpeed(double randomSpeed) {
            this.randomSpeed = randomSpeed;
        }

        public void setCompressionSpeed(double compressionSpeed) {
            this.compressionSpeed = compressionSpeed;
        }

        public void setDecompressionSpeed(double decompressionSpeed) {
            this.decompressionSpeed = decompressionSpeed;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Benchmark)) {
                return false;
            }
            Benchmark other = (Benchmark)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getCpu_checksum(), other.getCpu_checksum()) != 0) {
                return false;
            }
            if (Double.compare(this.getBestScore(), other.getBestScore()) != 0) {
                return false;
            }
            if (Double.compare(this.getWorstScore(), other.getWorstScore()) != 0) {
                return false;
            }
            if (Double.compare(this.getTotalScore(), other.getTotalScore()) != 0) {
                return false;
            }
            if (Double.compare(this.getMemory_checksum(), other.getMemory_checksum()) != 0) {
                return false;
            }
            if (Double.compare(this.getWriteSpeed(), other.getWriteSpeed()) != 0) {
                return false;
            }
            if (Double.compare(this.getReadSpeed(), other.getReadSpeed()) != 0) {
                return false;
            }
            if (Double.compare(this.getRandomSpeed(), other.getRandomSpeed()) != 0) {
                return false;
            }
            if (Double.compare(this.getCompressionSpeed(), other.getCompressionSpeed()) != 0) {
                return false;
            }
            if (Double.compare(this.getDecompressionSpeed(), other.getDecompressionSpeed()) != 0) {
                return false;
            }
            if (!Arrays.equals(this.getScores(), other.getScores())) {
                return false;
            }
            StringBuilder this$result = this.getResult();
            StringBuilder other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Benchmark;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $cpu_checksum = Double.doubleToLongBits(this.getCpu_checksum());
            result = result * 59 + (int)($cpu_checksum >>> 32 ^ $cpu_checksum);
            long $bestScore = Double.doubleToLongBits(this.getBestScore());
            result = result * 59 + (int)($bestScore >>> 32 ^ $bestScore);
            long $worstScore = Double.doubleToLongBits(this.getWorstScore());
            result = result * 59 + (int)($worstScore >>> 32 ^ $worstScore);
            long $totalScore = Double.doubleToLongBits(this.getTotalScore());
            result = result * 59 + (int)($totalScore >>> 32 ^ $totalScore);
            long $memory_checksum = Double.doubleToLongBits(this.getMemory_checksum());
            result = result * 59 + (int)($memory_checksum >>> 32 ^ $memory_checksum);
            long $writeSpeed = Double.doubleToLongBits(this.getWriteSpeed());
            result = result * 59 + (int)($writeSpeed >>> 32 ^ $writeSpeed);
            long $readSpeed = Double.doubleToLongBits(this.getReadSpeed());
            result = result * 59 + (int)($readSpeed >>> 32 ^ $readSpeed);
            long $randomSpeed = Double.doubleToLongBits(this.getRandomSpeed());
            result = result * 59 + (int)($randomSpeed >>> 32 ^ $randomSpeed);
            long $compressionSpeed = Double.doubleToLongBits(this.getCompressionSpeed());
            result = result * 59 + (int)($compressionSpeed >>> 32 ^ $compressionSpeed);
            long $decompressionSpeed = Double.doubleToLongBits(this.getDecompressionSpeed());
            result = result * 59 + (int)($decompressionSpeed >>> 32 ^ $decompressionSpeed);
            result = result * 59 + Arrays.hashCode(this.getScores());
            StringBuilder $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        public String toString() {
            return "CommandManager.Benchmark(scores=" + Arrays.toString(this.getScores()) + ", result=" + this.getResult() + ", cpu_checksum=" + this.getCpu_checksum() + ", bestScore=" + this.getBestScore() + ", worstScore=" + this.getWorstScore() + ", totalScore=" + this.getTotalScore() + ", memory_checksum=" + this.getMemory_checksum() + ", writeSpeed=" + this.getWriteSpeed() + ", readSpeed=" + this.getReadSpeed() + ", randomSpeed=" + this.getRandomSpeed() + ", compressionSpeed=" + this.getCompressionSpeed() + ", decompressionSpeed=" + this.getDecompressionSpeed() + ")";
        }
    }
}

