/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.managers;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.objects.AbstractManager;
import xyz.lychee.lagfixer.utils.MessageUtils;

public class UpdaterManager
extends AbstractManager
implements Listener {
    private static UpdaterManager instance;
    private final VersionComparator comparator = new VersionComparator();
    private int compared = 0;
    private int difference = -1;
    private String latestVersion = "";
    private String currentVersion = "";
    private BukkitTask task;
    private boolean updater;

    public UpdaterManager(LagFixer plugin) {
        super(plugin);
        instance = this;
    }

    @EventHandler
    public void onClick(PlayerJoinEvent e) {
        if (e.getPlayer().isOp() && this.compared < 0 && this.updater) {
            SupportManager.getInstance().getFork().runLater(true, () -> MessageUtils.sendMessage(true, (CommandSender)e.getPlayer(), "\nPlugin needs update, latest version: &f" + this.latestVersion + "\n &8- &ehttps://www.spigotmc.org/resources/111684/\n"), 3L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void load() throws IOException {
        this.updater = this.getPlugin().getConfig().getBoolean("main.updater");
        this.task = SupportManager.getInstance().getFork().runTimer(true, () -> {
            try {
                this.latestVersion = IOUtils.toString((URI)URI.create("https://api.spigotmc.org/legacy/update.php?resource=111684"), (Charset)StandardCharsets.UTF_8).trim();
                this.currentVersion = this.getPlugin().getDescription().getVersion().split(" ")[0].trim();
                this.compared = this.comparator.compare(this.currentVersion, this.latestVersion);
                this.difference = this.comparator.difference(this.currentVersion, this.latestVersion);
                if (this.difference >= 0 && this.difference < 2) {
                    this.updater = true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.compared < 0 && this.updater) {
                this.getPlugin().getLogger().info(String.format("\n&8\u2218\u208a\u2727\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2727\u208a\u2218\n&c&lLagFixer needs an update!\n&fVersion: &e&n%s&r -> &e&n%s&r\n&ahttps://www.spigotmc.org/resources/111684/\n\n&6\u26a0 &7Updating this plugin is crucial! &6\u26a0\n&8\u2218\u208a\u2727\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2727\u208a\u2218", this.currentVersion, this.latestVersion));
            }
        }, 5L, 30L, TimeUnit.MINUTES);
        this.getPlugin().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.task != null && !this.task.isCancelled()) {
            this.task.cancel();
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public VersionComparator getComparator() {
        return this.comparator;
    }

    public int getCompared() {
        return this.compared;
    }

    public int getDifference() {
        return this.difference;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public BukkitTask getTask() {
        return this.task;
    }

    public boolean isUpdater() {
        return this.updater;
    }

    public static UpdaterManager getInstance() {
        return instance;
    }

    public static class VersionComparator
    implements Comparator<String> {
        @Override
        public int compare(String current, String latest) {
            String[] parts1 = current.split("\\.");
            String[] parts2 = latest.split("\\.");
            int length = Math.max(parts1.length, parts2.length);
            for (int i = 0; i < length; ++i) {
                int num2;
                int num1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
                int n = num2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
                if (num1 == num2) continue;
                return Integer.compare(num1, num2);
            }
            return 0;
        }

        public int difference(String current, String latest) {
            String[] parts1 = current.split("\\.");
            String[] parts2 = latest.split("\\.");
            int length = Math.max(parts1.length, parts2.length);
            for (int i = 0; i < length; ++i) {
                int num2;
                int num1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
                int n = num2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
                if (num1 >= num2) continue;
                return i;
            }
            return -1;
        }
    }
}

