/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.modules;

import com.google.common.collect.ImmutableList;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.WitherSkull;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.managers.ModuleManager;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.objects.AbstractModule;

public class ExplosionOptimizerModule
extends AbstractModule
implements Listener {
    private final EnumMap<EntityType, Float> yieldLimitPerEntity = new EnumMap(EntityType.class);
    private final Map<String, Location> recentExplosions = new ConcurrentHashMap<String, Location>();
    private final Map<String, Location> protectedLocations = new ConcurrentHashMap<String, Location>();
    private boolean yieldLimitEnabled;
    private float yieldLimitDefault;
    private boolean antiChainEnabled;
    private boolean preventTntChains;
    private boolean preventCreeperChains;
    private boolean preventCrystalChains;
    private boolean preventBlockIgnition;
    private double chainRadius;
    private double chainRadiusSquared;
    private int maxChainLength;
    private long chainCooldownMs;
    private BukkitTask antiChainCleanupTask;
    private boolean managementEnabled;
    private boolean cancelBlockExplosions;
    private boolean cancelCreepers;
    private boolean cancelCrystals;
    private boolean cancelFireballs;
    private boolean cancelTnt;
    private boolean cancelWitherSkulls;
    private boolean allowExplosionDamage;
    private boolean allowExplosionSound;
    private int cancelledExplosions = 0;

    public ExplosionOptimizerModule(LagFixer plugin, ModuleManager manager) {
        super(plugin, manager, AbstractModule.Impact.HIGH, "ExplosionOptimizer", (ImmutableList<String>)ImmutableList.of((Object)"Limits explosion power and prevents chain reactions to reduce lag and destruction.", (Object)"Useful for servers with frequent TNT, creepers, or End Crystal usage.", (Object)"Prevents excessive explosions from causing performance issues.", (Object)"Maintains stable server performance while controlling destructive events."), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDgxNzliMTc1ZGFhNzlmNzNjNjY1YjYxMTYzMzY0ZjY2MjdlM2QwMmI3MjUzZDQyN2ViZDJmZjY4MThkZTZjZSJ9fX0=");
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onExplosionPrime(@NotNull ExplosionPrimeEvent event) {
        float newYield;
        float currentYield;
        if (!this.canContinue(event.getEntity().getWorld())) {
            return;
        }
        if (this.managementEnabled && this.shouldDeactivateExplosion(event.getEntity())) {
            event.setCancelled(true);
            ++this.cancelledExplosions;
            this.handleExplosionEffects(event.getEntity(), event.getEntity().getLocation());
            return;
        }
        if (this.antiChainEnabled && this.shouldPreventChain(event.getEntity(), event.getEntity().getLocation())) {
            event.setCancelled(true);
            return;
        }
        if (this.yieldLimitEnabled && (currentYield = event.getRadius()) > (newYield = this.yieldLimitForEntity(event.getEntity(), currentYield))) {
            event.setRadius(newYield);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityExplode(@NotNull EntityExplodeEvent event) {
        float newYield;
        float currentYield;
        if (!this.canContinue(event.getLocation().getWorld()) || event.blockList().isEmpty()) {
            return;
        }
        if (this.managementEnabled && this.shouldDeactivateExplosion(event.getEntity())) {
            event.blockList().clear();
            event.setYield(0.0f);
            this.handleExplosionEffects(event.getEntity(), event.getLocation());
            return;
        }
        if (this.antiChainEnabled) {
            if (this.preventBlockIgnition) {
                event.blockList().removeIf(block -> block.getType() == Material.TNT);
            }
            this.addProtectedArea(event.getLocation());
        }
        if (this.yieldLimitEnabled && (currentYield = event.getYield()) > (newYield = this.yieldLimitForEntity(event.getEntity(), currentYield))) {
            event.setYield(newYield);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockExplode(@NotNull BlockExplodeEvent event) {
        float newYield;
        float currentYield;
        if (!this.canContinue(event.getBlock().getWorld()) || event.blockList().isEmpty()) {
            return;
        }
        if (this.managementEnabled && this.cancelBlockExplosions) {
            event.blockList().clear();
            event.setYield(0.0f);
            this.handleExplosionEffects(null, event.getBlock().getLocation());
            return;
        }
        if (this.antiChainEnabled) {
            if (this.shouldPreventBlockExplosion(event.getBlock().getLocation())) {
                event.setCancelled(true);
                return;
            }
            if (this.preventBlockIgnition) {
                event.blockList().removeIf(block -> block.getType() == Material.TNT);
            }
            this.addProtectedArea(event.getBlock().getLocation());
            this.trackExplosion(event.getBlock().getLocation());
        }
        if (this.yieldLimitEnabled && (currentYield = event.getYield()) > (newYield = Math.min(currentYield, this.yieldLimitDefault))) {
            event.setYield(newYield);
        }
    }

    private float yieldLimitForEntity(@Nullable Entity entity, float currentYield) {
        if (entity == null) {
            return Math.min(currentYield, this.yieldLimitDefault);
        }
        if (currentYield <= this.yieldLimitDefault) {
            return currentYield;
        }
        return Math.min(currentYield, this.yieldLimitPerEntity.getOrDefault(entity.getType(), Float.valueOf(this.yieldLimitDefault)).floatValue());
    }

    private boolean shouldDeactivateExplosion(Entity entity) {
        return entity instanceof TNTPrimed && this.cancelTnt || entity instanceof Creeper && this.cancelCreepers || entity instanceof EnderCrystal && this.cancelCrystals || entity instanceof WitherSkull && this.cancelWitherSkulls || entity instanceof Fireball && this.cancelFireballs;
    }

    private void handleExplosionEffects(Entity entity, Location location) {
        if (location == null || location.getWorld() == null) {
            return;
        }
        if (this.allowExplosionSound) {
            location.getWorld().playSound(location, Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
        }
        if (this.allowExplosionDamage && entity != null) {
            location.getWorld().createExplosion(location, 0.0f, false);
        }
    }

    private boolean shouldPreventChain(Entity entity, Location location) {
        if (entity instanceof TNTPrimed && !this.preventTntChains || entity instanceof Creeper && !this.preventCreeperChains || entity instanceof EnderCrystal && !this.preventCrystalChains) {
            return false;
        }
        for (Location protectedLoc : this.protectedLocations.values()) {
            if (!Objects.equals(protectedLoc.getWorld(), location.getWorld()) || !(protectedLoc.distanceSquared(location) <= this.chainRadiusSquared)) continue;
            return true;
        }
        return this.recentExplosions.containsValue(location);
    }

    private boolean shouldPreventBlockExplosion(Location location) {
        for (Location protectedLoc : this.protectedLocations.values()) {
            if (!Objects.equals(protectedLoc.getWorld(), location.getWorld()) || !(protectedLoc.distanceSquared(location) <= this.chainRadiusSquared)) continue;
            return true;
        }
        return this.recentExplosions.containsValue(location);
    }

    private void trackExplosion(Location location) {
        String locationKey = this.getLocationKey(location);
        this.recentExplosions.put(locationKey, location);
        SupportManager.getInstance().getFork().runLater(true, () -> this.recentExplosions.remove(locationKey), this.chainCooldownMs);
    }

    private void addProtectedArea(Location location) {
        String locationKey = location.toString();
        this.recentExplosions.put(locationKey, location);
        SupportManager.getInstance().getFork().runLater(true, () -> this.protectedLocations.remove(locationKey), this.chainCooldownMs);
    }

    private String getLocationKey(Location location) {
        if (location == null || location.getWorld() == null) {
            return "unknown";
        }
        long x = Math.round(location.getX() / this.chainRadius);
        long y = Math.round(location.getY() / this.chainRadius);
        long z = Math.round(location.getZ() / this.chainRadius);
        return location.getWorld().getName() + ":" + x + ":" + y + ":" + z;
    }

    @Override
    public void load() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
    }

    @Override
    public boolean loadConfig() {
        this.yieldLimitEnabled = this.getSection().getBoolean("yield_limit.enabled", true);
        if (this.yieldLimitEnabled) {
            this.yieldLimitDefault = (float)this.getSection().getDouble("yield_limit.default", 4.0);
            for (String entity : this.getSection().getStringList("yield_limit.per_entity")) {
                try {
                    String[] split = entity.split(":");
                    this.yieldLimitPerEntity.put(EntityType.valueOf((String)split[0].toUpperCase()), Float.valueOf(Float.parseFloat(split[1])));
                }
                catch (Exception e) {
                    this.getPlugin().getLogger().warning("Unknown \"" + EntityType.class.getSimpleName() + "\" enum value: " + entity);
                }
            }
        }
        this.antiChainEnabled = this.getSection().getBoolean("anti_chain.enabled", true);
        if (this.antiChainEnabled) {
            this.preventTntChains = this.getSection().getBoolean("anti_chain.prevent_tnt_chains", true);
            this.preventCreeperChains = this.getSection().getBoolean("anti_chain.prevent_creeper_chains", false);
            this.preventCrystalChains = this.getSection().getBoolean("anti_chain.prevent_crystal_chains", true);
            this.preventBlockIgnition = this.getSection().getBoolean("anti_chain.prevent_block_ignition", true);
            this.chainRadius = this.getSection().getDouble("anti_chain.chain_radius", 8.0);
            this.chainRadiusSquared = this.chainRadius * this.chainRadius;
            this.maxChainLength = this.getSection().getInt("anti_chain.max_chain_size", 3);
            this.chainCooldownMs = this.getSection().getLong("anti_chain.chain_cooldown", 1000L);
        }
        this.managementEnabled = this.getSection().getBoolean("management.enabled", false);
        if (this.managementEnabled) {
            this.cancelBlockExplosions = this.getSection().getBoolean("management.cancel_block_explosions", true);
            this.cancelCreepers = this.getSection().getBoolean("management.cancel_creepers", false);
            this.cancelCrystals = this.getSection().getBoolean("management.cancel_crystals", true);
            this.cancelFireballs = this.getSection().getBoolean("management.cancel_fireballs", true);
            this.cancelTnt = this.getSection().getBoolean("management.cancel_tnt", true);
            this.cancelWitherSkulls = this.getSection().getBoolean("management.cancel_wither_skulls", true);
            this.allowExplosionDamage = this.getSection().getBoolean("management.explosion_damage", false);
            this.allowExplosionSound = this.getSection().getBoolean("management.explosion_sound", true);
        }
        return true;
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.antiChainCleanupTask != null) {
            this.antiChainCleanupTask.cancel();
        }
        this.recentExplosions.clear();
        this.protectedLocations.clear();
    }
}

