/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.commands;

import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.managers.CommandManager;
import xyz.lychee.lagfixer.managers.ConfigManager;
import xyz.lychee.lagfixer.managers.ModuleManager;
import xyz.lychee.lagfixer.utils.MessageUtils;
import xyz.lychee.lagfixer.utils.TimingUtil;

public class ReloadCommand
extends CommandManager.Subcommand {
    public ReloadCommand(CommandManager commandManager) {
        super(commandManager, "reload", "reload all plugin configuration", new String[0]);
    }

    @Override
    public void load() {
    }

    @Override
    public void unload() {
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String[] args) {
        TimingUtil t = TimingUtil.startNew();
        LagFixer plugin = this.getCommandManager().getPlugin();
        plugin.reloadConfig();
        try {
            ConfigManager.getInstance().load();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ModuleManager.getInstance().getModules().forEach((clazz, m) -> {
            boolean enabled = m.getConfig().getBoolean(m.getName() + ".enabled");
            try {
                if (enabled) {
                    if (!m.isLoaded()) {
                        m.load();
                        m.setLoaded(true);
                    }
                    m.loadAllConfig();
                    plugin.getLogger().info("&rConfiguration for &e" + m.getName() + " &rsuccessfully reloaded!");
                } else if (m.isLoaded()) {
                    m.disable();
                    m.setLoaded(false);
                    plugin.getLogger().info("&rSuccessfully disabled module &e" + m.getName() + "&r!");
                }
                m.getMenu().updateAll();
            }
            catch (Exception ex) {
                plugin.printError(ex);
                plugin.getLogger().info("&rError reloading configuration for &c" + m.getName() + "&r!");
            }
        });
        MessageUtils.sendMessage(true, sender, "&7Reloaded some configurations in &f" + t.stop().getExecutingTime() + "&7ms.\n \n &7Working methods to apply all changes:\n  &8{*} &7Server restart (&frecommended&7)\n  &8{*} &7All plugins reload, command: &f/reload confirm\n  &8{*} &7Plugman reload, command: &f/plugman reload LagFixer");
        return true;
    }
}

