/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.nms.v1_16_R3;

import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.server.v1_16_R3.Blocks;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityAnimal;
import net.minecraft.server.v1_16_R3.EntityCat;
import net.minecraft.server.v1_16_R3.EntityChicken;
import net.minecraft.server.v1_16_R3.EntityCow;
import net.minecraft.server.v1_16_R3.EntityCreature;
import net.minecraft.server.v1_16_R3.EntityFox;
import net.minecraft.server.v1_16_R3.EntityHorse;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.EntityLiving;
import net.minecraft.server.v1_16_R3.EntityLlama;
import net.minecraft.server.v1_16_R3.EntityMushroomCow;
import net.minecraft.server.v1_16_R3.EntityOcelot;
import net.minecraft.server.v1_16_R3.EntityPanda;
import net.minecraft.server.v1_16_R3.EntityParrot;
import net.minecraft.server.v1_16_R3.EntityPig;
import net.minecraft.server.v1_16_R3.EntityRabbit;
import net.minecraft.server.v1_16_R3.EntitySheep;
import net.minecraft.server.v1_16_R3.EntityStrider;
import net.minecraft.server.v1_16_R3.Item;
import net.minecraft.server.v1_16_R3.Items;
import net.minecraft.server.v1_16_R3.PathfinderGoal;
import net.minecraft.server.v1_16_R3.PathfinderGoalBreed;
import net.minecraft.server.v1_16_R3.PathfinderGoalSelector;
import net.minecraft.server.v1_16_R3.PathfinderGoalTempt;
import net.minecraft.server.v1_16_R3.PathfinderGoalWrapped;
import net.minecraft.server.v1_16_R3.PathfinderTargetCondition;
import org.apache.commons.lang.StringUtils;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.modules.MobAiReducerModule;
import xyz.lychee.lagfixer.utils.ReflectionUtils;

public class MobAiReducer
extends MobAiReducerModule.NMS
implements Listener {
    private final Map<EntityCreature, Boolean> optimizedMobs = new MapMaker().weakKeys().concurrencyLevel(4).makeMap();
    private final HashMap<Class<? extends Entity>, PathfinderTargetCondition> temptTargeting = new HashMap();
    private final PathfinderTargetCondition breedTargeting = new PathfinderTargetCondition().a().b().d().c();
    private final Field fieldGoals = ReflectionUtils.getPrivateField(PathfinderGoalSelector.class, Set.class);

    public MobAiReducer(MobAiReducerModule module) {
        super(module);
    }

    @Override
    public void load() {
        this.breedTargeting.a(this.getModule().getBreedRange());
        this.register(EntityCow.class, Items.WHEAT);
        this.register(EntityMushroomCow.class, Items.WHEAT);
        this.register(EntitySheep.class, Items.WHEAT);
        this.register(EntityPig.class, Items.CARROT, Items.POTATO, Items.BEETROOT);
        this.register(EntityChicken.class, Items.WHEAT_SEEDS, Items.MELON_SEEDS, Items.PUMPKIN_SEEDS, Items.BEETROOT_SEEDS);
        this.register(EntityRabbit.class, Items.CARROT, Items.GOLDEN_CARROT);
        this.register(EntityHorse.class, Items.APPLE, Items.GOLDEN_APPLE, Items.GOLDEN_CARROT, Items.SUGAR, Items.WHEAT);
        this.register(EntityLlama.class, Items.WHEAT, Blocks.HAY_BLOCK.getItem());
        this.register(EntityParrot.class, Items.WHEAT_SEEDS, Items.MELON_SEEDS, Items.PUMPKIN_SEEDS, Items.BEETROOT_SEEDS);
        this.register(EntityOcelot.class, Items.COD, Items.SALMON);
        this.register(EntityCat.class, Items.COD, Items.SALMON);
        this.register(EntityPanda.class, Blocks.BAMBOO.getItem());
        this.register(EntityFox.class, Items.SWEET_BERRIES);
        this.register(EntityStrider.class, Items.bx, Items.WARPED_FUNGUS_ON_A_STICK);
    }

    private void register(Class<? extends Entity> clazz, Item ... items) {
        HashSet itemSet = Sets.newHashSet((Object[])items);
        this.temptTargeting.computeIfAbsent(clazz, k -> new PathfinderTargetCondition().a().b().d().c()).a(this.getModule().getTemptRange()).a(entity -> itemSet.contains(entity.getItemInMainHand().getItem()) || this.getModule().isTemptTriggerBothHands() && itemSet.contains(entity.getItemInOffHand().getItem()));
    }

    @Override
    public void optimize(org.bukkit.entity.Entity ent, boolean init) {
        PathfinderTargetCondition temptTargeting;
        if (!(ent instanceof CraftCreature)) {
            return;
        }
        EntityCreature handle = ((CraftCreature)ent).getHandle();
        if (this.optimizedMobs.containsKey(handle)) {
            return;
        }
        MobAiReducerModule module = this.getModule();
        boolean keepDedicated = module.isKeep_dedicated();
        boolean aiListMode = module.isAi_list_mode();
        HashSet<String> aiList = module.getAi_list();
        handle.collides = module.isCollides();
        handle.setSilent(module.isSilent());
        this.optimizedMobs.put(handle, Boolean.TRUE);
        boolean isAnimal = handle instanceof EntityAnimal;
        Class<?> handleClass = handle.getClass();
        PathfinderTargetCondition pathfinderTargetCondition = temptTargeting = module.isTemptEnabled() ? this.temptTargeting.get(handleClass) : null;
        if (this.fieldGoals == null) {
            return;
        }
        try {
            Set goals = (Set)this.fieldGoals.get(handle.goalSelector);
            HashSet<PathfinderGoalWrapped> toAdd = new HashSet<PathfinderGoalWrapped>();
            HashSet<PathfinderGoalWrapped> toRemove = new HashSet<PathfinderGoalWrapped>();
            for (PathfinderGoalWrapped pgw : goals) {
                PathfinderGoal goal = pgw.j();
                Class<?> goalClass = goal.getClass();
                if (keepDedicated && !StringUtils.contains((String)goalClass.getName(), (char)'$')) continue;
                if (isAnimal && module.isBreedEnabled() && goalClass == PathfinderGoalBreed.class) {
                    toRemove.add(pgw);
                    toAdd.add(new PathfinderGoalWrapped(pgw.h(), (PathfinderGoal)new OptimizedBreedGoal((EntityAnimal)handle)));
                    continue;
                }
                if (module.isTemptEnabled() && goalClass == PathfinderGoalTempt.class && temptTargeting != null) {
                    toRemove.add(pgw);
                    toAdd.add(new PathfinderGoalWrapped(pgw.h(), (PathfinderGoal)new OptimizedTemptGoal(handle, temptTargeting)));
                    continue;
                }
                String simpleName = goalClass.getSimpleName();
                if (aiList.stream().anyMatch(simpleName::contains) != aiListMode) continue;
                toRemove.add(pgw);
            }
            if (!toRemove.isEmpty()) {
                goals.removeAll(toRemove);
            }
            if (!toAdd.isEmpty()) {
                goals.addAll(toAdd);
            }
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge() {
        Map<EntityCreature, Boolean> map = this.optimizedMobs;
        synchronized (map) {
            this.optimizedMobs.keySet().removeIf(ent -> !ent.isAlive() || !ent.valid);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onSpawn(ChunkLoadEvent e) {
        if (!this.getModule().canContinue(e.getWorld())) {
            return;
        }
        SupportManager.getInstance().getExecutor().execute(() -> {
            org.bukkit.entity.Entity[] entities;
            for (org.bukkit.entity.Entity entity : entities = e.getChunk().getEntities()) {
                if (!this.getModule().isEnabled(entity)) continue;
                this.optimize(entity, false);
            }
        });
    }

    public void removeGoals(Set<PathfinderGoalWrapped> goals, Predicate<PathfinderGoalWrapped> filter) {
        Iterator<PathfinderGoalWrapped> it = goals.iterator();
        while (it.hasNext()) {
            PathfinderGoalWrapped wg = it.next();
            if (wg == null || !filter.test(wg)) continue;
            wg.d();
            it.remove();
        }
    }

    public class OptimizedBreedGoal
    extends PathfinderGoal {
        protected final EntityAnimal animal;
        protected EntityAnimal partner;

        public OptimizedBreedGoal(EntityAnimal entityanimal) {
            this.animal = entityanimal;
            this.a(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        public boolean a() {
            if (this.animal.isInLove()) {
                EntityAnimal freePartner;
                this.partner = freePartner = this.getFreePartner();
                return freePartner != null;
            }
            return false;
        }

        public boolean b() {
            return this.partner.isAlive() && this.partner.isInLove();
        }

        public void e() {
            if (MobAiReducer.this.getModule().isBreedTeleport()) {
                this.animal.enderTeleportTo(this.partner.locX(), this.partner.locY(), this.partner.locZ());
            } else {
                this.animal.getNavigation().a((Entity)this.partner, MobAiReducer.this.getModule().getBreedSpeed());
            }
            this.animal.a(this.animal.getWorld().getMinecraftWorld(), this.partner);
        }

        private EntityAnimal getFreePartner() {
            List nearbyEntities = this.animal.getWorld().a(this.animal.getClass(), MobAiReducer.this.breedTargeting, (EntityLiving)this.animal, this.animal.getBoundingBox().g(8.0));
            if (nearbyEntities.isEmpty()) {
                return null;
            }
            Stream stream = nearbyEntities.stream();
            EntityAnimal entityAnimal = this.animal;
            Objects.requireNonNull(entityAnimal);
            return stream.filter(arg_0 -> ((EntityAnimal)entityAnimal).mate(arg_0)).min(Comparator.comparingDouble(other -> other.h((Entity)this.animal))).orElse(null);
        }
    }

    public class OptimizedTemptGoal
    extends PathfinderGoal {
        private final EntityCreature mob;
        private final PathfinderTargetCondition targeting;
        private int cooldown = 0;

        public OptimizedTemptGoal(EntityCreature mob, PathfinderTargetCondition targeting) {
            this.mob = mob;
            this.targeting = targeting;
            this.a(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        public boolean a() {
            return --this.cooldown <= 0;
        }

        public void e() {
            this.cooldown = MobAiReducer.this.getModule().getTemptCooldown();
            EntityHuman player = this.mob.getWorld().a(this.targeting, (EntityLiving)this.mob);
            if (player != null) {
                EntityTargetLivingEntityEvent event;
                if (MobAiReducer.this.getModule().isTemptEvent() && (event = CraftEventFactory.callEntityTargetLivingEvent((Entity)this.mob, (EntityLiving)player, (EntityTargetEvent.TargetReason)EntityTargetEvent.TargetReason.TEMPT)).isCancelled()) {
                    return;
                }
                if (this.mob.h((Entity)player) >= 6.25 || MobAiReducer.this.getModule().isTemptTeleport()) {
                    if (MobAiReducer.this.getModule().isTemptTeleport()) {
                        this.mob.enderTeleportTo(player.locX(), player.locY(), player.locZ());
                    } else {
                        this.mob.getNavigation().a((Entity)player, this.mob instanceof EntityAnimal ? MobAiReducer.this.getModule().getTemptSpeed() : 0.35);
                    }
                    return;
                }
                this.mob.getNavigation().o();
            }
        }
    }
}

