/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.Component;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.minimessage.MiniMessage;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import xyz.lychee.lagfixer.managers.ConfigManager;
import xyz.lychee.lagfixer.objects.AbstractModule;

public class Language {
    private static final YamlConfiguration yaml = new YamlConfiguration();
    private static final LegacyComponentSerializer serializer;
    private static final Map<String, String> mainValues;
    private final AbstractModule module;
    private final Map<String, String> values = new HashMap<String, String>();

    public Language(AbstractModule module) {
        this.module = module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static YamlConfiguration loadLangYaml(LagFixer plugin) {
        File file = new File(plugin.getDataFolder(), "lang.yml");
        if (!file.exists() || file.getParentFile().mkdirs()) {
            plugin.saveResource("lang.yml", false);
        }
        try (InputStream is = plugin.getResource("lang.yml");){
            yaml.load(file);
            if (is == null) {
                YamlConfiguration yamlConfiguration2 = null;
                return yamlConfiguration2;
            }
            YamlConfiguration defaults = new YamlConfiguration();
            defaults.load((Reader)new InputStreamReader(is, StandardCharsets.UTF_8));
            YamlConfiguration yamlConfiguration = defaults;
            return yamlConfiguration;
        }
        catch (IOException | InvalidConfigurationException ex) {
            plugin.printError(ex);
            return null;
        }
    }

    public static Component getMainValue(String key, boolean prefix, TagResolver.Single ... placeholders) {
        if (!mainValues.containsKey(key)) {
            return null;
        }
        Component component = MiniMessage.miniMessage().deserialize(mainValues.get(key), placeholders);
        return prefix ? Component.textOfChildren(ConfigManager.getInstance().getPrefix(), component) : component;
    }

    public void loadMessages() {
        ConfigurationSection section = yaml.getConfigurationSection("messages." + this.module.getName());
        if (section == null) {
            return;
        }
        this.values.clear();
        section.getValues(true).forEach((key, value) -> {
            if (value instanceof String) {
                this.values.put((String)key, (String)value);
            }
        });
    }

    public boolean hasTranslation(String key) {
        return this.values.containsKey(key);
    }

    public Component getComponent(String key, boolean prefix, TagResolver.Single ... placeholders) {
        if (!this.values.containsKey(key)) {
            return null;
        }
        Component component = MiniMessage.miniMessage().deserialize(this.values.get(key), placeholders);
        return prefix ? Component.textOfChildren(ConfigManager.getInstance().getPrefix(), component) : component;
    }

    public String getString(String key, boolean prefix, TagResolver.Single ... placeholders) {
        Component component = this.getComponent(key, prefix, placeholders);
        return component == null ? null : Language.getSerializer().serialize(component);
    }

    public AbstractModule getModule() {
        return this.module;
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public static YamlConfiguration getYaml() {
        return yaml;
    }

    public static LegacyComponentSerializer getSerializer() {
        return serializer;
    }

    public static Map<String, String> getMainValues() {
        return mainValues;
    }

    static {
        mainValues = new HashMap<String, String>();
        serializer = LegacyComponentSerializer.builder().character('&').hexCharacter('#').hexColors().useUnusualXRepeatedCharacterHexFormat().build();
    }
}

