/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.hooks;

import dev.rosewood.rosestacker.api.RoseStackerAPI;
import dev.rosewood.rosestacker.stack.StackedItem;
import java.util.List;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.managers.HookManager;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.objects.AbstractHook;
import xyz.lychee.lagfixer.objects.AbstractStacker;

public class RoseStackerHook
extends AbstractHook {
    private static RoseStackerHook instance;

    public RoseStackerHook(LagFixer plugin, HookManager manager) {
        super(plugin, "RoseStacker", manager);
        instance = this;
    }

    @Override
    public void load() {
        SupportManager.getInstance().setStacker(new StackerImplementation());
    }

    @Override
    public void disable() {
    }

    public static RoseStackerHook getInstance() {
        return instance;
    }

    public static class StackerImplementation
    extends AbstractStacker {
        @Override
        public void addItemsToList(Item bItem, List<ItemStack> items) {
            StackedItem item = RoseStackerAPI.getInstance().getStackedItem(bItem);
            if (item != null) {
                int max;
                ItemStack is = bItem.getItemStack();
                int amount = item.getStackSize();
                if (amount <= (max = is.getMaxStackSize())) {
                    ItemStack clone = is.clone();
                    clone.setAmount(amount);
                    items.add(clone);
                } else {
                    for (int i = amount; i > 0; i -= max) {
                        ItemStack clone = is.clone();
                        clone.setAmount(Math.min(i, max));
                        items.add(clone);
                    }
                }
                return;
            }
            items.add(bItem.getItemStack());
        }
    }
}

