/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.hooks;

import com.craftaro.ultimatestacker.api.UltimateStackerApi;
import com.craftaro.ultimatestacker.api.stack.item.StackedItem;
import java.util.List;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.managers.HookManager;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.objects.AbstractHook;
import xyz.lychee.lagfixer.objects.AbstractStacker;

public class UltimateStackerHook
extends AbstractHook {
    private static UltimateStackerHook instance;

    public UltimateStackerHook(LagFixer plugin, HookManager manager) {
        super(plugin, "UltimateStacker", manager);
        instance = this;
    }

    @Override
    public void load() {
        SupportManager.getInstance().setStacker(new StackerImplementation());
    }

    @Override
    public void disable() {
    }

    public static UltimateStackerHook getInstance() {
        return instance;
    }

    public static class StackerImplementation
    extends AbstractStacker {
        @Override
        public void addItemsToList(Item bItem, List<ItemStack> items) {
            StackedItem item = UltimateStackerApi.getStackedItemManager().getStackedItem(bItem);
            if (item.isValid()) {
                int max;
                ItemStack is = bItem.getItemStack();
                int amount = item.getAmount();
                if (amount <= (max = is.getMaxStackSize())) {
                    ItemStack clone = is.clone();
                    clone.setAmount(amount);
                    items.add(clone);
                } else {
                    for (int i = amount; i > 0; i -= max) {
                        ItemStack clone = is.clone();
                        clone.setAmount(Math.min(i, max));
                        items.add(clone);
                    }
                }
                return;
            }
            items.add(bItem.getItemStack());
        }
    }
}

