/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.managers;

import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.Language;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.Component;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.TextComponent;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.event.ClickEvent;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.event.HoverEvent;
import xyz.lychee.lagfixer.objects.AbstractManager;
import xyz.lychee.lagfixer.utils.MessageUtils;

public class ConfigManager
extends AbstractManager
implements Listener {
    private static ConfigManager instance;
    private TextComponent prefix;
    private String legacyPrefix;

    public ConfigManager(LagFixer plugin) {
        super(plugin);
        instance = this;
    }

    @Override
    public void load() throws IOException {
        YamlConfiguration defLang;
        this.getPlugin().saveDefaultConfig();
        Configuration defConfig = this.getPlugin().getConfig().getDefaults();
        if (defConfig != null) {
            defConfig.getValues(true).entrySet().stream().filter(entry -> {
                String[] args = ((String)entry.getKey()).split("\\.");
                return !args[args.length - 1].matches("-?\\d+") && !this.getPlugin().getConfig().isSet((String)entry.getKey());
            }).forEach(entry -> {
                this.getPlugin().getConfig().set((String)entry.getKey(), entry.getValue());
                this.getPlugin().getLogger().info(" &8\u2022 &rConfiguration loader overrided key &8'&e" + (String)entry.getKey() + "&8' &7\u2192 &6" + entry.getValue());
            });
            this.getPlugin().getConfig().getValues(true).entrySet().stream().filter(entry -> {
                String[] args = ((String)entry.getKey()).split("\\.");
                return !args[args.length - 1].matches("-?\\d+") && !defConfig.isSet((String)entry.getKey());
            }).forEach(entry -> {
                this.getPlugin().getConfig().set((String)entry.getKey(), null);
                this.getPlugin().getLogger().info(" &8\u2022 &rConfiguration loader removed key &8'&e" + (String)entry.getKey() + "&8'");
            });
            this.getPlugin().saveConfig();
            this.getPlugin().reloadConfig();
        }
        if ((defLang = Language.loadLangYaml(this.getPlugin())) != null) {
            defLang.getValues(true).entrySet().stream().filter(entry -> {
                String[] args = ((String)entry.getKey()).split("\\.");
                return !args[args.length - 1].matches("-?\\d+") && !Language.getYaml().isSet((String)entry.getKey());
            }).forEach(entry -> {
                Language.getYaml().set((String)entry.getKey(), entry.getValue());
                this.getPlugin().getLogger().info(" &8\u2022 &rLanguage loader overrided key &8'&e" + (String)entry.getKey() + "&8' &7\u2192 &6" + entry.getValue());
            });
            Language.getYaml().getValues(true).entrySet().stream().filter(entry -> {
                String[] args = ((String)entry.getKey()).split("\\.");
                return !args[args.length - 1].matches("-?\\d+") && !defLang.isSet((String)entry.getKey());
            }).forEach(entry -> {
                Language.getYaml().set((String)entry.getKey(), null);
                this.getPlugin().getLogger().info(" &8\u2022 &rLanguage loader removed key &8'&e" + (String)entry.getKey() + "&8'");
            });
            Language.getYaml().save(new File(this.getPlugin().getDataFolder(), "lang.yml"));
        }
        Language.getMainValues().clear();
        Language.getYaml().getConfigurationSection("messages.Main").getValues(true).forEach((key, val) -> {
            if (val instanceof String) {
                Language.getMainValues().put((String)key, (String)val);
            }
        });
        this.legacyPrefix = MessageUtils.fixColors(null, this.getPlugin().getConfig().getString("main.prefix"));
        this.prefix = (TextComponent)Component.text(this.legacyPrefix).clickEvent(ClickEvent.openUrl("https://modrinth.com/plugin/lagfixer"));
        if (this.getPlugin().getConfig().getBoolean("main.prefix_hover")) {
            this.prefix = (TextComponent)this.prefix.hoverEvent(HoverEvent.showText(Component.text(MessageUtils.fixColors(null, this.legacyPrefix + "&fLagFixer &e" + this.getPlugin().getDescription().getVersion() + "\n &8{*} &7Click to open plugin in spigotmc!"))));
        }
    }

    @Override
    public void disable() {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public TextComponent getPrefix() {
        return this.prefix;
    }

    public String getLegacyPrefix() {
        return this.legacyPrefix;
    }

    public static ConfigManager getInstance() {
        return instance;
    }
}

