/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.managers;

import java.util.HashMap;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.hooks.PlaceholderAPIHook;
import xyz.lychee.lagfixer.hooks.RoseStackerHook;
import xyz.lychee.lagfixer.hooks.SparkHook;
import xyz.lychee.lagfixer.hooks.UltimateStackerHook;
import xyz.lychee.lagfixer.hooks.WildStackerHook;
import xyz.lychee.lagfixer.objects.AbstractHook;
import xyz.lychee.lagfixer.objects.AbstractManager;
import xyz.lychee.lagfixer.utils.TimingUtil;

public class HookManager
extends AbstractManager {
    private final HashMap<String, AbstractHook> hooks = new HashMap();

    public HookManager(LagFixer plugin) {
        super(plugin);
        this.add(new PlaceholderAPIHook(plugin, this));
        this.add(new SparkHook(plugin, this));
        this.add(new WildStackerHook(plugin, this));
        this.add(new RoseStackerHook(plugin, this));
        this.add(new UltimateStackerHook(plugin, this));
    }

    protected void add(AbstractHook hook) {
        this.hooks.put(hook.getName(), hook);
    }

    @Override
    public void load() {
        for (AbstractHook hook : this.hooks.values()) {
            if (!hook.isEnabled()) {
                this.getPlugin().getLogger().info(" &8\u2022 &rSkipping hook " + hook.getName() + ", reason: Plugin not found");
                continue;
            }
            try {
                TimingUtil t = TimingUtil.startNew();
                hook.load();
                hook.setLoaded(true);
                this.getPlugin().getLogger().info(" &8\u2022 &rSucessfully loaded hook " + hook.getName() + " in " + t.stop().getExecutingTime() + "ms!");
            }
            catch (Exception ex) {
                this.getPlugin().getLogger().info(" &8\u2022 &cError with enabling hook " + hook.getName() + ", reason: " + ex.getMessage());
                this.getPlugin().printError(ex);
            }
        }
    }

    @Override
    public void disable() {
        for (AbstractHook hook : this.hooks.values()) {
            if (!hook.isEnabled()) continue;
            try {
                TimingUtil t = TimingUtil.startNew();
                hook.disable();
                hook.setLoaded(false);
                this.getPlugin().getLogger().info(" &8\u2022 &rSucessfully disabled hook " + hook.getName() + " in " + t.stop().getExecutingTime() + "ms!");
            }
            catch (Exception ex) {
                this.getPlugin().getLogger().info(" &8\u2022 &cError with disabling hook " + hook.getName() + ", reason: " + ex.getMessage());
                this.getPlugin().printError(ex);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

