/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.managers;

import java.util.HashMap;
import org.bukkit.Bukkit;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.modules.ConsoleFilterModule;
import xyz.lychee.lagfixer.modules.EntityLimiterModule;
import xyz.lychee.lagfixer.modules.InstantLeafDecayModule;
import xyz.lychee.lagfixer.modules.LagMonitorModule;
import xyz.lychee.lagfixer.modules.MobAiReducerModule;
import xyz.lychee.lagfixer.modules.RedstoneLimiterModule;
import xyz.lychee.lagfixer.modules.VehicleMotionReducerModule;
import xyz.lychee.lagfixer.modules.WorldCleanerModule;
import xyz.lychee.lagfixer.objects.AbstractManager;
import xyz.lychee.lagfixer.objects.AbstractModule;
import xyz.lychee.lagfixer.utils.TimingUtil;

public class ModuleManager
extends AbstractManager {
    private static ModuleManager instance;
    private final HashMap<Class<? extends AbstractModule>, AbstractModule> modules = new HashMap();

    public ModuleManager(LagFixer plugin) {
        super(plugin);
        instance = this;
        this.add(new MobAiReducerModule(plugin, this), new LagMonitorModule(plugin, this), new RedstoneLimiterModule(plugin, this), new EntityLimiterModule(plugin, this), new ConsoleFilterModule(plugin, this), new WorldCleanerModule(plugin, this), new VehicleMotionReducerModule(plugin, this), new InstantLeafDecayModule(plugin, this));
    }

    public <T extends AbstractModule> T get(Class<?> clazz) {
        return (T)((AbstractModule)clazz.cast(this.modules.get(clazz)));
    }

    private void add(AbstractModule ... arrModules) {
        for (AbstractModule module : arrModules) {
            this.modules.put(module.getClass(), module);
        }
    }

    @Override
    public void load() {
        for (AbstractModule module : this.modules.values()) {
            try {
                TimingUtil t = TimingUtil.startNew();
                boolean enabled = this.getPlugin().getConfig().getBoolean("modules." + module.getName() + ".enabled");
                boolean success = module.loadAllConfig();
                if (enabled) {
                    module.load();
                    if (success) {
                        this.getPlugin().getLogger().info(" &8\u2022 &rSucessfully loaded module " + module.getName() + " in " + t.stop().getExecutingTime() + "ms.");
                    } else {
                        this.getPlugin().getLogger().info(" &8\u2022 &rSkipping unsupported module " + module.getName() + " for " + Bukkit.getServer().getBukkitVersion() + ".");
                    }
                }
                module.setLoaded(success && enabled);
                module.getMenu().update();
                Thread.yield();
            }
            catch (Exception ex) {
                module.setLoaded(false);
                this.getPlugin().getLogger().info(" &8\u2022 &cSkipping module " + module.getName() + ", reason: " + ex.getMessage());
                this.getPlugin().printError(ex);
            }
        }
    }

    @Override
    public void disable() {
        for (AbstractModule module : this.modules.values()) {
            if (!module.isLoaded()) continue;
            try {
                TimingUtil t = TimingUtil.startNew();
                module.disable();
                this.getPlugin().getLogger().info(" \u2022 Sucessfully disabled module " + module.getName() + " in " + t.stop().getExecutingTime() + "ms.");
                Thread.yield();
            }
            catch (Exception ex) {
                this.getPlugin().getLogger().info(" \u2022 Error with disabling module " + module.getName() + ", reason: " + ex.getMessage());
                this.getPlugin().printError(ex);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public HashMap<Class<? extends AbstractModule>, AbstractModule> getModules() {
        return this.modules;
    }

    public static ModuleManager getInstance() {
        return instance;
    }
}

