/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.managers;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.RandomStringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.GameRule;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.managers.ModuleManager;
import xyz.lychee.lagfixer.modules.MobAiReducerModule;
import xyz.lychee.lagfixer.modules.VehicleMotionReducerModule;
import xyz.lychee.lagfixer.objects.AbstractFork;
import xyz.lychee.lagfixer.objects.AbstractManager;
import xyz.lychee.lagfixer.objects.AbstractMonitor;
import xyz.lychee.lagfixer.objects.AbstractStacker;
import xyz.lychee.lagfixer.objects.AbstractSupportNms;
import xyz.lychee.lagfixer.utils.ReflectionUtils;

public class SupportManager
extends AbstractManager
implements Listener {
    private static final Map<String, EntityType> entities = Arrays.stream(EntityType.values()).collect(Collectors.toMap(Enum::name, Function.identity()));
    private static SupportManager instance;
    private final Map<String, String> versions;
    private final Map<World, HashSet<LivingEntity>> entityMap = new HashMap<World, HashSet<LivingEntity>>();
    private final Map<World, HashSet<Item>> itemMap = new HashMap<World, HashSet<Item>>();
    private final Map<World, HashSet<Vehicle>> vehicleMap = new HashMap<World, HashSet<Vehicle>>();
    private final Map<World, HashSet<Projectile>> projectileMap = new HashMap<World, HashSet<Projectile>>();
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> task = null;
    private AbstractFork fork = null;
    private AbstractSupportNms nms = null;
    private AbstractStacker stacker = null;
    private AbstractMonitor monitor = new StandardMonitor();

    public SupportManager(LagFixer plugin) {
        super(plugin);
        instance = this;
        this.versions = new HashMap<String, String>();
        this.versions.put("1.20.5", "v1_20_R4");
        this.versions.put("1.20.6", "v1_20_R4");
        this.versions.put("1.21", "v1_21_R1");
        this.versions.put("1.21.1", "v1_21_R1");
        this.versions.put("1.21.2", "v1_21_R2");
        this.versions.put("1.21.3", "v1_21_R2");
        this.versions.put("1.21.4", "v1_21_R3");
    }

    public HashSet<LivingEntity> getCreatureSet(World world) {
        return this.entityMap.computeIfAbsent(world, k -> new HashSet());
    }

    public HashSet<Item> getItemSet(World world) {
        return this.itemMap.computeIfAbsent(world, k -> new HashSet());
    }

    public HashSet<Projectile> getProjectileSet(World world) {
        return this.projectileMap.computeIfAbsent(world, k -> new HashSet());
    }

    public HashSet<Vehicle> getVehicleSet(World world) {
        return this.vehicleMap.computeIfAbsent(world, k -> new HashSet());
    }

    public int getCreatureCount() {
        return this.entityMap.values().stream().mapToInt(Set::size).sum();
    }

    public int getItemCount() {
        return this.itemMap.values().stream().mapToInt(Set::size).sum();
    }

    public int getProjectileCount() {
        return this.projectileMap.values().stream().mapToInt(Set::size).sum();
    }

    public int getVehicleCount() {
        return this.vehicleMap.values().stream().mapToInt(Set::size).sum();
    }

    @Override
    public void load() {
        FileConfiguration cfg = this.getPlugin().getConfig();
        int threads = cfg.getInt("main.threads", 1);
        if (threads > 1) {
            this.executor = Executors.newScheduledThreadPool(threads);
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
        try {
            Stream.of("xyz.lychee.lagfixer.support.Spigot", "xyz.lychee.lagfixer.support.Paper").map(name -> {
                try {
                    Class<?> clazz = Class.forName(name);
                    AbstractFork fork = (AbstractFork)clazz.getConstructor(Plugin.class).newInstance(new Object[]{this.getPlugin()});
                    if (fork.isSupported()) {
                        return fork;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }).filter(Objects::nonNull).max(Comparator.comparingInt(AbstractFork::getPriority)).ifPresent(fork -> {
                this.fork = fork;
                this.getPlugin().getLogger().info(" &8\u2022 &rLoaded fork support ~ " + this.fork.getClass().getCanonicalName());
            });
            String version = ReflectionUtils.getVersion("SupportNms");
            Class<?> clazz2 = Class.forName("xyz.lychee.lagfixer.nms." + version + ".SupportNms");
            this.nms = (AbstractSupportNms)clazz2.getConstructor(Plugin.class).newInstance(new Object[]{this.getPlugin()});
            Bukkit.getPluginManager().registerEvents((Listener)this.nms, (Plugin)this.getPlugin());
            this.getPlugin().getLogger().info(" &8\u2022 &rLoaded nms support ~ " + this.nms.getClass().getCanonicalName());
        }
        catch (Exception ex) {
            this.getPlugin().getLogger().info("   &cOptimal support not found, the plugin will use deprecated methods!");
            this.getPlugin().getLogger().info("   &7Supported versions: &e1.16.5, 1.17.1, 1.18.2, 1.19.4, 1.20.x, 1.21-1.21.5");
            this.nms = new DeprecatedBukkitSupport((Plugin)this.getPlugin());
        }
        Bukkit.getWorlds().forEach(world -> {
            this.entityMap.put((World)world, new HashSet(world.getLivingEntities()));
            this.itemMap.put((World)world, new HashSet(world.getEntitiesByClass(Item.class)));
            this.projectileMap.put((World)world, new HashSet(world.getEntitiesByClass(Projectile.class)));
            this.vehicleMap.put((World)world, new HashSet(world.getEntitiesByClass(Vehicle.class)));
        });
        this.getPlugin().getLogger().info(" &8\u2022 &rLoaded creatures " + this.getCreatureCount() + " to creature container!");
        this.getPlugin().getLogger().info(" &8\u2022 &rLoaded items " + this.getItemCount() + " to item container!");
        this.getPlugin().getLogger().info(" &8\u2022 &rLoaded projectiles " + this.getProjectileCount() + " to projectile container!");
        this.getPlugin().getLogger().info(" &8\u2022 &rLoaded vehicles " + this.getVehicleCount() + " to vehicle container!");
        this.task = this.executor.scheduleAtFixedRate(() -> {
            this.entityMap.values().forEach(set -> set.removeIf(ent -> !ent.isValid()));
            this.itemMap.values().forEach(set -> set.removeIf(ent -> !ent.isValid()));
            this.projectileMap.values().forEach(set -> set.removeIf(ent -> !ent.isValid()));
            this.vehicleMap.values().forEach(set -> set.removeIf(ent -> !ent.isValid()));
        }, 1L, 1L, TimeUnit.MINUTES);
        this.monitor.start(cfg.getInt("main.monitor_interval"));
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.task != null) {
            this.task.cancel(true);
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        this.executor.execute(() -> {
            HashSet<LivingEntity> set = this.getCreatureSet(event.getLocation().getWorld());
            set.add(event.getEntity());
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onItemSpawn(ItemSpawnEvent event) {
        this.executor.execute(() -> {
            HashSet<Item> set = this.getItemSet(event.getLocation().getWorld());
            set.add(event.getEntity());
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onShoot(EntityShootBowEvent event) {
        this.executor.execute(() -> {
            HashSet<Projectile> set = this.getProjectileSet(event.getProjectile().getWorld());
            set.add((Projectile)event.getProjectile());
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPickup(PlayerPickupArrowEvent event) {
        this.executor.execute(() -> {
            HashSet<Projectile> set = this.getProjectileSet(event.getArrow().getWorld());
            set.remove(event.getArrow());
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onLaunch(ProjectileLaunchEvent event) {
        this.executor.execute(() -> {
            HashSet<Projectile> set = this.getProjectileSet(event.getLocation().getWorld());
            set.add(event.getEntity());
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDespawn(ItemDespawnEvent event) {
        this.executor.execute(() -> {
            HashSet<Item> set = this.getItemSet(event.getLocation().getWorld());
            set.remove(event.getEntity());
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDeath(EntityDeathEvent event) {
        this.executor.execute(() -> {
            HashSet<LivingEntity> set = this.getCreatureSet(event.getEntity().getWorld());
            set.remove(event.getEntity());
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onHit(ProjectileHitEvent event) {
        this.executor.execute(() -> {
            if (event.getEntity() instanceof Arrow) {
                return;
            }
            HashSet<Projectile> set = this.getProjectileSet(event.getEntity().getWorld());
            set.remove(event.getEntity());
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVehicleCreate(VehicleCreateEvent event) {
        this.executor.execute(() -> {
            HashSet<Vehicle> set = this.getVehicleSet(event.getVehicle().getWorld());
            set.add(event.getVehicle());
        });
    }

    public Map<String, String> getVersions() {
        return this.versions;
    }

    public Map<World, HashSet<LivingEntity>> getEntityMap() {
        return this.entityMap;
    }

    public Map<World, HashSet<Item>> getItemMap() {
        return this.itemMap;
    }

    public Map<World, HashSet<Vehicle>> getVehicleMap() {
        return this.vehicleMap;
    }

    public Map<World, HashSet<Projectile>> getProjectileMap() {
        return this.projectileMap;
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public ScheduledFuture<?> getTask() {
        return this.task;
    }

    public AbstractFork getFork() {
        return this.fork;
    }

    public AbstractSupportNms getNms() {
        return this.nms;
    }

    public AbstractStacker getStacker() {
        return this.stacker;
    }

    public AbstractMonitor getMonitor() {
        return this.monitor;
    }

    public void setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    public void setTask(ScheduledFuture<?> task) {
        this.task = task;
    }

    public void setFork(AbstractFork fork) {
        this.fork = fork;
    }

    public void setNms(AbstractSupportNms nms) {
        this.nms = nms;
    }

    public void setStacker(AbstractStacker stacker) {
        this.stacker = stacker;
    }

    public void setMonitor(AbstractMonitor monitor) {
        this.monitor = monitor;
    }

    public static Map<String, EntityType> getEntities() {
        return entities;
    }

    public static SupportManager getInstance() {
        return instance;
    }

    class StandardMonitor
    extends AbstractMonitor {
        private final OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);

        StandardMonitor() {
        }

        @Override
        protected double cpuProcess() {
            return this.osBean.getProcessCpuLoad() * 100.0;
        }

        @Override
        protected double cpuSystem() {
            return this.osBean.getSystemCpuLoad() * 100.0;
        }

        @Override
        protected double tps() {
            return SupportManager.this.getNms().getTps(0);
        }

        @Override
        protected double tps(int time) {
            return SupportManager.this.getNms().getTps(time);
        }

        @Override
        protected double mspt() {
            return SupportManager.this.getFork().getMspt();
        }
    }

    class DeprecatedBukkitSupport
    extends AbstractSupportNms {
        public DeprecatedBukkitSupport(Plugin plugin) {
            super(plugin);
        }

        @Override
        public double getTps(int time) {
            return 20.0;
        }

        @Override
        public void setDistance(int view, int simulation) {
        }

        @Override
        public void setDefaultDistance() {
        }

        @Override
        public int getViewDistance() {
            return Bukkit.getViewDistance();
        }

        @Override
        public int getViewSimulation() {
            return -1;
        }

        @Override
        public ItemStack setNBTValue(ItemStack itemStack, String key, String value) {
            return itemStack;
        }

        @Override
        public boolean hasNBTValue(ItemStack itemStack, String key) {
            return false;
        }

        @Override
        public String getNBTValue(ItemStack itemStack, String key) {
            return null;
        }

        @Override
        public ItemStack createSkull(String base64) {
            ItemStack is = new ItemStack(Material.PLAYER_HEAD);
            ItemMeta meta = is.getItemMeta();
            if (meta == null) {
                return is;
            }
            GameProfile profile = new GameProfile(UUID.randomUUID(), RandomStringUtils.randomAlphabetic((int)8));
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", base64));
            try {
                Method mtd = meta.getClass().getDeclaredMethod("setProfile", GameProfile.class);
                mtd.setAccessible(true);
                mtd.invoke((Object)meta, profile);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ignored) {
                return is;
            }
            is.setItemMeta(meta);
            return is;
        }

        @Override
        public void setEntityAi(Entity ent, boolean enable) {
            if (ent instanceof Creature) {
                Creature c = (Creature)ent;
                if (c.hasAI() == enable) {
                    return;
                }
                c.setAI(enable);
                c.setSilent(!enable);
                c.setCollidable(enable);
            }
        }

        @Override
        public void setRandomTickSpeed(World world, boolean enable) {
            SupportManager.this.getFork().runSync(null, () -> world.setGameRule(GameRule.RANDOM_TICK_SPEED, (Object)(enable ? 3 : 0)));
        }

        @Override
        public int getTileEntitiesCount(Chunk chunk) {
            return 0;
        }

        @Override
        public int averagePing() {
            return -1;
        }

        @Override
        public void setSpawnLimits(World world, int monsters, int animals, int waterAnimals, int waterAmbient, int waterUndergroundCreature, int axolotls, int ambient) {
            world.setMonsterSpawnLimit(monsters);
            world.setAnimalSpawnLimit(animals);
            world.setWaterAnimalSpawnLimit(waterAnimals);
            world.setAmbientSpawnLimit(ambient);
        }

        @EventHandler
        public void onLoad(ChunkLoadEvent e) {
            SupportManager.this.getExecutor().execute(() -> {
                VehicleMotionReducerModule module2;
                Entity[] entities = e.getChunk().getEntities();
                MobAiReducerModule module1 = (MobAiReducerModule)ModuleManager.getInstance().get(MobAiReducerModule.class);
                if (module1 != null && module1.canContinue(e.getWorld()) && module1.isLoaded()) {
                    MobAiReducerModule.NMS nms = module1.getMobAiReducer();
                    for (Entity ent : entities) {
                        if (!module1.isEnabled(ent)) continue;
                        nms.optimize(ent, false);
                    }
                }
                if ((module2 = (VehicleMotionReducerModule)ModuleManager.getInstance().get(VehicleMotionReducerModule.class)) != null && module2.canContinue(e.getWorld()) && module2.isLoaded() && module2.isForceLoad()) {
                    VehicleMotionReducerModule.NMS nms = module2.getVehicleMotionReducer();
                    for (Entity ent : entities) {
                        if (!(ent instanceof Vehicle)) continue;
                        nms.optimizeVehicle((Vehicle)ent);
                    }
                }
                HashSet<LivingEntity> creatures = SupportManager.this.getCreatureSet(e.getWorld());
                HashSet<Item> items = SupportManager.this.getItemSet(e.getWorld());
                HashSet<Projectile> projectiles = SupportManager.this.getProjectileSet(e.getWorld());
                for (Entity ent : entities) {
                    if (ent instanceof LivingEntity) {
                        creatures.add((LivingEntity)ent);
                        continue;
                    }
                    if (ent instanceof Item) {
                        items.add((Item)ent);
                        continue;
                    }
                    if (!(ent instanceof Projectile)) continue;
                    projectiles.add((Projectile)ent);
                }
            });
        }
    }
}

