/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.managers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.objects.AbstractManager;
import xyz.lychee.lagfixer.utils.MessageUtils;

public class UpdaterManager
extends AbstractManager
implements Listener {
    private static final JsonParser parser = new JsonParser();
    private static UpdaterManager instance;
    private boolean needupdate = false;
    private String version = "";
    private BukkitTask task;

    public UpdaterManager(LagFixer plugin) {
        super(plugin);
        instance = this;
    }

    @EventHandler
    public void onClick(PlayerJoinEvent e) {
        if (e.getPlayer().isOp() && this.needupdate) {
            SupportManager.getInstance().getFork().runLater(true, () -> MessageUtils.sendMessage(true, (CommandSender)e.getPlayer(), "Plugin needs update, latest version: &f" + this.version + "\n &8- &ehttps://modrinth.com/plugin/lagfixer/"), 2500L);
        }
    }

    @Override
    public void load() throws IOException {
        this.task = SupportManager.getInstance().getFork().runTimer(true, () -> {
            try {
                this.version = IOUtils.toString((URI)URI.create("https://api.spigotmc.org/legacy/update.php?resource=111684"), (Charset)StandardCharsets.UTF_8);
                int current = Integer.parseInt(this.getPlugin().getDescription().getVersion().split(" ")[0].replaceAll("[^0-9]", ""));
                int latest = Integer.parseInt(this.version.replaceAll("[^0-9]", ""));
                this.needupdate = current < latest;
                boolean bl = this.needupdate;
                if (this.needupdate) {
                    this.getPlugin().getLogger().info(MessageFormat.format("\n&8\u2218\u208a\u2727\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2727\u208a\u2218\n&c&lLagFixer needs an update!\n&fVersion: &e&n{0}&r -> &e&n{1}&r\n&ahttps://modrinth.com/plugin/lagfixer\n\n&6\u26a0 &7Updating this plugin is crucial &6\u26a0\n&6\u26a0 &7for server optimization. &6\u26a0\n&8\u2218\u208a\u2727\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2727\u208a\u2218\n&fYou can disable this alert in config path:\n &emain &8-> &eupdater &8-> &efalse", this.getPlugin().getDescription().getVersion(), this.version));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, 1L, 30L, TimeUnit.MINUTES);
        this.getPlugin().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        this.task.cancel();
    }

    @Override
    public boolean isEnabled() {
        return this.getPlugin().getConfig().getBoolean("main.updater");
    }

    public boolean isNeedupdate() {
        return this.needupdate;
    }

    public String getVersion() {
        return this.version;
    }

    public BukkitTask getTask() {
        return this.task;
    }

    public static UpdaterManager getInstance() {
        return instance;
    }

    public static enum VersionChecker {
        MODRINTH(() -> {
            try {
                String jsonString = IOUtils.toString((URI)URI.create("https://api.modrinth.com/v2/project/lagfixer/version"), (Charset)StandardCharsets.UTF_8);
                JsonArray versions = parser.parse(jsonString).getAsJsonArray();
                for (JsonElement element : versions) {
                    JsonObject version = element.getAsJsonObject();
                    String versionType = version.get("version_type").getAsString();
                    if (!versionType.equals("release")) continue;
                    return version.get("version_number").getAsString();
                }
                return null;
            }
            catch (IOException ex) {
                return null;
            }
        }),
        SPIGOTMC(() -> {
            try {
                return IOUtils.toString((URI)URI.create("https://api.spigotmc.org/legacy/update.php?resource=111684"), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException ex) {
                return null;
            }
        });

        final Callable<String> callable;

        private VersionChecker(Callable<String> callable) {
            this.callable = callable;
        }
    }
}

