/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.map;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapCursorCollection;
import org.bukkit.map.MapFont;
import org.bukkit.map.MapPalette;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.map.MinecraftFont;
import org.jetbrains.annotations.NotNull;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.objects.AbstractMonitor;

public class MapHandler
extends MapRenderer {
    private static final int MAP_SIZE = 128;
    private static final int PADDING = 5;
    private static final Color GRID_COLOR = new Color(50, 50, 50, 100);
    private static final BasicStroke STROKE = new BasicStroke(2.0f);
    private static final int MAX_DATA_POINTS = 20;
    private static final LinearGradientPaint PAINT = new LinearGradientPaint(0.0f, 5.0f, 0.0f, 123.0f, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{Color.RED, Color.YELLOW, Color.GREEN});
    private final ItemStack mapItem;
    private final MapView mapView;
    private final byte[] bytes = new byte[16384];
    private final int[] pixels;
    private final Graphics2D g2d;
    private final double[] valuesBuffer = new double[20];
    private final Path2D.Double path = new Path2D.Double();
    private int bufferIndex;
    private int dataCount;
    private volatile boolean shouldRender = true;
    private ScheduledFuture<?> task;

    public MapHandler() {
        this.mapItem = new ItemStack(Material.FILLED_MAP);
        this.mapView = Bukkit.createMap((World)((World)Bukkit.getWorlds().get(0)));
        BufferedImage image = new BufferedImage(128, 128, 1);
        this.pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        this.g2d = image.createGraphics();
        this.g2d.setColor(Color.GRAY);
        this.g2d.fillRect(0, 0, 128, 128);
        MapMeta meta = (MapMeta)this.mapItem.getItemMeta();
        meta.setMapView(this.mapView);
        meta.setDisplayName("\u00a7e\u26a1 \u00a7fServer monitor! \u00a7e\u26a1");
        this.mapItem.setItemMeta((ItemMeta)meta);
        this.mapView.getRenderers().clear();
        this.mapView.addRenderer((MapRenderer)this);
    }

    public void load(int interval) {
        this.task = SupportManager.getInstance().getExecutor().scheduleWithFixedDelay(() -> {
            AbstractMonitor monitor = SupportManager.getInstance().getMonitor();
            double newValue = monitor.getMspt();
            if (this.dataCount < 20) {
                this.valuesBuffer[this.dataCount++] = newValue;
            } else {
                this.valuesBuffer[this.bufferIndex] = newValue;
                this.bufferIndex = (this.bufferIndex + 1) % 20;
            }
            if (!this.shouldRender) {
                return;
            }
            this.renderGraph();
            this.renderText(newValue, monitor.getTps());
            for (int i = 0; i < this.pixels.length; ++i) {
                int rgb = this.pixels[i];
                this.bytes[i] = MapPalette.matchColor((Color)new Color(rgb));
            }
            this.shouldRender = false;
        }, 10L, interval, TimeUnit.SECONDS);
    }

    private void renderGraph() {
        int i;
        this.g2d.setColor(Color.WHITE);
        this.g2d.fillRect(5, 5, 118, 118);
        double currentMax = 0.0;
        for (int i2 = 0; i2 < this.dataCount; ++i2) {
            double value = this.valuesBuffer[(this.bufferIndex + i2) % 20];
            if (!(value > currentMax)) continue;
            currentMax = value;
        }
        double maxVal = currentMax * 0.25 + 50.0;
        this.path.reset();
        this.path.moveTo(5.0, Math.max(123.0 - this.valuesBuffer[0] * 118.0 / maxVal, 5.0));
        int validPoints = Math.min(this.dataCount, 20);
        for (i = 0; i < validPoints; ++i) {
            int dataIndex = (this.bufferIndex + i) % 20;
            double value = this.valuesBuffer[dataIndex];
            double x = 5.0 + (double)i * 118.0 / (double)(validPoints - 1);
            double y = Math.max(123.0 - value * 118.0 / maxVal, 5.0);
            if (i == 0) {
                this.path.moveTo(x, y);
                continue;
            }
            this.path.lineTo(x, y);
        }
        this.path.lineTo(123.0, 123.0);
        this.path.lineTo(5.0, 123.0);
        this.path.closePath();
        this.g2d.setPaint(PAINT);
        this.g2d.fill(this.path);
        this.g2d.setStroke(STROKE);
        this.g2d.setColor(GRID_COLOR);
        for (i = 1; i < 5; ++i) {
            int y = (int)(5.0 + (double)i * 118.0 / 5.0);
            this.g2d.drawLine(123, y, 5, y);
        }
        this.g2d.setColor(Color.BLACK);
        this.g2d.drawRect(5, 5, 118, 118);
    }

    private void renderText(double mspt, double tps) {
        String text = String.format("Mspt: %.1f Tps: %.1f", mspt, tps);
        MinecraftFont font = MinecraftFont.Font;
        int x = 10;
        int y = 10;
        int color = Color.BLACK.getRGB();
        for (char ch : text.toCharArray()) {
            MapFont.CharacterSprite sprite = font.getChar(ch);
            if (sprite == null) continue;
            int width = sprite.getWidth();
            for (int row = 0; row < font.getHeight(); ++row) {
                for (int col = 0; col < width; ++col) {
                    if (!sprite.get(row, col)) continue;
                    int pixelIndex = (y + row) * 128 + (x + col);
                    this.pixels[pixelIndex] = color;
                }
            }
            x += width + 1;
        }
    }

    public void unload() {
        if (this.task != null) {
            this.task.cancel(true);
        }
        this.g2d.dispose();
    }

    public void render(@NotNull MapView mapView, @NotNull MapCanvas mapCanvas, @NotNull Player player) {
        if (!mapView.equals((Object)this.mapView)) {
            return;
        }
        PlayerInventory inv = player.getInventory();
        if (inv.getItemInMainHand().getType() != Material.FILLED_MAP && inv.getItemInOffHand().getType() != Material.FILLED_MAP) {
            return;
        }
        this.shouldRender = true;
        mapCanvas.setCursors(new MapCursorCollection());
        int i = 0;
        while (i < 16384) {
            int y = i >> 7;
            int x = i & 0x7F;
            mapCanvas.setPixel(x, y, this.bytes[i++]);
        }
    }

    public void giveMap(Player p) {
        p.getInventory().addItem(new ItemStack[]{this.mapItem});
    }
}

