/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.menu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemorySection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import xyz.lychee.lagfixer.managers.CommandManager;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.objects.AbstractMenu;
import xyz.lychee.lagfixer.objects.AbstractModule;
import xyz.lychee.lagfixer.objects.AbstractSupportNms;
import xyz.lychee.lagfixer.utils.MessageUtils;

public class ModuleMenu
extends AbstractMenu {
    private static final HashMap<UUID, CommandManager.ConfigChange> availablechanges = new HashMap();
    private final AbstractModule module;

    public ModuleMenu(int size, AbstractModule module) {
        super(module.getPlugin(), size, MessageUtils.fixColors(null, "&8[&e&l\u26a1&8] &fConfig! &8| &eLagFixer"), false, true);
        this.module = module;
    }

    @Override
    public void update() {
        AbstractSupportNms nms = SupportManager.getInstance().getNms();
        this.getInv().clear();
        availablechanges.entrySet().removeIf(change -> Objects.equals(((CommandManager.ConfigChange)change.getValue()).getModule(), this.module));
        int size = this.getInv().getSize();
        this.getInv().setItem(size - 1, ModuleMenu.getBack());
        ItemStack button = (this.module.isLoaded() ? ModuleMenu.getEnabled() : ModuleMenu.getDisabled()).clone();
        nms.setNBTValue(button, "module", this.module.getClass().getCanonicalName());
        this.getInv().setItem(size - 5, button);
        for (int i = size - 9; i < size; ++i) {
            if (this.getInv().getItem(i) != null) continue;
            this.getInv().setItem(i, ModuleMenu.getBorder());
        }
        ConfigurationSection defSection = this.module.getSection().getDefaultSection();
        if (defSection == null) {
            defSection = this.module.getSection();
        }
        defSection.getValues(true).forEach((key, value) -> {
            if (value instanceof MemorySection) {
                return;
            }
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(MessageUtils.fixColors(null, "&7Current value:"));
            Object val = this.module.getSection().get(key);
            if (val instanceof Collection) {
                for (Object obj : (Collection)val) {
                    lore.add(MessageUtils.fixColors(null, " &8{*} &e" + obj));
                }
            } else {
                lore.add(MessageUtils.fixColors(null, " &8{*} &e" + val));
            }
            lore.add("");
            lore.add(MessageUtils.fixColors(null, "&bRight click get default value!"));
            lore.add(MessageUtils.fixColors(null, "&aLeft click to change value!"));
            UUID uuid = UUID.randomUUID();
            ItemStack isetting = this.module.getBaseSkull().clone();
            nms.setNBTValue(isetting, "uuid", uuid.toString());
            ItemMeta meta = isetting.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(MessageUtils.fixColors(null, "&f&lKey: &e&l" + key));
                meta.setLore(lore);
                isetting.setItemMeta(meta);
            }
            availablechanges.put(uuid, new CommandManager.ConfigChange(this.module, (String)key, this.module.getSection().get(key)));
            this.getInv().addItem(new ItemStack[]{isetting});
        });
    }

    @Override
    public void handleClick(InventoryClickEvent e, ItemStack item) {
        if (item.getType() == Material.PLAYER_HEAD) {
            HumanEntity human = e.getWhoClicked();
            if (e.getSlot() == e.getView().getTopInventory().getSize() - 5) {
                try {
                    String path = "modules." + this.module.getName() + ".enabled";
                    if (this.module.isLoaded()) {
                        this.module.disable();
                        this.module.setLoaded(false);
                        this.getPlugin().getConfig().set(path, (Object)false);
                        MessageUtils.sendMessage(true, (CommandSender)human, "Successfully disabled module &e" + this.module.getName());
                    } else {
                        this.module.load();
                        this.module.loadAllConfig();
                        this.module.setLoaded(true);
                        this.getPlugin().getConfig().set(path, (Object)true);
                        MessageUtils.sendMessage(true, (CommandSender)human, "Successfully enabled module &e" + this.module.getName());
                    }
                    this.getPlugin().saveConfig();
                    this.module.getMenu().update();
                }
                catch (Exception ex) {
                    MessageUtils.sendMessage(true, (CommandSender)human, "An error occurred while disabling/enabling the configuration.");
                    this.getPlugin().printError(ex);
                }
                CommandManager.getInstance().getModulesMenu().update();
                return;
            }
            CommandManager.ConfigChange change = availablechanges.get(UUID.fromString(SupportManager.getInstance().getNms().getNBTValue(item, "uuid")));
            if (e.isRightClick()) {
                MessageUtils.sendMessage(true, (CommandSender)human, "&fDefault value of &e" + change.getKey() + " &fis:\n &8{*} &e" + change.getModule().getSection().getDefaultSection().get(change.getKey()));
                return;
            }
            human.closeInventory();
            CommandManager.getInstance().getPlayerchange().put(human.getUniqueId(), change);
            MessageUtils.sendMessage(true, (CommandSender)human, "Please enter a new value (-cancel to cancel):");
            if (change.getValue() instanceof Collection) {
                MessageUtils.sendMessage(false, (CommandSender)human, "&fIf you enter a value that is already in the list, it will be removed.");
            }
        }
    }

    @Override
    public AbstractMenu previousMenu() {
        return CommandManager.getInstance().getModulesMenu();
    }
}

