/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.modules;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.material.Colorable;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.managers.ModuleManager;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.objects.AbstractModule;

public class CreatureStackerModule
extends AbstractModule
implements Listener {
    private final HashMap<UUID, Stack> stacks = new HashMap();
    private BukkitTask task;

    public CreatureStackerModule(LagFixer plugin, ModuleManager manager) {
        super(plugin, manager, AbstractModule.Impact.HIGH, "CreatureStacker", (ImmutableList<String>)ImmutableList.of((Object)"soon"), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYmVlODUxNDg5MmYzZDc4YTMyZTg0NTZmY2JiOGM2MDgxZTIxYjI0NmQ4MmYzOThiZDk2OWZlYzE5ZDNjMjdiMyJ9fX0=");
    }

    public Stack getStack(Entity e) {
        return this.stacks.computeIfAbsent(e.getUniqueId(), k -> new Stack(e, 1));
    }

    public void deleteStack(Entity e) {
        this.stacks.remove(e.getUniqueId());
    }

    public void loadStacks() {
        this.getPlugin().getConfig().getStringList("stacks").forEach(str -> {
            String[] split = str.split(":");
            UUID uuid = UUID.fromString(split[0]);
            Entity e = Bukkit.getEntity((UUID)uuid);
            if (e != null) {
                this.stacks.put(uuid, new Stack(e, Integer.parseInt(split[1])));
            }
        });
        System.out.println("loaded " + this.stacks.size() + " stacks");
    }

    public boolean isSlimear(Entity e1, Entity e2) {
        boolean isAgeable = e1 instanceof Ageable && e2 instanceof Ageable && ((Ageable)e1).isAdult() != ((Ageable)e2).isAdult();
        boolean isColorable = e1 instanceof Colorable && e2 instanceof Colorable && ((Colorable)e1).getColor() != ((Colorable)e2).getColor();
        boolean isSheep = e1 instanceof Sheep && e2 instanceof Sheep && ((Sheep)e1).isSheared() != ((Sheep)e2).isSheared();
        return isAgeable || isColorable || isSheep;
    }

    public void updateName(Entity e, Consumer<Stack> consumer) {
        Stack stack = this.getStack(e);
        if (consumer != null) {
            consumer.accept(stack);
        }
        e.setCustomName(e.getType().name() + " - " + stack.getAmount());
        if (!e.isCustomNameVisible()) {
            e.setCustomNameVisible(true);
        }
    }

    @EventHandler
    public void onSpawn(CreatureSpawnEvent e) {
        Optional<Entity> optional = e.getEntity().getWorld().getEntities().stream().filter(ent -> ent.getClass() == e.getEntityType().getEntityClass() && this.isSlimear((Entity)ent, (Entity)e.getEntity())).findFirst();
        if (optional.isPresent()) {
            this.updateName(optional.get(), Stack::add);
            e.setCancelled(true);
        } else {
            this.updateName((Entity)e.getEntity(), null);
        }
    }

    @EventHandler
    public void onDeath(EntityDeathEvent e) {
        Stack stack = this.getStack((Entity)e.getEntity());
        if (stack.getAmount() > 1) {
            if (e instanceof Cancellable) {
                ((Cancellable)e).setCancelled(true);
            }
            e.getEntity().setHealth(e.getEntity().getMaxHealth());
            e.getDrops().forEach(is -> e.getEntity().getWorld().dropItemNaturally(e.getEntity().getLocation(), is));
            this.updateName((Entity)e.getEntity(), Stack::add);
        } else {
            this.deleteStack((Entity)e.getEntity());
        }
        Player killer = e.getEntity().getKiller();
        if (killer != null) {
            killer.giveExp(e.getDroppedExp());
        }
    }

    @Override
    public void load() throws IOException {
        this.task = SupportManager.getInstance().getFork().runTimer(true, () -> {
            this.getPlugin().getConfig().set("stacks", this.stacks.entrySet().stream().map(entry -> ((UUID)entry.getKey()).toString() + ":" + ((Stack)entry.getValue()).getAmount()).collect(Collectors.toList()));
            this.getPlugin().saveConfig();
        }, 1L, 1L, TimeUnit.SECONDS);
        this.getPlugin().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
    }

    @Override
    public boolean loadConfig() {
        return true;
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.task != null) {
            this.task.cancel();
        }
    }

    public static class Stack {
        private final Entity entity;
        private int amount;

        public Stack(Entity e, int i) {
            this.entity = e;
            this.amount = i;
        }

        public void add() {
            ++this.amount;
        }

        public void remove() {
            --this.amount;
        }

        public int getAmount() {
            return this.amount;
        }
    }
}

