/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.modules;

import com.google.common.collect.ImmutableList;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.managers.ModuleManager;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.objects.AbstractModule;
import xyz.lychee.lagfixer.utils.ReflectionUtils;

public class CustomTrackerModule
extends AbstractModule
implements Listener {
    private BukkitTask untrackTask;
    private BukkitTask checkTask;
    private NMS customTracker;
    private long untrackInterval;
    private long checkInterval;
    private double minMspt;

    public CustomTrackerModule(LagFixer plugin, ModuleManager manager) {
        super(plugin, manager, AbstractModule.Impact.MEDIUM, "CustomTracker", (ImmutableList<String>)ImmutableList.of((Object)"soon"), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZWRjMzZjOWNiNTBhNTI3YWE1NTYwN2EwZGY3MTg1YWQyMGFhYmFhOTAzZThkOWFiZmM3ODI2MDcwNTU0MGRlZiJ9fX0=");
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        for (Entity entity : event.getChunk().getEntities()) {
            this.customTracker.setAware(entity, true);
        }
    }

    @Override
    public void load() {
        this.customTracker = (NMS)ReflectionUtils.createInstance("CustomTracker", this);
        if (this.customTracker == null) {
            return;
        }
        this.getPlugin().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
        this.untrackTask = SupportManager.getInstance().getFork().runTimer(true, () -> {
            if (SupportManager.getInstance().getMonitor().getMspt() > this.minMspt) {
                return;
            }
            this.getAllowedWorlds().forEach(w -> this.customTracker.untrackProcess((World)w));
        }, this.untrackInterval, this.untrackInterval);
        this.checkTask = SupportManager.getInstance().getFork().runTimer(false, () -> this.getAllowedWorlds().forEach(w -> this.customTracker.checkWorld((World)w)), this.untrackInterval + 50L, this.checkInterval);
    }

    @Override
    public boolean loadConfig() {
        this.untrackInterval = this.getSection().getLong("untrack_interval") * 50L;
        this.checkInterval = this.getSection().getLong("check_interval") * 50L;
        this.minMspt = this.getSection().getDouble("needed_mspt");
        return true;
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        this.untrackTask.cancel();
        this.checkTask.cancel();
    }

    public static abstract class NMS {
        private final CustomTrackerModule module;

        public NMS(CustomTrackerModule module) {
            this.module = module;
        }

        public abstract void setAware(Entity var1, boolean var2);

        public abstract void checkWorld(World var1);

        public abstract void untrackProcess(World var1);

        public CustomTrackerModule getModule() {
            return this.module;
        }
    }
}

