/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.modules;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.managers.ModuleManager;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.objects.AbstractModule;
import xyz.lychee.lagfixer.objects.AbstractSupportNms;

public class EntityLimiterModule
extends AbstractModule
implements Listener {
    private final Map<String, CreatureSpawnEvent.SpawnReason> reasonMap = new HashMap<String, CreatureSpawnEvent.SpawnReason>();
    private int locks;
    private BukkitTask task;
    private boolean perchunk_enabled;
    private boolean perworld_enabled;
    private int perchunk_creatures;
    private int perchunk_items;
    private int perchunk_vehicles;
    private int perchunk_projectiles;
    private int perworld_monsters;
    private int perworld_animals;
    private int perworld_water_animals;
    private int perworld_water_ambient;
    private int perworld_water_underground_creature;
    private int perworld_axolotls;
    private int perworld_ambient;
    private EnumSet<CreatureSpawnEvent.SpawnReason> reasons;
    private boolean alerts;

    public EntityLimiterModule(LagFixer plugin, ModuleManager manager) {
        super(plugin, manager, AbstractModule.Impact.HIGH, "EntityLimiter", (ImmutableList<String>)ImmutableList.of((Object)"Restricts the number of entities per chunk.", (Object)"Essential for survival servers with expansive animal farms.", (Object)"Prevents excessive entity accumulation and associated performance issues.", (Object)"Maintains stable performance levels even in environments with high entity density."), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZWRjMzZjOWNiNTBhNTI3YWE1NTYwN2EwZGY3MTg1YWQyMGFhYmFhOTAzZThkOWFiZmM3ODI2MDcwNTU0MGRlZiJ9fX0=");
        for (CreatureSpawnEvent.SpawnReason reason : CreatureSpawnEvent.SpawnReason.values()) {
            this.reasonMap.put(reason.name(), reason);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onSpawn(CreatureSpawnEvent e) {
        if (!this.canContinue(e.getLocation().getWorld()) || this.perchunk_creatures == -1 || !this.reasons.contains(e.getSpawnReason())) {
            return;
        }
        if (this.perchunk_enabled && this.countEntities(e.getLocation().getChunk(), Creature.class) >= (long)this.perchunk_creatures) {
            e.setCancelled(true);
            ++this.locks;
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent e) {
        if (!this.canContinue(e.getItemDrop().getWorld()) || this.perchunk_items == -1) {
            return;
        }
        if (this.perchunk_enabled && this.countEntities(e.getItemDrop().getLocation().getChunk(), Item.class) >= (long)this.perchunk_items) {
            e.setCancelled(true);
            ++this.locks;
        }
    }

    @EventHandler
    public void onVehicle(VehicleCreateEvent e) {
        if (!this.canContinue(e.getVehicle().getWorld()) || this.perchunk_vehicles == -1) {
            return;
        }
        if (this.perchunk_enabled && this.countEntities(e.getVehicle().getLocation().getChunk(), Vehicle.class) >= (long)this.perchunk_vehicles) {
            e.setCancelled(true);
            ++this.locks;
        }
    }

    @EventHandler
    public void onLaunch(ProjectileLaunchEvent e) {
        if (!this.canContinue(e.getLocation().getWorld()) || this.perchunk_projectiles == -1) {
            return;
        }
        if (this.perchunk_enabled && this.countEntities(e.getLocation().getChunk(), Projectile.class) >= (long)this.perchunk_projectiles) {
            e.setCancelled(true);
            ++this.locks;
        }
    }

    public long countEntities(Chunk c, Class<? extends Entity> clazz) {
        if (!c.isLoaded()) {
            return 0L;
        }
        Entity[] entities = c.getEntities();
        int count = 0;
        int len = entities.length;
        for (int i = 0; i < len; ++i) {
            if (!clazz.isInstance(entities[i])) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void load() {
        if (this.perchunk_enabled) {
            if (this.alerts) {
                this.task = SupportManager.getInstance().getFork().runTimer(true, () -> {
                    if (this.locks > 75) {
                        this.getPlugin().getLogger().info("Entity limiter cancelled " + this.locks + " events!");
                        this.locks = 0;
                    }
                }, 2L, 2L, TimeUnit.SECONDS);
            }
            this.getPlugin().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
        }
        if (this.perworld_enabled) {
            SupportManager.getInstance().getFork().runSync(null, () -> {
                AbstractSupportNms nms = SupportManager.getInstance().getNms();
                this.getAllowedWorlds().forEach(w -> nms.setSpawnLimits((World)w, this.perworld_monsters, this.perworld_animals, this.perworld_water_animals, this.perworld_water_ambient, this.perworld_water_underground_creature, this.perworld_axolotls, this.perworld_ambient));
            });
        }
    }

    @Override
    public boolean loadConfig() {
        this.alerts = this.getSection().getBoolean("alerts");
        this.perchunk_enabled = this.getSection().getBoolean("perchunk.enabled");
        this.perchunk_creatures = this.getSection().getInt("perchunk.creatures");
        this.perchunk_items = this.getSection().getInt("perchunk.items");
        this.perchunk_vehicles = this.getSection().getInt("perchunk.vehicles");
        this.perchunk_projectiles = this.getSection().getInt("perchunk.projectiles");
        this.reasons = EnumSet.copyOf(this.getSection().getStringList("perchunk.reasons").stream().map(this.reasonMap::get).filter(Objects::nonNull).collect(Collectors.toList()));
        this.perworld_enabled = this.getSection().getBoolean("perworld.enabled");
        this.perworld_animals = this.getSection().getInt("perworld.animals");
        this.perworld_monsters = this.getSection().getInt("perworld.monsters");
        this.perworld_water_animals = this.getSection().getInt("perworld.water_animals");
        this.perworld_water_ambient = this.getSection().getInt("perworld.water_ambient");
        this.perworld_water_underground_creature = this.getSection().getInt("perworld.water_underground_creature");
        this.perworld_axolotls = this.getSection().getInt("perworld.axolotls");
        this.perworld_ambient = this.getSection().getInt("perworld.ambient");
        return true;
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.task != null) {
            this.task.cancel();
        }
    }
}

