/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.modules;

import com.google.common.collect.ImmutableList;
import java.util.concurrent.TimeUnit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.managers.ModuleManager;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.objects.AbstractModule;
import xyz.lychee.lagfixer.objects.AbstractSupportNms;

public class LagMonitorModule
extends AbstractModule
implements Runnable,
Listener {
    private boolean enabled;
    private int locks = 0;
    private BukkitTask task;
    private int simulationdistancesize;
    private int viewdistancesize;
    private double neededmspt;
    private boolean entityspawn;
    private boolean tickhopper;
    private boolean redstone;
    private boolean projectiles;
    private boolean leavesdecay;
    private boolean mobai;
    private boolean liquidflow;
    private boolean randomtickspeed;
    private boolean viewdistance;
    private boolean simulationdistance;

    public LagMonitorModule(LagFixer plugin, ModuleManager manager) {
        super(plugin, manager, AbstractModule.Impact.HIGH, "LagMonitor", (ImmutableList<String>)ImmutableList.of((Object)"Monitors server load and adjusts settings during latency spikes.", (Object)"Addresses fluctuations in server performance to mitigate delays and lag.", (Object)"Dynamically adjusts settings, disables unnecessary features, and optimizes resources.", (Object)"Ensures smooth gameplay by minimizing the impact of performance fluctuations."), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYWNjNzg5ZjIzMDc5NGY5MGUzM2M0ZjlhZDAwNjk0YmMyYTJmZjVlOGI5YjM3NWRjMzUzMjQwMWIyODFmM2U1OCJ9fX0=");
    }

    private boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void run() {
        this.enabled = SupportManager.getInstance().getMonitor().getMspt() > this.neededmspt;
        AbstractSupportNms nms = SupportManager.getInstance().getNms();
        if (this.isEnabled()) {
            nms.setDistance(this.viewdistance ? this.viewdistancesize : -1, this.simulationdistance ? this.simulationdistancesize : -1);
            this.getAllowedWorlds().forEach(w -> {
                if (this.mobai) {
                    SupportManager.getInstance().getExecutor().execute(() -> SupportManager.getInstance().getCreatureSet((World)w).forEach(c -> nms.setEntityAi((Entity)c, false)));
                }
                if (this.randomtickspeed) {
                    nms.setRandomTickSpeed((World)w, false);
                }
            });
            if (this.locks > 0) {
                this.getPlugin().getLogger().warning("Server is lagging, LagMonitor module cancelled " + this.locks + " events!");
                this.locks = 0;
            }
        } else {
            nms.setDefaultDistance();
            this.getAllowedWorlds().forEach(w -> {
                if (this.mobai) {
                    SupportManager.getInstance().getExecutor().execute(() -> SupportManager.getInstance().getCreatureSet((World)w).forEach(c -> nms.setEntityAi((Entity)c, true)));
                }
                if (this.randomtickspeed) {
                    nms.setRandomTickSpeed((World)w, true);
                }
            });
        }
    }

    @EventHandler
    public void onRedstone(BlockRedstoneEvent e) {
        if (this.isEnabled() && this.redstone) {
            e.setNewCurrent(0);
            ++this.locks;
        }
    }

    @EventHandler
    public void onSpawn(VehicleCreateEvent e) {
        if (this.isEnabled() && this.entityspawn) {
            e.setCancelled(true);
            ++this.locks;
        }
    }

    @EventHandler
    public void onSpawn(CreatureSpawnEvent e) {
        if (this.isEnabled() && this.entityspawn) {
            e.setCancelled(true);
            ++this.locks;
        }
    }

    @EventHandler
    public void onEggHit(ProjectileLaunchEvent e) {
        if (this.isEnabled() && this.projectiles) {
            e.setCancelled(true);
            ++this.locks;
        }
    }

    @EventHandler
    public void onHopper(InventoryMoveItemEvent e) {
        if (this.isEnabled() && this.tickhopper) {
            e.setCancelled(true);
            ++this.locks;
        }
    }

    @EventHandler
    public void onDecay(LeavesDecayEvent e) {
        if (this.isEnabled() && this.leavesdecay) {
            e.setCancelled(true);
            ++this.locks;
        }
    }

    @EventHandler
    public void onBlockFromTo(BlockFromToEvent event) {
        if (this.isEnabled() && event.getBlock().isLiquid() && this.liquidflow) {
            event.setCancelled(true);
            ++this.locks;
        }
    }

    @Override
    public void load() throws Exception {
        this.task = SupportManager.getInstance().getFork().runTimer(true, this, 1L, 1L, TimeUnit.MINUTES);
        this.getPlugin().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
    }

    @Override
    public boolean loadConfig() {
        this.simulationdistancesize = this.getSection().getInt("simulation_distance");
        this.viewdistancesize = this.getSection().getInt("view_distance");
        this.neededmspt = this.getSection().getDouble("needed_mspt");
        this.entityspawn = this.getSection().getBoolean("during_lags.disable.entity_spawn");
        this.tickhopper = this.getSection().getBoolean("during_lags.disable.tick_hopper");
        this.redstone = this.getSection().getBoolean("during_lags.disable.redstone");
        this.projectiles = this.getSection().getBoolean("during_lags.disable.projectiles");
        this.leavesdecay = this.getSection().getBoolean("during_lags.disable.leaves_decay");
        this.mobai = this.getSection().getBoolean("during_lags.disable.mobai");
        this.liquidflow = this.getSection().getBoolean("during_lags.disable.liquid_flow");
        this.randomtickspeed = this.getSection().getBoolean("during_lags.disable.random_tick_speed");
        this.simulationdistance = this.getSection().getBoolean("during_lags.disable.simulation_distance");
        this.viewdistance = this.getSection().getBoolean("during_lags.disable.view_distance");
        return true;
    }

    @Override
    public void disable() {
        if (this.task != null) {
            this.task.cancel();
        }
        HandlerList.unregisterAll((Listener)this);
    }
}

