/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.modules;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.stream.Collectors;
import org.bukkit.World;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Flying;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.plugin.Plugin;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.managers.ModuleManager;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.objects.AbstractModule;
import xyz.lychee.lagfixer.utils.ReflectionUtils;

public class MobAiReducerModule
extends AbstractModule
implements Listener {
    private NMS mobAiReducer;
    private boolean animals;
    private boolean monsters;
    private boolean villagers;
    private boolean tameable;
    private boolean birds;
    private boolean others;
    private boolean async;
    private boolean forceLoad;
    private boolean clickEvent;
    private EnumSet<EntityType> blacklist;

    public MobAiReducerModule(LagFixer plugin, ModuleManager manager) {
        super(plugin, manager, AbstractModule.Impact.VERY_HIGH, "MobAiReducer", (ImmutableList<String>)ImmutableList.of((Object)"Replaces creature movement to optimize and reduce behavior.", (Object)"Addresses inefficiencies caused by default animal behavior like unnecessary random movements or constant looking around.", (Object)"MobAiReducer intervenes by disabling unnecessary PathFinders or replacing them with more efficient ones.", (Object)"Crucial in scenarios with numerous animals as even minor movements can strain server resources."), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOGM3NTA1ZjIyNGQ1MTY0YTExN2Q4YzY5ZjAxNWY5OWVmZjQzNDQ3MWM4YTJkZjkwNzA5NmM0MjQyYzM1MjRlOCJ9fX0=");
    }

    @EventHandler(ignoreCancelled=true)
    public void onSpawn(CreatureSpawnEvent e) {
        if (!this.isEnabled((Entity)e.getEntity()) || !this.canContinue(e.getLocation().getWorld())) {
            return;
        }
        SupportManager.getInstance().getExecutor().execute(() -> this.mobAiReducer.optimize((Entity)e.getEntity(), false));
    }

    @EventHandler(ignoreCancelled=true)
    public void onSpawn(VehicleCreateEvent e) {
        if (!this.canContinue(e.getVehicle().getWorld())) {
            return;
        }
        SupportManager.getInstance().getExecutor().execute(() -> this.mobAiReducer.optimize((Entity)e.getVehicle(), false));
    }

    public boolean isEnabled(Entity ent) {
        if (this.blacklist.contains(ent.getType())) {
            return false;
        }
        if (ent instanceof Tameable) {
            return this.tameable;
        }
        if (ent instanceof Animals) {
            return this.animals;
        }
        if (ent instanceof Flying) {
            return this.birds;
        }
        if (ent instanceof Monster) {
            return this.monsters;
        }
        if (ent instanceof Villager) {
            return this.villagers;
        }
        return this.others;
    }

    @Override
    public void load() {
        this.getPlugin().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
        if (this.forceLoad) {
            this.getAllowedWorlds().forEach(w -> SupportManager.getInstance().getExecutor().execute(() -> SupportManager.getInstance().getCreatureSet((World)w).stream().filter(this::isEnabled).forEach(ent -> this.mobAiReducer.optimize((Entity)ent, true))));
        }
    }

    @Override
    public boolean loadConfig() {
        this.mobAiReducer = (NMS)ReflectionUtils.createInstance("MobAiReducer", this);
        this.animals = this.getSection().getBoolean("entities.animals");
        this.monsters = this.getSection().getBoolean("entities.monsters");
        this.villagers = this.getSection().getBoolean("entities.villagers");
        this.tameable = this.getSection().getBoolean("entities.tameable");
        this.birds = this.getSection().getBoolean("entities.birds");
        this.others = this.getSection().getBoolean("entities.others");
        this.async = this.getSection().getBoolean("async");
        this.forceLoad = this.getSection().getBoolean("force_load");
        this.clickEvent = this.getSection().getBoolean("click_event");
        this.blacklist = EnumSet.copyOf(this.getSection().getStringList("blacklist").stream().map(String::toUpperCase).filter(SupportManager.getEntities()::containsKey).map(SupportManager.getEntities()::get).collect(Collectors.toList()));
        return this.mobAiReducer != null;
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    public NMS getMobAiReducer() {
        return this.mobAiReducer;
    }

    public boolean isAnimals() {
        return this.animals;
    }

    public boolean isMonsters() {
        return this.monsters;
    }

    public boolean isVillagers() {
        return this.villagers;
    }

    public boolean isTameable() {
        return this.tameable;
    }

    public boolean isBirds() {
        return this.birds;
    }

    public boolean isOthers() {
        return this.others;
    }

    public boolean isAsync() {
        return this.async;
    }

    public boolean isForceLoad() {
        return this.forceLoad;
    }

    public boolean isClickEvent() {
        return this.clickEvent;
    }

    public EnumSet<EntityType> getBlacklist() {
        return this.blacklist;
    }

    public static abstract class NMS {
        private final MobAiReducerModule module;

        public NMS(MobAiReducerModule module) {
            this.module = module;
        }

        public abstract void optimize(Entity var1, boolean var2);

        public MobAiReducerModule getModule() {
            return this.module;
        }
    }
}

