/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.modules;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.Language;
import xyz.lychee.lagfixer.hooks.LevelledMobsHook;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.Component;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import xyz.lychee.lagfixer.managers.ModuleManager;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.objects.AbstractModule;
import xyz.lychee.lagfixer.objects.AbstractStacker;
import xyz.lychee.lagfixer.utils.MessageUtils;

public class WorldCleanerModule
extends AbstractModule
implements Listener,
CommandExecutor {
    private final ArrayList<ItemStack> items = new ArrayList();
    private ScheduledFuture<?> task;
    private boolean opened = false;
    private Inventory inv;
    private int second;
    private int interval;
    private boolean alerts;
    private boolean creatures_enabled;
    private boolean creatures_named;
    private boolean creatures_dropitems;
    private boolean creatures_babies;
    private EnumSet<EntityType> creatures_list;
    private boolean items_enabled;
    private boolean items_disableitemdespawn;
    private boolean items_abyss_enabled;
    private boolean items_abyss_alerts;
    private boolean items_abyss_itemdespawn;
    private String items_abyss_permission;
    private int items_abyss_close;
    private int items_timelived;
    private EnumSet<Material> items_abyss_blacklist;
    private EnumSet<Material> items_blacklist;
    private boolean projectiles_enabled;
    private EnumSet<EntityType> projectiles_blacklist;

    public WorldCleanerModule(LagFixer plugin, ModuleManager manager) {
        super(plugin, manager, AbstractModule.Impact.MEDIUM, "WorldCleaner", (ImmutableList<String>)ImmutableList.of((Object)"Cleans up old items on the ground to accelerate server performance.", (Object)"Accumulation of items over time contributes to server lag, especially in densely populated or active servers.", (Object)"Kills creatures to accelerate server performance.", (Object)"Players can retrieve items from the Abyss inventory using the /abyss command."), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTlkODA2Yjc1ZWM5NTAwNmM1ZWMzODY2YzU0OGM1NTcxYWYzZTc4OGM3ZDE2MjllZGU2NGJjMWI3NDg4NTljZCJ9fX0=");
    }

    @EventHandler
    public void onDespawn(ItemDespawnEvent e) {
        if (this.items_disableitemdespawn) {
            e.setCancelled(true);
            return;
        }
        if (this.items_abyss_enabled && this.items_abyss_itemdespawn && !this.items_abyss_blacklist.contains(e.getEntity().getItemStack().getType())) {
            AbstractStacker stacker = SupportManager.getInstance().getStacker();
            if (stacker != null) {
                stacker.addItemsToList(e.getEntity(), this.items);
            } else {
                this.inv.addItem(new ItemStack[]{e.getEntity().getItemStack()});
            }
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        Component text;
        if (!this.items_abyss_enabled) {
            text = Language.getMainValue("disabled_module", true, Placeholder.unparsed("module", this.getName()));
        } else if (!this.items_abyss_permission.isEmpty() && !sender.hasPermission(this.items_abyss_permission)) {
            text = Language.getMainValue("no_access", true, Placeholder.unparsed("permission", this.items_abyss_permission));
        } else if (!this.opened) {
            text = this.getLanguage().getComponent("items.abyss.closed", true, new TagResolver.Single[0]);
        } else if (sender instanceof Player) {
            ((Player)sender).openInventory(this.inv);
            text = this.getLanguage().getComponent("items.abyss.opened", true, new TagResolver.Single[0]);
        } else {
            text = Language.getMainValue("player_only", true, new TagResolver.Single[0]);
        }
        if (text != null) {
            this.getPlugin().getAudiences().sender(sender).sendMessage(text);
        }
        return false;
    }

    @Override
    public void load() throws IOException {
        SupportManager support = SupportManager.getInstance();
        support.getFork().registerCommand((Plugin)this.getPlugin(), "abyss", Collections.emptyList(), this);
        this.second = this.interval + 1;
        this.task = SupportManager.getInstance().getExecutor().scheduleAtFixedRate(() -> {
            if (--this.second <= 0) {
                Component text;
                List projectiles;
                List<Item> items = this.items_enabled ? this.clearItems().collect(Collectors.toList()) : Collections.emptyList();
                List creatures = this.creatures_enabled ? this.clearCreatures().collect(Collectors.toList()) : Collections.emptyList();
                List list = projectiles = this.projectiles_enabled ? this.clearProjectiles().collect(Collectors.toList()) : Collections.emptyList();
                if (this.items_enabled) {
                    AbstractStacker stacker = support.getStacker();
                    items.forEach(item -> {
                        support.getItemMap().values().forEach(set -> set.remove(item));
                        if (this.items_abyss_enabled && !this.items_abyss_blacklist.contains(item.getItemStack().getType())) {
                            if (stacker != null) {
                                stacker.addItemsToList((Item)item, (List<ItemStack>)this.items);
                            } else {
                                this.inv.addItem(new ItemStack[]{item.getItemStack().clone()});
                            }
                        }
                    });
                    support.getFork().runSync(null, () -> items.forEach(Entity::remove));
                }
                if (this.creatures_enabled) {
                    support.getEntityMap().values().forEach(set -> creatures.forEach(set::remove));
                    support.getFork().runSync(null, () -> creatures.forEach(ent -> {
                        if (this.creatures_dropitems) {
                            ent.damage(Double.MAX_VALUE);
                        }
                        ent.remove();
                    }));
                }
                if (this.projectiles_enabled) {
                    support.getProjectileMap().values().forEach(set -> projectiles.forEach(set::remove));
                    support.getFork().runSync(null, () -> projectiles.forEach(Entity::remove));
                }
                if ((text = this.getLanguage().getComponent("countingdown." + this.second, true, Placeholder.unparsed("remaining", Integer.toString(this.second)), Placeholder.unparsed("items", Integer.toString(items.size())), Placeholder.unparsed("creatures", Integer.toString(creatures.size())), Placeholder.unparsed("projectiles", Integer.toString(projectiles.size())))) != null && this.alerts) {
                    this.getPlugin().getAudiences().players().sendMessage(text);
                }
                if (this.items_abyss_enabled) {
                    this.opened = true;
                    Collection notStored = this.inv.addItem(this.items.toArray(new ItemStack[0])).values();
                    this.items.clear();
                    this.items.addAll(notStored);
                    Component open = this.getLanguage().getComponent("items.abyss.open", true, new TagResolver.Single[0]);
                    if (this.items_abyss_alerts) {
                        this.getPlugin().getAudiences().players().sendMessage(open);
                    }
                    support.getFork().runLater(false, () -> {
                        this.opened = false;
                        ImmutableList.copyOf((Collection)this.inv.getViewers()).forEach(HumanEntity::closeInventory);
                        this.inv.clear();
                        Component close = this.getLanguage().getComponent("items.abyss.close", true, new TagResolver.Single[0]);
                        if (this.items_abyss_alerts) {
                            this.getPlugin().getAudiences().players().sendMessage(close);
                        }
                    }, this.items_abyss_close, TimeUnit.SECONDS);
                }
                this.second = this.interval + 1;
            } else if (this.alerts && this.getLanguage().hasTranslation("countingdown." + this.second)) {
                Component text = this.getLanguage().getComponent("countingdown." + this.second, true, Placeholder.unparsed("remaining", Integer.toString(this.second)), Placeholder.unparsed("items", Long.toString(this.clearItems().count())), Placeholder.unparsed("creatures", Long.toString(this.clearCreatures().count())), Placeholder.unparsed("projectiles", Long.toString(this.clearProjectiles().count())));
                if (text == null) {
                    return;
                }
                this.getPlugin().getAudiences().players().sendMessage(text);
            }
        }, 1L, 1L, TimeUnit.SECONDS);
        this.getPlugin().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
    }

    public Stream<LivingEntity> clearCreatures() {
        LevelledMobsHook hook = LevelledMobsHook.getInstance();
        boolean isEnabled = hook != null && hook.isEnabled() && hook.getLevelledMobs() != null;
        return this.getAllowedWorlds().flatMap(w -> SupportManager.getInstance().getCreatureSet((World)w).stream().filter(ent -> (this.creatures_babies && ent instanceof Ageable && !((Ageable)ent).isAdult() || this.creatures_list.contains(ent.getType())) && (this.creatures_named || !ent.isCustomNameVisible() && ent.getCustomName() == null || isEnabled && hook.getLevelledMobs().isLevelled((Entity)ent))));
    }

    public Stream<Item> clearItems() {
        return this.getAllowedWorlds().flatMap(w -> SupportManager.getInstance().getItemSet((World)w).stream().filter(ent -> !ent.isInvulnerable() && ent.getPickupDelay() < 200 && ent.getTicksLived() * 50 > this.items_timelived && !this.items_blacklist.contains(ent.getItemStack().getType())));
    }

    public Stream<Projectile> clearProjectiles() {
        return this.getAllowedWorlds().flatMap(w -> SupportManager.getInstance().getProjectileSet((World)w).stream().filter(ent -> !this.projectiles_blacklist.contains(ent.getType())));
    }

    @Override
    public boolean loadConfig() {
        this.interval = Math.max(this.getSection().getInt("interval"), 1);
        this.alerts = this.getSection().getBoolean("alerts");
        this.creatures_enabled = this.getSection().getBoolean("creatures.enabled");
        this.creatures_named = this.getSection().getBoolean("creatures.named");
        this.creatures_dropitems = this.getSection().getBoolean("creatures.drop_items");
        this.creatures_babies = this.getSection().getBoolean("creatures.babies");
        this.creatures_list = EnumSet.copyOf(this.getSection().getStringList("creatures.list").stream().map(String::toUpperCase).filter(SupportManager.getEntities()::containsKey).map(SupportManager.getEntities()::get).collect(Collectors.toList()));
        this.items_enabled = this.getSection().getBoolean("items.enabled");
        this.items_timelived = this.getSection().getInt("items.time_lived");
        this.items_disableitemdespawn = this.getSection().getBoolean("items.disable_item_despawn");
        this.items_blacklist = EnumSet.copyOf(this.getSection().getStringList("items.blacklist").stream().map(Material::getMaterial).filter(Objects::nonNull).collect(Collectors.toList()));
        this.items_abyss_enabled = this.getSection().getBoolean("items.abyss.enabled");
        this.items_abyss_alerts = this.getSection().getBoolean("items.abyss.alerts");
        this.items_abyss_permission = this.getSection().getString("items.abyss.permission");
        this.items_abyss_itemdespawn = this.getSection().getBoolean("items.abyss.item_despawn");
        this.items_abyss_close = this.getSection().getInt("items.abyss.close");
        this.items_abyss_blacklist = EnumSet.copyOf(this.getSection().getStringList("items.abyss.blacklist").stream().map(Material::getMaterial).filter(Objects::nonNull).collect(Collectors.toList()));
        this.inv = Bukkit.createInventory(null, (int)this.getSection().getInt("items.abyss.size"), (String)MessageUtils.fixColors(null, this.getLanguage().getString("items.abyss.gui", true, new TagResolver.Single[0])));
        this.projectiles_enabled = this.getSection().getBoolean("projectiles.enabled");
        this.projectiles_blacklist = EnumSet.copyOf(this.getSection().getStringList("projectiles.blacklist").stream().map(String::toUpperCase).filter(SupportManager.getEntities()::containsKey).map(SupportManager.getEntities()::get).collect(Collectors.toList()));
        return true;
    }

    @Override
    public void disable() throws IOException {
        HandlerList.unregisterAll((Listener)this);
        if (this.task != null) {
            this.task.cancel(true);
        }
    }

    public ArrayList<ItemStack> getItems() {
        return this.items;
    }

    public ScheduledFuture<?> getTask() {
        return this.task;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public Inventory getInv() {
        return this.inv;
    }

    public int getSecond() {
        return this.second;
    }

    public int getInterval() {
        return this.interval;
    }

    public boolean isAlerts() {
        return this.alerts;
    }

    public boolean isCreatures_enabled() {
        return this.creatures_enabled;
    }

    public boolean isCreatures_named() {
        return this.creatures_named;
    }

    public boolean isCreatures_dropitems() {
        return this.creatures_dropitems;
    }

    public boolean isCreatures_babies() {
        return this.creatures_babies;
    }

    public EnumSet<EntityType> getCreatures_list() {
        return this.creatures_list;
    }

    public boolean isItems_enabled() {
        return this.items_enabled;
    }

    public boolean isItems_disableitemdespawn() {
        return this.items_disableitemdespawn;
    }

    public boolean isItems_abyss_enabled() {
        return this.items_abyss_enabled;
    }

    public boolean isItems_abyss_alerts() {
        return this.items_abyss_alerts;
    }

    public boolean isItems_abyss_itemdespawn() {
        return this.items_abyss_itemdespawn;
    }

    public String getItems_abyss_permission() {
        return this.items_abyss_permission;
    }

    public int getItems_abyss_close() {
        return this.items_abyss_close;
    }

    public int getItems_timelived() {
        return this.items_timelived;
    }

    public EnumSet<Material> getItems_abyss_blacklist() {
        return this.items_abyss_blacklist;
    }

    public EnumSet<Material> getItems_blacklist() {
        return this.items_blacklist;
    }

    public boolean isProjectiles_enabled() {
        return this.projectiles_enabled;
    }

    public EnumSet<EntityType> getProjectiles_blacklist() {
        return this.projectiles_blacklist;
    }
}

