/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.nms.v1_17_R1;

import java.util.IdentityHashMap;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.entity.vehicle.EntityMinecartContainer;
import net.minecraft.world.entity.vehicle.EntityMinecartFurnace;
import net.minecraft.world.entity.vehicle.EntityMinecartHopper;
import net.minecraft.world.entity.vehicle.EntityMinecartMobSpawner;
import net.minecraft.world.entity.vehicle.EntityMinecartRideable;
import net.minecraft.world.entity.vehicle.EntityMinecartTNT;
import net.minecraft.world.item.ItemStack;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftBoat;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftMinecart;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftMinecartChest;
import org.bukkit.entity.Vehicle;
import xyz.lychee.lagfixer.modules.VehicleMotionReducerModule;
import xyz.lychee.lagfixer.nms.v1_17_R1.OptimizedEntities;

public class VehicleMotionReducer
extends VehicleMotionReducerModule.NMS {
    private static final IdentityHashMap<Class<? extends Entity>, Function<Entity, Entity>> VEHICLES = new IdentityHashMap(7);

    public VehicleMotionReducer(VehicleMotionReducerModule module) {
        super(module);
    }

    @Override
    public boolean optimizeVehicle(Vehicle vehicle) {
        if (vehicle instanceof CraftBoat) {
            if (!this.getModule().isBoat()) {
                return false;
            }
            return this.processEntity((Entity)((CraftBoat)vehicle).getHandle());
        }
        if (vehicle instanceof CraftMinecart) {
            if (!this.getModule().isMinecart()) {
                return false;
            }
            if (vehicle instanceof CraftMinecartChest && this.getModule().isMinecart_remove_chest()) {
                EntityMinecartContainer mc = ((CraftMinecartChest)vehicle).getHandle();
                mc.clear();
                mc.bo();
                return true;
            }
            return this.processEntity((Entity)((CraftMinecart)vehicle).getHandle());
        }
        return false;
    }

    private boolean processEntity(Entity original) {
        if (original instanceof OptimizedEntities) {
            return false;
        }
        Function<Entity, Entity> factory = VEHICLES.get(original.getClass());
        if (factory == null) {
            return false;
        }
        Entity newVehicle = factory.apply(original);
        this.copyLocation(original, newVehicle);
        this.transferItems(original, newVehicle);
        original.bo();
        original.t.addEntity(newVehicle);
        return true;
    }

    private void transferItems(Entity from, Entity to) {
        if (from instanceof EntityMinecartContainer && to instanceof EntityMinecartContainer) {
            for (ItemStack stack : ((EntityMinecartContainer)from).getContents()) {
                if (stack.isEmpty()) continue;
                ((EntityMinecartContainer)to).getContents().add(stack);
            }
            ((EntityMinecartContainer)from).clear();
        }
    }

    private void copyLocation(Entity from, Entity to) {
        to.setPosition(from.u, from.v, from.w);
        to.u = from.u;
        to.v = from.v;
        to.w = from.w;
        float yaw = Location.normalizeYaw((float)from.x);
        to.setYRot(yaw);
        to.x = yaw;
        to.setHeadRotation(yaw);
    }

    static {
        VEHICLES.put(EntityBoat.class, e -> new OptimizedEntities.OBoat((EntityBoat)e));
        VEHICLES.put(EntityMinecartChest.class, e -> new OptimizedEntities.OMinecartChest((EntityMinecartChest)e));
        VEHICLES.put(EntityMinecartHopper.class, e -> new OptimizedEntities.OMinecartHopper((EntityMinecartHopper)e));
        VEHICLES.put(EntityMinecartFurnace.class, e -> new OptimizedEntities.OMinecartFurnace((EntityMinecartFurnace)e));
        VEHICLES.put(EntityMinecartMobSpawner.class, e -> new OptimizedEntities.OMinecartSpawner((EntityMinecartMobSpawner)e));
        VEHICLES.put(EntityMinecartTNT.class, e -> new OptimizedEntities.OMinecartTNT((EntityMinecartTNT)e));
        VEHICLES.put(EntityMinecartRideable.class, e -> new OptimizedEntities.OMinecart((EntityMinecartRideable)e));
    }
}

