/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.nms.v1_20_R1;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityCow;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.entity.animal.horse.EntityHorse;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import xyz.lychee.lagfixer.modules.MobAiReducerModule;

public class MobAiReducer
extends MobAiReducerModule.NMS {
    private static final PathfinderGoal optimized = new PathfinderGoal(){

        public boolean a() {
            return false;
        }
    };
    private final boolean collides;
    private final boolean silent;
    private final boolean mobchip;
    private final boolean typeAenabled;
    private final boolean typeBenabled;
    private final boolean typeCenabled;
    private final boolean temptEnabled;
    private final boolean breedEnabled;
    private final boolean panicEnabled;
    private final ImmutableSet<String> blacklistSet;
    private final ImmutableSet<String> whitelistSet;
    private final PathfinderTargetCondition temptTargeting;
    private final PathfinderTargetCondition breedTargeting;
    private final double temptSpeed;
    private final double breedSpeed;
    private final double panicSpeed;
    private final double panicRange;
    private final int temptCooldown;
    private final int panicCooldown;
    private final boolean temptTriggerBothHands;
    private final boolean temptEvent;
    private final boolean temptTeleport;
    private final boolean breedEvent;
    private final boolean breedTeleport;

    public MobAiReducer(MobAiReducerModule module) {
        super(module);
        ConfigurationSection section = this.getModule().getSection();
        this.collides = section.getBoolean("collides");
        this.silent = section.getBoolean("silent");
        this.mobchip = section.getBoolean("pathfinder.mobchip");
        this.typeAenabled = section.getBoolean("pathfinder.typeA.enabled");
        this.typeBenabled = section.getBoolean("pathfinder.typeB.enabled");
        this.typeCenabled = section.getBoolean("pathfinder.typeC.enabled");
        this.whitelistSet = ImmutableSet.copyOf((Collection)section.getStringList("pathfinder.typeA.whitelist"));
        this.blacklistSet = ImmutableSet.copyOf((Collection)section.getStringList("pathfinder.typeB.blacklist"));
        this.temptEnabled = section.getBoolean("animals.tempt.enabled");
        this.temptTargeting = this.targetingConditions(section, "animals.tempt");
        this.temptSpeed = section.getDouble("animals.tempt.speed");
        this.temptCooldown = section.getInt("animals.tempt.cooldown");
        this.temptTriggerBothHands = section.getBoolean("animals.tempt.trigger_two_hands");
        this.temptEvent = section.getBoolean("animals.tempt.event");
        this.temptTeleport = section.getBoolean("animals.tempt.teleport");
        this.breedEnabled = section.getBoolean("animals.tempt.enabled");
        this.breedTargeting = this.targetingConditions(section, "animals.breed");
        this.breedSpeed = section.getDouble("animals.breed.speed");
        this.breedEvent = section.getBoolean("animals.breed.event");
        this.breedTeleport = section.getBoolean("animals.breed.teleport");
        this.panicEnabled = section.getBoolean("animals.tempt.enabled");
        this.panicCooldown = section.getInt("animals.panic.cooldown");
        this.panicSpeed = section.getDouble("animals.panic.speed");
        this.panicRange = Math.pow(section.getDouble("animals.panic.range"), 2.0);
    }

    private PathfinderTargetCondition targetingConditions(ConfigurationSection section, String key) {
        return PathfinderTargetCondition.b().a(section.getDouble(key + ".range")).d();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void optimize(Entity ent, boolean init) {
        if (ent instanceof CraftCreature) {
            EntityCreature handle = ((CraftCreature)ent).getHandle();
            if (handle.bP.b().stream().noneMatch(pgw -> pgw.i() == Integer.MAX_VALUE)) {
                handle.collides = this.collides;
                handle.d(this.silent);
                handle.bP.a(Integer.MAX_VALUE, optimized);
                Set set = handle.bO.b();
                synchronized (set) {
                    if (this.typeAenabled) {
                        handle.bO.b().removeIf(pgw -> this.checkWrapper(pgw.k()) && StringUtils.contains((CharSequence)pgw.k().getClass().getName(), (CharSequence)"ai.goal") && this.whitelistSet.stream().noneMatch(str -> StringUtils.contains((CharSequence)pgw.k().getClass().getSimpleName(), (CharSequence)str)));
                    } else if (this.typeBenabled) {
                        handle.bO.b().removeIf(pgw -> this.checkWrapper(pgw.k()) && this.blacklistSet.stream().anyMatch(str -> StringUtils.contains((CharSequence)pgw.k().getClass().getSimpleName(), (CharSequence)str)));
                    } else if (this.typeCenabled) {
                        handle.bO.b().removeIf(pgw -> this.checkWrapper(pgw.k()));
                    }
                    if (handle instanceof EntityAnimal) {
                        if (this.breedEnabled) {
                            this.overriteGoal(handle.bO, PathfinderGoalBreed.class, 0, new OptimizedBreedGoal((EntityAnimal)handle));
                        }
                        if (this.panicEnabled) {
                            this.overriteGoal(handle.bO, PathfinderGoalPanic.class, 2, new OptimizedPanicGoal(handle));
                        }
                    }
                    if (this.temptEnabled) {
                        Item item;
                        if (handle instanceof EntityVillager) {
                            item = Items.fW;
                        } else if (handle instanceof EntityHorse) {
                            item = Items.mJ;
                        } else if (handle instanceof EntityPig) {
                            item = Items.rH;
                        } else if (handle instanceof EntityCow || handle instanceof EntitySheep) {
                            item = Items.nA;
                        } else {
                            Object object = item = handle instanceof EntityChicken || handle instanceof EntityParrot ? Items.nz : null;
                        }
                        if (item != null) {
                            this.overriteGoal(handle.bO, PathfinderGoalTempt.class, 1, new OptimizedTemptGoal(handle, item));
                        }
                    }
                }
            }
        }
    }

    public void overriteGoal(PathfinderGoalSelector goalSelector, Class<?> clazz, int piority, PathfinderGoal goal) {
        goalSelector.b().removeIf(wg -> wg.k().getClass().equals(clazz));
        goalSelector.a(piority, goal);
    }

    public boolean checkWrapper(PathfinderGoal goal) {
        return !goal.getClass().getName().contains("mobchip") || !this.mobchip;
    }

    public class OptimizedBreedGoal
    extends PathfinderGoal {
        protected final EntityAnimal animal;
        protected EntityAnimal partner;

        public OptimizedBreedGoal(EntityAnimal entityanimal) {
            this.animal = entityanimal;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        public boolean a() {
            EntityTargetLivingEntityEvent event;
            if (MobAiReducer.this.breedEvent && (event = CraftEventFactory.callEntityTargetLivingEvent((net.minecraft.world.entity.Entity)this.animal, (EntityLiving)this.partner, (EntityTargetEvent.TargetReason)EntityTargetEvent.TargetReason.CUSTOM)).isCancelled()) {
                return false;
            }
            if (this.animal.gc()) {
                EntityAnimal freePartner;
                this.partner = freePartner = this.getFreePartner();
                return freePartner != null;
            }
            return false;
        }

        public boolean b() {
            return this.partner.bs() && this.partner.gc();
        }

        public void e() {
            if (MobAiReducer.this.breedTeleport) {
                this.animal.b(this.partner.dn(), this.partner.dp(), this.partner.dt());
            } else {
                this.animal.J().a((net.minecraft.world.entity.Entity)this.partner, MobAiReducer.this.breedSpeed);
            }
            this.animal.a(this.animal.dI().getMinecraftWorld(), this.partner);
        }

        private EntityAnimal getFreePartner() {
            List nearbyEntities = this.animal.dI().a(this.animal.getClass(), MobAiReducer.this.breedTargeting, (EntityLiving)this.animal, this.animal.cE().g(8.0));
            return nearbyEntities.isEmpty() ? null : (EntityAnimal)nearbyEntities.stream().filter(arg_0 -> ((EntityAnimal)this.animal).a(arg_0)).min(Comparator.comparingDouble(other -> other.f((net.minecraft.world.entity.Entity)this.animal))).orElse(null);
        }
    }

    public class OptimizedPanicGoal
    extends PathfinderGoal {
        protected final EntityCreature mob;
        private EntityLiving lastHurtByMob;
        private int cooldown = 0;

        public OptimizedPanicGoal(EntityCreature mob) {
            this.mob = mob;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        public boolean a() {
            int i = this.cooldown;
            this.cooldown = i - 1;
            if (i <= 0) {
                EntityLiving lastHurtByMob;
                this.lastHurtByMob = lastHurtByMob = this.mob.ed();
                return lastHurtByMob != null;
            }
            return false;
        }

        public boolean b() {
            return this.mob.f((net.minecraft.world.entity.Entity)this.lastHurtByMob) < MobAiReducer.this.panicRange;
        }

        public void e() {
            Vec3D randomPos = DefaultRandomPos.a((EntityCreature)this.mob, (int)16, (int)7, (Vec3D)this.lastHurtByMob.dg());
            if (randomPos != null) {
                this.cooldown = MobAiReducer.this.panicCooldown;
                this.mob.J().a(randomPos.c, randomPos.d, randomPos.e, MobAiReducer.this.panicSpeed);
            }
        }
    }

    public class OptimizedTemptGoal
    extends PathfinderGoal {
        private final EntityCreature mob;
        private final PathfinderTargetCondition targetingConditions;
        private final Item item;
        private int cooldown = 0;

        public OptimizedTemptGoal(EntityCreature mob, Item item) {
            this.mob = mob;
            this.item = item;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
            this.targetingConditions = MobAiReducer.this.temptTargeting.c().a(this.mob.b(GenericAttributes.b)).a(this::shouldFollow);
        }

        public boolean a() {
            int i = this.cooldown;
            this.cooldown = i - 1;
            return i <= 0;
        }

        private boolean shouldFollow(EntityLiving entity) {
            return MobAiReducer.this.temptTriggerBothHands ? entity.eO().a(this.item) || entity.eP().a(this.item) : entity.eO().a(this.item);
        }

        public void e() {
            EntityTargetLivingEntityEvent event;
            this.cooldown = MobAiReducer.this.temptCooldown;
            EntityHuman player = this.mob.dI().a(this.targetingConditions, (EntityLiving)this.mob);
            if (player == null) {
                return;
            }
            if (MobAiReducer.this.temptEvent && (event = CraftEventFactory.callEntityTargetLivingEvent((net.minecraft.world.entity.Entity)this.mob, (EntityLiving)player, (EntityTargetEvent.TargetReason)EntityTargetEvent.TargetReason.TEMPT)).isCancelled()) {
                return;
            }
            if (this.mob.f((net.minecraft.world.entity.Entity)player) >= 6.25 || MobAiReducer.this.temptTeleport) {
                if (!MobAiReducer.this.temptTeleport) {
                    this.mob.J().a((net.minecraft.world.entity.Entity)player, this.mob instanceof EntityAnimal ? MobAiReducer.this.temptSpeed : 0.35);
                    return;
                }
                this.mob.b(player.dn(), player.dp(), player.dt());
                return;
            }
            this.mob.J().n();
        }
    }
}

