/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.nms.v1_20_R3;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.chunk.ChunkStatus;
import org.apache.commons.lang3.RandomStringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R3.CraftChunk;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftCreature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.event.world.EntitiesUnloadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import xyz.lychee.lagfixer.managers.ModuleManager;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.modules.MobAiReducerModule;
import xyz.lychee.lagfixer.modules.VehicleMotionReducerModule;
import xyz.lychee.lagfixer.objects.AbstractSupportNms;

public class SupportNms
extends AbstractSupportNms {
    private final int viewDistance = ((CraftServer)Bukkit.getServer()).getHandle().p();
    private final int simulationDistance = ((CraftServer)Bukkit.getServer()).getHandle().q();
    private final GameRules.GameRuleKey<GameRules.GameRuleInt> randomTickSpeed = GameRules.o;

    public SupportNms(Plugin plugin) {
        super(plugin);
    }

    @Override
    public int getViewDistance() {
        return ((CraftServer)Bukkit.getServer()).getHandle().p();
    }

    @Override
    public int getViewSimulation() {
        return ((CraftServer)Bukkit.getServer()).getHandle().q();
    }

    @Override
    public ItemStack setNBTValue(ItemStack is, String key, String value) {
        ItemMeta meta = is.getItemMeta();
        if (meta != null) {
            meta.getPersistentDataContainer().set(new NamespacedKey(this.getPlugin(), key), PersistentDataType.STRING, (Object)value);
            is.setItemMeta(meta);
        }
        return is;
    }

    @Override
    public boolean hasNBTValue(ItemStack is, String key) {
        ItemMeta meta = is.getItemMeta();
        if (meta != null) {
            return meta.getPersistentDataContainer().has(new NamespacedKey(this.getPlugin(), key));
        }
        return false;
    }

    @Override
    public String getNBTValue(ItemStack is, String key) {
        ItemMeta meta = is.getItemMeta();
        if (meta != null) {
            return (String)meta.getPersistentDataContainer().get(new NamespacedKey(this.getPlugin(), key), PersistentDataType.STRING);
        }
        return null;
    }

    @Override
    public ItemStack createSkull(String base64) {
        ItemStack is = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta meta = is.getItemMeta();
        if (meta == null) {
            return is;
        }
        GameProfile gameProfile = new GameProfile(UUID.randomUUID(), RandomStringUtils.randomAlphabetic((int)8));
        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", base64));
        try {
            Method mtd = meta.getClass().getDeclaredMethod("setProfile", GameProfile.class);
            mtd.setAccessible(true);
            mtd.invoke((Object)meta, gameProfile);
            is.setItemMeta(meta);
            return is;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return is;
        }
    }

    @Override
    public void setDefaultDistance() {
        this.setDistance(this.viewDistance, this.simulationDistance);
    }

    @Override
    public void setRandomTickSpeed(World w, boolean bl) {
        GameRules.GameRuleValue handle = ((CraftWorld)w).getHandle().Z().a(this.randomTickSpeed);
        handle.a(bl ? "3" : "0");
    }

    @Override
    public int getTileEntitiesCount(Chunk c) {
        if (c.isLoaded()) {
            return ((CraftChunk)c).getHandle((ChunkStatus)ChunkStatus.n).k.size();
        }
        return 0;
    }

    @Override
    public int averagePing() {
        List playerList = ((CraftServer)Bukkit.getServer()).getHandle().l;
        return (int)playerList.stream().mapToInt(p -> p.c.l()).average().orElse(0.0);
    }

    @Override
    public void setSpawnLimits(World w, int monsters, int animals, int water_animals, int water_ambient, int water_underground_creature, int axolotls, int ambient) {
        w.setSpawnLimit(SpawnCategory.MONSTER, monsters);
        w.setSpawnLimit(SpawnCategory.ANIMAL, animals);
        w.setSpawnLimit(SpawnCategory.WATER_ANIMAL, water_animals);
        w.setSpawnLimit(SpawnCategory.WATER_AMBIENT, water_ambient);
        w.setSpawnLimit(SpawnCategory.WATER_UNDERGROUND_CREATURE, water_underground_creature);
        w.setSpawnLimit(SpawnCategory.AXOLOTL, axolotls);
        w.setSpawnLimit(SpawnCategory.AMBIENT, ambient);
    }

    @Override
    public double getTps(int time) {
        return ((CraftServer)Bukkit.getServer()).getServer().recentTps[time];
    }

    @Override
    public void setDistance(int view, int simulation) {
        if (view > 0) {
            ((CraftServer)Bukkit.getServer()).getHandle().a(view);
        }
        if (simulation > 0) {
            ((CraftServer)Bukkit.getServer()).getHandle().b(simulation);
        }
    }

    @Override
    public void setEntityAi(Entity ent, boolean bl) {
        if (ent instanceof CraftCreature) {
            EntityCreature mob = ((CraftCreature)ent).getHandle();
            if (mob.fU() != bl) {
                return;
            }
            mob.t(!bl);
            mob.v(!bl);
            mob.d(!bl);
            mob.collides = !bl;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onSpawn(EntitiesLoadEvent e) {
        SupportManager.getInstance().getExecutor().execute(() -> {
            List entities = e.getEntities();
            MobAiReducerModule mobAiReducer = (MobAiReducerModule)ModuleManager.getInstance().get(MobAiReducerModule.class);
            MobAiReducerModule.NMS mobAiReducerNms = mobAiReducer != null && mobAiReducer.canContinue(e.getWorld()) && mobAiReducer.isLoaded() ? mobAiReducer.getMobAiReducer() : null;
            SupportManager support = SupportManager.getInstance();
            HashSet<Vehicle> vehicles = new HashSet<Vehicle>();
            HashSet<LivingEntity> creatures = support.getCreatureSet(e.getWorld());
            HashSet<Item> items = support.getItemSet(e.getWorld());
            HashSet<Projectile> projectiles = support.getProjectileSet(e.getWorld());
            for (Entity ent : entities) {
                if (ent instanceof LivingEntity) {
                    creatures.add((LivingEntity)ent);
                    if (mobAiReducerNms == null || !mobAiReducer.isEnabled(ent)) continue;
                    mobAiReducerNms.optimize(ent, false);
                    continue;
                }
                if (ent instanceof Item) {
                    items.add((Item)ent);
                    continue;
                }
                if (ent instanceof Projectile) {
                    projectiles.add((Projectile)ent);
                    continue;
                }
                if (!(ent instanceof Vehicle)) continue;
                vehicles.add((Vehicle)ent);
            }
            VehicleMotionReducerModule vehicleMotionReducer = (VehicleMotionReducerModule)ModuleManager.getInstance().get(VehicleMotionReducerModule.class);
            if (vehicleMotionReducer != null && vehicleMotionReducer.canContinue(e.getWorld()) && vehicleMotionReducer.isLoaded() && vehicleMotionReducer.isForceLoad()) {
                SupportManager.getInstance().getFork().runSync(null, () -> {
                    VehicleMotionReducerModule.NMS nms = vehicleMotionReducer.getVehicleMotionReducer();
                    for (Vehicle vehicle : vehicles) {
                        nms.optimizeVehicle(vehicle);
                    }
                });
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onUnload(EntitiesUnloadEvent e) {
        SupportManager.getInstance().getExecutor().execute(() -> {
            SupportManager support = SupportManager.getInstance();
            HashSet<LivingEntity> creatures = support.getCreatureSet(e.getWorld());
            HashSet<Item> items = support.getItemSet(e.getWorld());
            HashSet<Projectile> projectiles = support.getProjectileSet(e.getWorld());
            for (Entity entity : e.getEntities()) {
                if (entity instanceof LivingEntity) {
                    creatures.remove(entity);
                    continue;
                }
                if (entity instanceof Item) {
                    items.remove(entity);
                    continue;
                }
                if (!(entity instanceof Projectile)) continue;
                projectiles.remove(entity);
            }
        });
    }
}

