/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.nms.v1_21_R3;

import java.util.IdentityHashMap;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.entity.vehicle.ChestRaft;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.entity.vehicle.EntityMinecartContainer;
import net.minecraft.world.entity.vehicle.EntityMinecartFurnace;
import net.minecraft.world.entity.vehicle.EntityMinecartHopper;
import net.minecraft.world.entity.vehicle.EntityMinecartMobSpawner;
import net.minecraft.world.entity.vehicle.EntityMinecartRideable;
import net.minecraft.world.entity.vehicle.EntityMinecartTNT;
import net.minecraft.world.entity.vehicle.Raft;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.ItemStack;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftBoat;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftMinecart;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftMinecartChest;
import org.bukkit.entity.Vehicle;
import xyz.lychee.lagfixer.modules.VehicleMotionReducerModule;
import xyz.lychee.lagfixer.nms.v1_21_R3.OptimizedEntities;

public class VehicleMotionReducer
extends VehicleMotionReducerModule.NMS {
    private static final IdentityHashMap<Class<? extends VehicleEntity>, Function<VehicleEntity, VehicleEntity>> VEHICLES = new IdentityHashMap(10);

    public VehicleMotionReducer(VehicleMotionReducerModule module) {
        super(module);
    }

    @Override
    public boolean optimizeVehicle(Vehicle vehicle) {
        if (vehicle instanceof CraftBoat) {
            if (!this.getModule().isBoat()) {
                return false;
            }
            return this.processEntity((VehicleEntity)((CraftBoat)vehicle).getHandle());
        }
        if (vehicle instanceof CraftMinecart) {
            if (!this.getModule().isMinecart()) {
                return false;
            }
            if (vehicle instanceof CraftMinecartChest && this.getModule().isMinecart_remove_chest()) {
                EntityMinecartContainer mc = ((CraftMinecartChest)vehicle).getHandle();
                mc.a();
                mc.bQ();
                return true;
            }
            return this.processEntity((VehicleEntity)((CraftMinecart)vehicle).getHandle());
        }
        return false;
    }

    private boolean processEntity(VehicleEntity original) {
        if (original instanceof OptimizedEntities) {
            return false;
        }
        Function<VehicleEntity, VehicleEntity> factory = VEHICLES.get(original.getClass());
        if (factory == null) {
            return false;
        }
        VehicleEntity newVehicle = factory.apply(original);
        this.copyLocation(original, newVehicle);
        this.transferItems(original, newVehicle);
        original.bQ();
        original.dV().b((Entity)newVehicle);
        return true;
    }

    private void transferItems(VehicleEntity from, VehicleEntity to) {
        if (from instanceof ContainerEntity && to instanceof ContainerEntity) {
            for (ItemStack stack : ((ContainerEntity)from).E()) {
                if (stack.f()) continue;
                ((ContainerEntity)to).E().add((Object)stack);
            }
            ((ContainerEntity)from).F();
        }
    }

    private void copyLocation(VehicleEntity from, VehicleEntity to) {
        to.a_(from.K, from.L, from.M);
        to.K = from.K;
        to.L = from.L;
        to.M = from.M;
        float yaw = Location.normalizeYaw((float)from.N);
        to.v(yaw);
        to.N = yaw;
        to.q(yaw);
    }

    static {
        VEHICLES.put(Raft.class, e -> new OptimizedEntities.ORaft((Raft)e));
        VEHICLES.put(ChestRaft.class, e -> new OptimizedEntities.OChestRaft((ChestRaft)e));
        VEHICLES.put(EntityBoat.class, e -> new OptimizedEntities.OBoat((EntityBoat)e));
        VEHICLES.put(ChestBoat.class, e -> new OptimizedEntities.OChestBoat((ChestBoat)e));
        VEHICLES.put(EntityMinecartChest.class, e -> new OptimizedEntities.OMinecartChest((EntityMinecartChest)e));
        VEHICLES.put(EntityMinecartHopper.class, e -> new OptimizedEntities.OMinecartHopper((EntityMinecartHopper)e));
        VEHICLES.put(EntityMinecartFurnace.class, e -> new OptimizedEntities.OMinecartFurnace((EntityMinecartFurnace)e));
        VEHICLES.put(EntityMinecartMobSpawner.class, e -> new OptimizedEntities.OMinecartSpawner((EntityMinecartMobSpawner)e));
        VEHICLES.put(EntityMinecartTNT.class, e -> new OptimizedEntities.OMinecartTNT((EntityMinecartTNT)e));
        VEHICLES.put(EntityMinecartRideable.class, e -> new OptimizedEntities.OMinecart((EntityMinecartRideable)e));
    }
}

