/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.objects;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.Language;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.Component;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.minimessage.MiniMessage;
import xyz.lychee.lagfixer.managers.ModuleManager;
import xyz.lychee.lagfixer.menu.ModuleMenu;
import xyz.lychee.lagfixer.utils.ItemBuilder;

public abstract class AbstractModule {
    private final LagFixer plugin;
    private final ModuleManager manager;
    private final ConfigurationSection section;
    private final HashSet<String> worlds = new HashSet();
    private final Impact impact;
    private final String name;
    private final ImmutableList<String> description;
    private final ItemStack baseSkull;
    private final ModuleMenu menu;
    private boolean loaded = false;
    private Language language;
    private int canContinue;

    public AbstractModule(LagFixer plugin, ModuleManager manager, Impact impact, String name, ImmutableList<String> description, String texture) {
        this.plugin = plugin;
        this.manager = manager;
        this.impact = impact;
        this.name = name;
        this.description = description;
        this.baseSkull = ItemBuilder.createSkull(texture).build();
        this.section = plugin.getConfig().getConfigurationSection("modules." + this.name + ".values");
        this.language = new Language(this);
        long l = this.getSection().getValues(true).values().stream().filter(obj -> !(obj instanceof MemorySection)).count();
        int size = 9 + (l <= 9L ? 9 : (l <= 18L ? 18 : (l <= 27L ? 27 : 36)));
        this.menu = new ModuleMenu(size, this);
    }

    public boolean loadAllConfig() throws Exception {
        FileConfiguration cfg = this.plugin.getConfig();
        this.worlds.clear();
        this.worlds.addAll(cfg.getStringList("modules." + this.name + ".worlds"));
        this.canContinue = this.worlds.isEmpty() ? -1 : (this.worlds.contains("*") ? 1 : 0);
        this.language.loadMessages();
        return this.loadConfig();
    }

    public boolean canContinue(World w) {
        return this.canContinue == 0 ? this.worlds.contains(w.getName()) : this.canContinue == 1;
    }

    public Stream<World> getAllowedWorlds() {
        return Bukkit.getWorlds().stream().filter(this::canContinue);
    }

    public abstract void load() throws Exception;

    public abstract boolean loadConfig() throws Exception;

    public abstract void disable() throws Exception;

    public LagFixer getPlugin() {
        return this.plugin;
    }

    public ModuleManager getManager() {
        return this.manager;
    }

    public ConfigurationSection getSection() {
        return this.section;
    }

    public HashSet<String> getWorlds() {
        return this.worlds;
    }

    public Impact getImpact() {
        return this.impact;
    }

    public String getName() {
        return this.name;
    }

    public ImmutableList<String> getDescription() {
        return this.description;
    }

    public ItemStack getBaseSkull() {
        return this.baseSkull;
    }

    public ModuleMenu getMenu() {
        return this.menu;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public Language getLanguage() {
        return this.language;
    }

    public int getCanContinue() {
        return this.canContinue;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public void setCanContinue(int canContinue) {
        this.canContinue = canContinue;
    }

    public static enum Impact {
        VERY_HIGH("<bold><gradient:#069e00:#0aff00>VERY HIGH</gradient>"),
        HIGH("<bold><gradient:#1fab1a:#3dff2b>HIGH</gradient>"),
        MEDIUM("<bold><gradient:#a6ab1a:#ffe32b>MEDIUM</gradient>"),
        LOW("<bold><gradient:#ab591a:#ff6b2b>LOW</gradient>"),
        VERY_LOW("<bold><gradient:#ab1e1a:#ff322b>VERY LOW</gradient>"),
        VISUAL_ONLY("<bold><gradient:#1a5eab:#26baff>VISUAL ONLY</gradient>");

        private final Component component;

        private Impact(String text) {
            this.component = MiniMessage.miniMessage().deserialize(text);
        }

        public Component getComponent() {
            return this.component;
        }
    }
}

