/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.objects;

import java.util.concurrent.TimeUnit;
import org.bukkit.scheduler.BukkitTask;
import xyz.lychee.lagfixer.managers.SupportManager;

public abstract class AbstractMonitor {
    private double cpuProcess;
    private double cpuSystem;
    private double tps;
    private double mspt;
    private long ramFree;
    private long ramUsed;
    private long ramMax;
    private long ramTotal;
    private BukkitTask task;

    protected abstract double cpuProcess();

    protected abstract double cpuSystem();

    protected abstract double tps();

    protected abstract double tps(int var1);

    protected abstract double mspt();

    public double getTps(int time) {
        return this.tps(time);
    }

    public double format(double d) {
        return (double)((int)(d * 100.0)) / 100.0;
    }

    public long formatBytes(long bytes) {
        return bytes / 1024L / 1024L;
    }

    public void start(int interval) {
        this.task = SupportManager.getInstance().getFork().runTimer(true, () -> {
            this.cpuProcess = this.format(this.cpuProcess());
            this.cpuSystem = this.format(this.cpuSystem());
            this.tps = Math.min(this.format(this.tps()), 20.0);
            this.mspt = this.format(this.mspt());
            Runtime r = Runtime.getRuntime();
            this.ramFree = this.formatBytes(r.freeMemory());
            this.ramUsed = this.formatBytes(r.totalMemory() - r.freeMemory());
            this.ramMax = this.formatBytes(r.maxMemory());
            this.ramTotal = this.formatBytes(r.totalMemory());
        }, 5L, interval, TimeUnit.SECONDS);
    }

    public void stop() {
        if (this.task != null && !this.task.isCancelled()) {
            this.task.cancel();
        }
    }

    public double getCpuProcess() {
        return this.cpuProcess;
    }

    public double getCpuSystem() {
        return this.cpuSystem;
    }

    public double getTps() {
        return this.tps;
    }

    public double getMspt() {
        return this.mspt;
    }

    public long getRamFree() {
        return this.ramFree;
    }

    public long getRamUsed() {
        return this.ramUsed;
    }

    public long getRamMax() {
        return this.ramMax;
    }

    public long getRamTotal() {
        return this.ramTotal;
    }

    public BukkitTask getTask() {
        return this.task;
    }
}

