/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.utils;

import java.time.Duration;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;
import xyz.lychee.lagfixer.hooks.PlaceholderAPIHook;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.Component;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.TextComponent;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.event.ClickEvent;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.event.HoverEvent;
import xyz.lychee.lagfixer.managers.ConfigManager;

public class MessageUtils
extends JavaPlugin {
    private static final HashMap<String, Character> replaceable = new HashMap();

    private static void add(String from, char to) {
        replaceable.put('{' + from + '}', Character.valueOf(to));
    }

    public static String fixColors(@Nullable CommandSender sender, String message) {
        AtomicReference<String> text = new AtomicReference<String>(message);
        replaceable.forEach((from, to) -> text.updateAndGet(s -> s.replace((CharSequence)from, Character.toString(to.charValue()))));
        PlaceholderAPIHook papi = PlaceholderAPIHook.getInstance();
        if (papi != null && papi.isLoaded() && sender instanceof Player) {
            return papi.applyPlaceholders((Player)sender, ChatColor.translateAlternateColorCodes((char)'&', (String)text.get()));
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text.get());
    }

    public static boolean sendMessage(boolean prefix, CommandSender sender, String message) {
        sender.sendMessage(MessageUtils.fixColors(sender, (prefix ? ConfigManager.getInstance().getLegacyPrefix() : "") + "&f" + message));
        return false;
    }

    public static TextComponent formatString(CommandSender sender, String message) {
        TextComponent text = Component.empty();
        Pattern pattern = Pattern.compile("(https?://\\S+)");
        Matcher matcher = pattern.matcher(message);
        int lastEnd = 0;
        while (matcher.find()) {
            String before = message.substring(lastEnd, matcher.start());
            if (!before.isEmpty()) {
                text = (TextComponent)text.append(Component.text(MessageUtils.fixColors(sender, before)));
            }
            String url = MessageUtils.fixColors(sender, matcher.group());
            text = (TextComponent)text.append((Component)((TextComponent)Component.text(url).clickEvent(ClickEvent.openUrl(ChatColor.stripColor((String)url)))).hoverEvent(HoverEvent.showText(ConfigManager.getInstance().getPrefix().append(Component.text("Click to open url!")))));
            lastEnd = matcher.end();
        }
        String remainingText = MessageUtils.fixColors(sender, message.substring(lastEnd));
        if (!remainingText.isEmpty()) {
            text = (TextComponent)text.append(Component.text(remainingText));
        }
        return text;
    }

    public static TextComponent createMessage(boolean bool, TextComponent message) {
        return bool ? (TextComponent)((TextComponent)Component.empty().append(ConfigManager.getInstance().getPrefix())).append(message) : message;
    }

    public static boolean isInteger(String string) {
        return Pattern.matches("-?[0-9]+", string.subSequence(0, string.length()));
    }

    public static String getDurationBreakdown(long duration, boolean showMS) {
        long minutes;
        long hours;
        if (duration <= 0L) {
            return showMS ? "0ms" : "0s";
        }
        StringBuilder sb = new StringBuilder();
        Duration d = Duration.ofMillis(duration);
        long days = d.toDays();
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if ((hours = d.toHours() % 24L) > 0L) {
            sb.append(hours).append("h ");
        }
        if ((minutes = d.toMinutes() % 60L) > 0L) {
            sb.append(minutes).append("m ");
        }
        if (days > 0L) {
            return sb.deleteCharAt(sb.length() - 1).toString();
        }
        long seconds = d.toMillis() / 1000L % 60L;
        long millis = d.toMillis() % 1000L;
        if (seconds > 0L) {
            if (showMS && millis > 0L) {
                sb.append(seconds).append(",").append(millis).append("s");
            } else {
                sb.append(seconds).append("s");
            }
        } else if (showMS && millis > 0L) {
            sb.append(millis).append("ms");
        }
        return sb.toString();
    }

    static {
        MessageUtils.add("*", '\u2022');
        MessageUtils.add(">>", '\u00bb');
        MessageUtils.add("<<", '\u00ab');
    }
}

