/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.objects.AbstractModule;

public final class ReflectionUtils {
    public static Object getPrivateField(Class<?> clazz, Object obj, String fieldName) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        Object ret = field.get(obj);
        field.setAccessible(false);
        return ret;
    }

    public static Field getClassPrivateField(Class<?> clazz, String fieldName) throws NoSuchFieldException, SecurityException, IllegalArgumentException {
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field;
    }

    public static Object invokePrivateMethod(Class<?> clazz, Object obj, String methodName) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return ReflectionUtils.invokePrivateMethod(clazz, obj, methodName, new Class[0], new Object[0]);
    }

    public static Object invokePrivateMethod(Class<?> clazz, Object obj, String methodName, Class<?>[] params, Object ... args) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method method = ReflectionUtils.getPrivateMethod(clazz, methodName, params);
        return method.invoke(obj, args);
    }

    public static Method getPrivateMethod(Class<?> clazz, String methodName, Class<?> ... params) throws NoSuchMethodException, SecurityException {
        Method method = clazz.getDeclaredMethod(methodName, params);
        method.setAccessible(true);
        return method;
    }

    public static Field getPrivateField(Class<?> clazz, Class<?> type) {
        for (Field f : clazz.getDeclaredFields()) {
            if (f.getType() != type) continue;
            f.setAccessible(true);
            return f;
        }
        return null;
    }

    public static <T> T createInstance(String name, AbstractModule module) {
        String version = ReflectionUtils.getVersion(name);
        try {
            Class<?> clazz = Class.forName("xyz.lychee.lagfixer.nms." + version + "." + name);
            return (T)clazz.getConstructor(module.getClass()).newInstance(module);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            return null;
        }
    }

    public static String getVersion(String clazz) {
        String versionPackage = Bukkit.getServer().getClass().getPackage().getName();
        String nmsVersion = versionPackage.substring(versionPackage.lastIndexOf(46) + 1);
        try {
            Class.forName("xyz.lychee.lagfixer.nms." + nmsVersion + "." + clazz);
            return nmsVersion;
        }
        catch (ClassNotFoundException ex) {
            return SupportManager.getInstance().getVersions().get(Bukkit.getServer().getBukkitVersion().split("-")[0]);
        }
    }
}

