/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.menu;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.Language;
import xyz.lychee.lagfixer.managers.CommandManager;
import xyz.lychee.lagfixer.managers.ModuleManager;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.objects.AbstractMenu;
import xyz.lychee.lagfixer.objects.AbstractModule;
import xyz.lychee.lagfixer.utils.MessageUtils;

public class ModulesMenu
extends AbstractMenu {
    public ModulesMenu(LagFixer plugin, int size, String title) {
        super(plugin, size, title, -1, true);
    }

    @Override
    public void update() {
        this.getInv().clear();
        this.surroundInventory();
        ModuleManager.getInstance().getModules().values().stream().sorted(Comparator.comparing(AbstractModule::getName)).forEach(module -> {
            ItemStack imodule = module.getBaseSkull().clone();
            SupportManager.getInstance().getNms().setNBTValue(imodule, "module", module.getClass().getSimpleName());
            ItemMeta meta = imodule.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(MessageUtils.fixColors(null, "&6&l\u2b50 &f&lModule: &e&l" + module.getName()));
                ArrayList lore = Lists.newArrayList((Object[])new String[]{" &8{*} &7Status: " + (module.isLoaded() ? "&a&lENABLED" : "&c&lDISABLED"), " &8{*} &7Customizable values: &e" + module.getSection().getValues(true).values().stream().filter(obj -> !(obj instanceof ConfigurationSection)).count(), " &8{*} &7Performance: " + Language.getSerializer().serialize(module.getImpact().getComponent()), "", "&b&nClick to modify configuration!", "", "&eDescription:"});
                for (String line : module.getDescription()) {
                    StringBuilder lineBuilder = new StringBuilder(" &8{*} &7");
                    int wordCount = 0;
                    for (String word : line.split("\\s+")) {
                        if (wordCount < 5 && lineBuilder.length() < 40) {
                            lineBuilder.append(word).append(' ');
                            ++wordCount;
                            continue;
                        }
                        lore.add(lineBuilder.toString().trim());
                        lineBuilder = new StringBuilder("&7").append(word).append(' ');
                        wordCount = 1;
                    }
                    if (lineBuilder.length() == 0) continue;
                    lore.add(lineBuilder.toString().trim());
                }
                meta.setLore(lore.stream().map(str -> MessageUtils.fixColors(null, str)).collect(Collectors.toList()));
                imodule.setItemMeta(meta);
            }
            this.getInv().addItem(new ItemStack[]{imodule});
        });
        this.fillInventory();
    }

    @Override
    public void handleClick(InventoryClickEvent e, ItemStack item) {
        if (item.getType() == Material.PLAYER_HEAD) {
            HumanEntity human = e.getWhoClicked();
            String name = SupportManager.getInstance().getNms().getNBTValue(e.getCurrentItem(), "module");
            Object module = ModuleManager.getInstance().get(name);
            if (module == null) {
                human.closeInventory();
                MessageUtils.sendMessage(true, (CommandSender)human, "Unknown module with class: " + name);
                return;
            }
            human.openInventory(((AbstractModule)module).getMenu().getInv());
        }
    }

    @Override
    public AbstractMenu previousMenu() {
        return CommandManager.getInstance().getMainMenu();
    }
}

