/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.modules;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.managers.HookManager;
import xyz.lychee.lagfixer.managers.ModuleManager;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.objects.AbstractModule;
import xyz.lychee.lagfixer.objects.AbstractSupportNms;
import xyz.lychee.lagfixer.utils.ReflectionUtils;

public class EntityLimiterModule
extends AbstractModule
implements Listener {
    private final EnumSet<CreatureSpawnEvent.SpawnReason> reasons = EnumSet.noneOf(CreatureSpawnEvent.SpawnReason.class);
    private final EnumSet<EntityType> whitelist = EnumSet.noneOf(EntityType.class);
    private int locks;
    private BukkitTask alerts_task;
    private BukkitTask overflow_task;
    private boolean alerts;
    private boolean perchunk_enabled;
    private boolean perchunk_ignore_models;
    private int perchunk_creatures;
    private int perchunk_items;
    private int perchunk_vehicles;
    private int perchunk_projectiles;
    private boolean perworld_enabled;
    private int perworld_monsters;
    private int perworld_animals;
    private int perworld_water_animals;
    private int perworld_water_ambient;
    private int perworld_water_underground_creature;
    private int perworld_axolotls;
    private int perworld_ambient;
    private boolean overflow_enabled;
    private int overflow_interval;
    private double overflow_multiplier;
    private boolean overflow_creatures;
    private boolean overflow_items;
    private boolean overflow_vehicles;
    private boolean overflow_projectiles;
    private boolean overflow_named;

    public EntityLimiterModule(LagFixer plugin, ModuleManager manager) {
        super(plugin, manager, AbstractModule.Impact.HIGH, "EntityLimiter", (ImmutableList<String>)ImmutableList.of((Object)"Restricts the number of entities per chunk.", (Object)"Essential for survival servers with expansive animal farms.", (Object)"Prevents excessive entity accumulation and associated performance issues.", (Object)"Maintains stable performance levels even in environments with high entity density."), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZWRjMzZjOWNiNTBhNTI3YWE1NTYwN2EwZGY3MTg1YWQyMGFhYmFhOTAzZThkOWFiZmM3ODI2MDcwNTU0MGRlZiJ9fX0=");
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onSpawn(CreatureSpawnEvent e) {
        if (this.perchunk_creatures < 1 || !this.canContinue(e.getLocation().getWorld()) || !this.reasons.contains(e.getSpawnReason()) || this.whitelist.contains(e.getEntityType())) {
            return;
        }
        if (this.perchunk_enabled && this.countEntities(e.getLocation().getChunk(), LivingEntity.class) >= (long)this.perchunk_creatures && (this.perchunk_ignore_models || HookManager.getInstance().getModel().hasModel((Entity)e.getEntity()))) {
            e.setCancelled(true);
            ++this.locks;
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent e) {
        if (this.perchunk_items < 1 || !this.canContinue(e.getItemDrop().getWorld()) || this.whitelist.contains(e.getItemDrop().getType())) {
            return;
        }
        if (this.perchunk_enabled && this.countEntities(e.getItemDrop().getLocation().getChunk(), Item.class) >= (long)this.perchunk_items) {
            e.setCancelled(true);
            ++this.locks;
        }
    }

    @EventHandler
    public void onVehicle(VehicleCreateEvent e) {
        if (this.perchunk_vehicles < 1 || !this.canContinue(e.getVehicle().getWorld()) || this.whitelist.contains(e.getVehicle().getType())) {
            return;
        }
        if (this.perchunk_enabled && this.countEntities(e.getVehicle().getLocation().getChunk(), Vehicle.class) >= (long)this.perchunk_vehicles) {
            e.setCancelled(true);
            ++this.locks;
        }
    }

    @EventHandler
    public void onLaunch(ProjectileLaunchEvent e) {
        if (this.perchunk_projectiles < 1 || !this.canContinue(e.getLocation().getWorld()) || this.whitelist.contains(e.getEntityType())) {
            return;
        }
        if (this.perchunk_enabled && this.countEntities(e.getLocation().getChunk(), Projectile.class) >= (long)this.perchunk_projectiles) {
            e.setCancelled(true);
            ++this.locks;
        }
    }

    public long countEntities(Chunk c, Class<? extends Entity> clazz) {
        if (!c.isLoaded()) {
            return 0L;
        }
        Entity[] entities = c.getEntities();
        int count = 0;
        for (Entity entity : entities) {
            if (!clazz.isInstance(entity) || this.whitelist.contains(entity.getType())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void load() {
        if (this.perchunk_enabled) {
            if (this.alerts) {
                this.alerts_task = SupportManager.getInstance().getFork().runTimer(true, () -> {
                    if (this.locks > 75) {
                        this.getPlugin().getLogger().info("Entity limiter cancelled " + this.locks + " events!");
                        this.locks = 0;
                    }
                }, 2L, 2L, TimeUnit.SECONDS);
            }
            this.getPlugin().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
        }
        if (this.overflow_enabled) {
            int limit_creatures = (int)((double)this.perchunk_creatures * this.overflow_multiplier);
            int limit_items = (int)((double)this.perchunk_items * this.overflow_multiplier);
            int limit_vehicles = (int)((double)this.perchunk_vehicles * this.overflow_multiplier);
            int limit_projectiles = (int)((double)this.perchunk_projectiles * this.overflow_multiplier);
            boolean checkCreatures = this.overflow_creatures;
            boolean checkItems = this.overflow_items;
            boolean checkVehicles = this.overflow_vehicles;
            boolean checkProjectiles = this.overflow_projectiles;
            this.overflow_task = SupportManager.getInstance().getFork().runTimer(false, () -> this.getAllowedWorlds().forEach(w -> {
                Chunk[] chunks;
                for (Chunk chunk : chunks = w.getLoadedChunks()) {
                    Entity[] entities = chunk.getEntities();
                    if (entities.length == 0) continue;
                    int creatures = 0;
                    int items = 0;
                    int vehicles = 0;
                    int projectiles = 0;
                    for (Entity entity : entities) {
                        if (this.whitelist.contains(entity.getType()) || !this.overflow_named && entity.getCustomName() != null || !this.perchunk_ignore_models && HookManager.getInstance().getModel().hasModel(entity)) continue;
                        boolean removed = false;
                        if (checkCreatures && entity instanceof Creature) {
                            if (creatures < limit_creatures) {
                                ++creatures;
                            } else {
                                removed = true;
                            }
                        } else if (checkItems && entity instanceof Item) {
                            if (items < limit_items) {
                                ++items;
                            } else {
                                removed = true;
                            }
                        } else if (checkVehicles && entity instanceof Vehicle) {
                            if (vehicles < limit_vehicles) {
                                ++vehicles;
                            } else {
                                removed = true;
                            }
                        } else if (checkProjectiles && entity instanceof Projectile) {
                            if (projectiles < limit_projectiles) {
                                ++projectiles;
                            } else {
                                removed = true;
                            }
                        }
                        if (!removed) continue;
                        entity.remove();
                        ++this.locks;
                    }
                }
            }), this.overflow_interval, this.overflow_interval, TimeUnit.SECONDS);
        }
        if (this.perworld_enabled) {
            SupportManager.getInstance().getFork().runNow(false, null, () -> {
                AbstractSupportNms nms = SupportManager.getInstance().getNms();
                this.getAllowedWorlds().forEach(w -> nms.setSpawnLimits((World)w, this.perworld_monsters, this.perworld_animals, this.perworld_water_animals, this.perworld_water_ambient, this.perworld_water_underground_creature, this.perworld_axolotls, this.perworld_ambient));
            });
        }
    }

    @Override
    public boolean loadConfig() {
        this.alerts = this.getSection().getBoolean("alerts");
        this.perchunk_enabled = this.getSection().getBoolean("perchunk.enabled");
        if (this.perchunk_enabled) {
            this.perchunk_ignore_models = HookManager.getInstance().noneModels() || this.getSection().getBoolean("perchunk.ignore_models");
            this.perchunk_creatures = this.getSection().getInt("perchunk.creatures");
            this.perchunk_items = this.getSection().getInt("perchunk.items");
            this.perchunk_vehicles = this.getSection().getInt("perchunk.vehicles");
            this.perchunk_projectiles = this.getSection().getInt("perchunk.projectiles");
            ReflectionUtils.convertEnums(CreatureSpawnEvent.SpawnReason.class, this.reasons, this.getSection().getStringList("perchunk.reasons"));
            ReflectionUtils.convertEnums(EntityType.class, this.whitelist, this.getSection().getStringList("whitelist"));
            this.overflow_interval = this.getSection().getInt("perchunk.overflow_purge.interval");
            boolean bl = this.overflow_enabled = this.overflow_interval >= 0 && this.getSection().getBoolean("perchunk.overflow_purge.enabled");
            if (this.overflow_enabled) {
                this.overflow_multiplier = this.getSection().getDouble("perchunk.overflow_purge.limit_multiplier");
                this.overflow_creatures = this.perchunk_creatures > 0 && this.getSection().getBoolean("perchunk.overflow_purge.types.creatures");
                this.overflow_items = this.perchunk_items > 0 && this.getSection().getBoolean("perchunk.overflow_purge.types.items");
                this.overflow_vehicles = this.perchunk_vehicles > 0 && this.getSection().getBoolean("perchunk.overflow_purge.types.vehicles");
                this.overflow_projectiles = this.perchunk_projectiles > 0 && this.getSection().getBoolean("perchunk.overflow_purge.types.projectiles");
                this.overflow_named = this.getSection().getBoolean("perchunk.overflow_purge.types.named");
            }
        }
        this.perworld_enabled = this.getSection().getBoolean("perworld.enabled");
        if (this.perworld_enabled) {
            this.perworld_animals = this.getSection().getInt("perworld.animals");
            this.perworld_monsters = this.getSection().getInt("perworld.monsters");
            this.perworld_water_animals = this.getSection().getInt("perworld.water_animals");
            this.perworld_water_ambient = this.getSection().getInt("perworld.water_ambient");
            this.perworld_water_underground_creature = this.getSection().getInt("perworld.water_underground_creature");
            this.perworld_axolotls = this.getSection().getInt("perworld.axolotls");
            this.perworld_ambient = this.getSection().getInt("perworld.ambient");
        }
        return true;
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.alerts_task != null) {
            this.alerts_task.cancel();
        }
        if (this.overflow_task != null) {
            this.overflow_task.cancel();
        }
    }
}

