/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.nms.v1_21_R1;

import com.google.common.collect.MapMaker;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityCow;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.EntityPanda;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.EntityHorse;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.hoglin.EntityHoglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.modules.MobAiReducerModule;

public class MobAiReducer
extends MobAiReducerModule.NMS
implements Listener {
    private final Map<EntityCreature, Boolean> optimizedMobs = new MapMaker().weakKeys().concurrencyLevel(4).makeMap();
    private final Map<Class<? extends net.minecraft.world.entity.Entity>, PathfinderTargetCondition> temptTargeting = new HashMap<Class<? extends net.minecraft.world.entity.Entity>, PathfinderTargetCondition>();
    private final PathfinderTargetCondition breedTargeting = PathfinderTargetCondition.b().d();

    public MobAiReducer(MobAiReducerModule module) {
        super(module);
    }

    @Override
    public void load() {
        this.breedTargeting.a(this.getModule().getBreedRange());
        this.register(EntityHorse.class, (TagKey<Item>)TagsItem.af);
        this.register(EntityCow.class, (TagKey<Item>)TagsItem.aa);
        this.register(EntitySheep.class, (TagKey<Item>)TagsItem.ac);
        this.register(EntityFox.class, (TagKey<Item>)TagsItem.Z);
        this.register(EntityPig.class, (TagKey<Item>)TagsItem.ar);
        this.register(EntityChicken.class, (TagKey<Item>)TagsItem.ak);
        this.register(EntityParrot.class, (TagKey<Item>)TagsItem.aw);
        this.register(Frog.class, (TagKey<Item>)TagsItem.al);
        this.register(Axolotl.class, (TagKey<Item>)TagsItem.ay);
        this.register(Goat.class, (TagKey<Item>)TagsItem.ab);
        this.register(EntityBee.class, (TagKey<Item>)TagsItem.aj);
        this.register(EntityWolf.class, (TagKey<Item>)TagsItem.ad);
        this.register(EntityTurtle.class, (TagKey<Item>)TagsItem.av);
        this.register(EntityStrider.class, (TagKey<Item>)TagsItem.at);
        this.register(EntityRabbit.class, (TagKey<Item>)TagsItem.as);
        this.register(EntityPiglin.class, (TagKey<Item>)TagsItem.Y);
        this.register(EntityPanda.class, (TagKey<Item>)TagsItem.aq);
        this.register(EntityOcelot.class, (TagKey<Item>)TagsItem.ap);
        this.register(EntityLlama.class, (TagKey<Item>)TagsItem.an);
        this.register(EntityHoglin.class, (TagKey<Item>)TagsItem.am);
        this.register(Camel.class, (TagKey<Item>)TagsItem.ah);
        this.register(Armadillo.class, (TagKey<Item>)TagsItem.ai);
        this.register(Sniffer.class, (TagKey<Item>)TagsItem.X);
    }

    private void register(Class<? extends net.minecraft.world.entity.Entity> clazz, TagKey<Item> item) {
        this.temptTargeting.computeIfAbsent(clazz, k -> PathfinderTargetCondition.b().d()).a(this.getModule().getTemptRange()).a(entity -> entity.eT().a(item) || this.getModule().isTemptTriggerBothHands() && entity.eU().a(item));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void optimize(Entity ent, boolean init) {
        Set goals;
        if (!(ent instanceof CraftCreature)) {
            return;
        }
        EntityCreature handle = ((CraftCreature)ent).getHandle();
        if (this.optimizedMobs.containsKey(handle)) {
            return;
        }
        MobAiReducerModule module = this.getModule();
        boolean keepDedicated = module.isKeep_dedicated();
        boolean aiListMode = module.isAi_list_mode();
        HashSet<String> aiList = module.getAi_list();
        handle.collides = module.isCollides();
        handle.e(module.isSilent());
        this.optimizedMobs.put(handle, Boolean.TRUE);
        boolean isAnimal = handle instanceof EntityAnimal;
        Class<?> handleClass = handle.getClass();
        PathfinderTargetCondition temptTargeting = module.isTemptEnabled() ? this.temptTargeting.get(handleClass) : null;
        Set set = goals = handle.bW.b();
        synchronized (set) {
            HashSet<PathfinderGoalWrapped> toAdd = new HashSet<PathfinderGoalWrapped>();
            HashSet<PathfinderGoalWrapped> toRemove = new HashSet<PathfinderGoalWrapped>();
            for (PathfinderGoalWrapped pgw : goals) {
                PathfinderGoal goal = pgw.k();
                Class<?> goalClass = goal.getClass();
                if (keepDedicated && !goalClass.getName().contains("ai.goal")) continue;
                if (isAnimal && module.isBreedEnabled() && goalClass == PathfinderGoalBreed.class) {
                    toRemove.add(pgw);
                    toAdd.add(new PathfinderGoalWrapped(pgw.i(), (PathfinderGoal)new OptimizedBreedGoal((EntityAnimal)handle)));
                    continue;
                }
                if (module.isTemptEnabled() && goalClass == PathfinderGoalTempt.class && temptTargeting != null) {
                    toRemove.add(pgw);
                    toAdd.add(new PathfinderGoalWrapped(pgw.i(), (PathfinderGoal)new OptimizedTemptGoal(handle, temptTargeting)));
                    continue;
                }
                String simpleName = goalClass.getSimpleName();
                if (aiList.stream().anyMatch(simpleName::contains) != aiListMode) continue;
                toRemove.add(pgw);
            }
            if (!toRemove.isEmpty()) {
                goals.removeAll(toRemove);
            }
            if (!toAdd.isEmpty()) {
                goals.addAll(toAdd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge() {
        Map<EntityCreature, Boolean> map = this.optimizedMobs;
        synchronized (map) {
            this.optimizedMobs.keySet().removeIf(ent -> !ent.bE() || !ent.valid);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onLoad(EntitiesLoadEvent e) {
        if (!this.getModule().canContinue(e.getWorld())) {
            return;
        }
        if (this.getModule().isAsync()) {
            SupportManager.getInstance().getExecutor().execute(() -> this.optimizeEntities(e.getEntities()));
        } else {
            this.optimizeEntities(e.getEntities());
        }
    }

    public void optimizeEntities(List<Entity> list) {
        for (Entity entity : list) {
            if (!this.getModule().isEnabled(entity)) continue;
            this.optimize(entity, false);
        }
    }

    public class OptimizedBreedGoal
    extends PathfinderGoal {
        protected final EntityAnimal animal;
        protected EntityAnimal partner;

        public OptimizedBreedGoal(EntityAnimal entityanimal) {
            this.animal = entityanimal;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        public boolean b() {
            if (!this.animal.gs()) {
                return false;
            }
            this.partner = this.getFreePartner();
            if (this.partner == null || !this.partner.bE() || !this.partner.gs()) {
                return false;
            }
            if (MobAiReducer.this.getModule().isBreedEvent()) {
                EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent((net.minecraft.world.entity.Entity)this.animal, (EntityLiving)this.partner, (EntityTargetEvent.TargetReason)EntityTargetEvent.TargetReason.CUSTOM);
                return !event.isCancelled();
            }
            return true;
        }

        public void a() {
            if (MobAiReducer.this.getModule().isBreedTeleport()) {
                this.animal.c(this.partner.dt(), this.partner.dv(), this.partner.dz());
            } else {
                this.animal.N().a((net.minecraft.world.entity.Entity)this.partner, MobAiReducer.this.getModule().getBreedSpeed());
            }
            this.animal.a(this.animal.dO().getMinecraftWorld(), this.partner);
        }

        private EntityAnimal getFreePartner() {
            List nearbyEntities = this.animal.dO().a(this.animal.getClass(), MobAiReducer.this.breedTargeting, (EntityLiving)this.animal, this.animal.cK().g(8.0));
            return nearbyEntities.stream().filter(arg_0 -> ((EntityAnimal)this.animal).a(arg_0)).min(Comparator.comparingDouble(other -> other.g((net.minecraft.world.entity.Entity)this.animal))).orElse(null);
        }
    }

    public class OptimizedTemptGoal
    extends PathfinderGoal {
        private final EntityCreature mob;
        private final PathfinderTargetCondition targeting;
        private int cooldown = 0;
        private EntityHuman targetPlayer;

        public OptimizedTemptGoal(EntityCreature mob, PathfinderTargetCondition targeting) {
            this.mob = mob;
            this.targeting = targeting;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        public boolean b() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            this.targetPlayer = this.mob.dO().a(this.targeting, (EntityLiving)this.mob);
            if (this.targetPlayer == null) {
                return false;
            }
            if (MobAiReducer.this.getModule().isTemptEvent()) {
                EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent((net.minecraft.world.entity.Entity)this.mob, (EntityLiving)this.targetPlayer, (EntityTargetEvent.TargetReason)EntityTargetEvent.TargetReason.TEMPT);
                return !event.isCancelled();
            }
            return true;
        }

        public void a() {
            if (this.mob.g((net.minecraft.world.entity.Entity)this.targetPlayer) >= 6.25 || MobAiReducer.this.getModule().isTemptTeleport()) {
                if (MobAiReducer.this.getModule().isTemptTeleport()) {
                    this.mob.c(this.targetPlayer.dt(), this.targetPlayer.dv(), this.targetPlayer.dz());
                } else {
                    this.mob.N().a((net.minecraft.world.entity.Entity)this.targetPlayer, this.mob instanceof EntityAnimal ? MobAiReducer.this.getModule().getTemptSpeed() : 0.35);
                }
            } else {
                this.mob.N().n();
            }
            this.cooldown = MobAiReducer.this.getModule().getTemptCooldown();
        }
    }
}

