/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.commands;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.Language;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.Component;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import xyz.lychee.lagfixer.managers.CommandManager;
import xyz.lychee.lagfixer.menu.HardwareMenu;
import xyz.lychee.lagfixer.menu.MainMenu;
import xyz.lychee.lagfixer.menu.ModulesMenu;
import xyz.lychee.lagfixer.utils.MessageUtils;

public class MenuCommand
extends CommandManager.Subcommand {
    private static MenuCommand instance;
    private MainMenu mainMenu;
    private ModulesMenu modulesMenu;
    private HardwareMenu hardwareMenu;

    public MenuCommand(CommandManager commandManager) {
        super(commandManager, "menu", "open lagfixer menu, and edit configuration", "gui");
        instance = this;
    }

    @Override
    public void load() {
        LagFixer plugin = this.getCommandManager().getPlugin();
        this.mainMenu = new MainMenu(plugin, 27, MessageUtils.fixColors(null, "&8[&e&l\u26a1&8] &fMenu! &8| &eLagFixer"));
        this.mainMenu.load();
        this.modulesMenu = new ModulesMenu(plugin, 45, MessageUtils.fixColors(null, "&8[&e&l\u26a1&8] &fModules! &8| &eLagFixer"));
        this.modulesMenu.load();
        try {
            this.hardwareMenu = new HardwareMenu(plugin, 27, MessageUtils.fixColors(null, "&8[&e&l\u26a1&8] &fHardware! &8| &eLagFixer"));
            this.hardwareMenu.load();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void unload() {
        this.mainMenu.unload();
        this.modulesMenu.unload();
        if (this.hardwareMenu != null) {
            this.hardwareMenu.unload();
        }
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String[] args) {
        if (sender instanceof Player) {
            ((Player)sender).openInventory(this.mainMenu.getInv());
        } else {
            Component text = Language.getMainValue("player_only", true, new TagResolver.Single[0]);
            if (text != null) {
                LagFixer.getInstance().getAudiences().sender(sender).sendMessage(text);
            }
        }
        return true;
    }

    public MainMenu getMainMenu() {
        return this.mainMenu;
    }

    public ModulesMenu getModulesMenu() {
        return this.modulesMenu;
    }

    public HardwareMenu getHardwareMenu() {
        return this.hardwareMenu;
    }

    public static MenuCommand getInstance() {
        return instance;
    }
}

