/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.managers;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.hooks.ModelEngineHook;
import xyz.lychee.lagfixer.hooks.MythicMobsHook;
import xyz.lychee.lagfixer.hooks.PlaceholderAPIHook;
import xyz.lychee.lagfixer.hooks.RoseStackerHook;
import xyz.lychee.lagfixer.hooks.SparkHook;
import xyz.lychee.lagfixer.hooks.StackMobHook;
import xyz.lychee.lagfixer.hooks.UltimateStackerHook;
import xyz.lychee.lagfixer.hooks.WildStackerHook;
import xyz.lychee.lagfixer.objects.AbstractHook;
import xyz.lychee.lagfixer.objects.AbstractManager;
import xyz.lychee.lagfixer.utils.TimingUtil;

public class HookManager
extends AbstractManager {
    private static HookManager instance;
    private final Map<String, AbstractHook> hooks = new HashMap<String, AbstractHook>();
    private final Map<Class<? extends AbstractHook>, AbstractHook> loadedHooks = new HashMap<Class<? extends AbstractHook>, AbstractHook>();
    private final Map<String, ModelContainer> modelHooks = new HashMap<String, ModelContainer>();
    private final Map<String, StackerContainer> stackerHooks = new HashMap<String, StackerContainer>();

    public HookManager(LagFixer plugin) {
        super(plugin);
        instance = this;
        this.add(new PlaceholderAPIHook(plugin, this));
        this.add(new SparkHook(plugin, this));
        this.add(new WildStackerHook(plugin, this));
        this.add(new RoseStackerHook(plugin, this));
        this.add(new UltimateStackerHook(plugin, this));
        this.add(new ModelEngineHook(plugin, this));
        this.add(new MythicMobsHook(plugin, this));
        this.add(new StackMobHook(plugin, this));
    }

    protected void add(AbstractHook hook) {
        this.hooks.put(hook.getName(), hook);
    }

    @Nullable
    public <T extends AbstractHook> T getHook(Class<T> clazz) {
        return (T)(this.loadedHooks.containsKey(clazz) ? (AbstractHook)clazz.cast(this.loadedHooks.get(clazz)) : null);
    }

    @Nullable
    public StackerContainer getStacker() {
        Iterator<StackerContainer> iterator = this.stackerHooks.values().iterator();
        if (iterator.hasNext()) {
            StackerContainer stacker = iterator.next();
            return stacker;
        }
        return null;
    }

    @Nullable
    public ModelContainer getModel() {
        Iterator<ModelContainer> iterator = this.modelHooks.values().iterator();
        if (iterator.hasNext()) {
            ModelContainer model = iterator.next();
            return model;
        }
        return null;
    }

    public boolean noneStackers() {
        return this.stackerHooks.isEmpty();
    }

    public boolean noneModels() {
        return this.modelHooks.isEmpty();
    }

    public void addLoaded(AbstractHook hook) {
        this.loadedHooks.put(hook.getClass(), hook);
        if (hook instanceof ModelContainer) {
            this.modelHooks.put(hook.getName(), (ModelContainer)((Object)hook));
        }
        if (hook instanceof StackerContainer) {
            this.stackerHooks.put(hook.getName(), (StackerContainer)((Object)hook));
        }
    }

    public void removeLoaded(AbstractHook hook) {
        hook.setLoaded(false);
        this.loadedHooks.remove(hook.getClass());
        this.modelHooks.remove(hook.getName());
        this.stackerHooks.remove(hook.getName());
    }

    @Override
    public void load() {
        for (AbstractHook hook : this.hooks.values()) {
            if (!hook.isSupported()) continue;
            try {
                TimingUtil t = TimingUtil.startNew();
                hook.load();
                this.addLoaded(hook);
                this.getPlugin().getLogger().info(" &8\u2022 &rSuccessfully loaded hook " + hook.getName() + " in " + t.stop().getExecutingTime() + "ms!");
            }
            catch (Exception ex) {
                this.getPlugin().getLogger().info(" &8\u2022 &cError with enabling hook " + hook.getName() + ", reason: " + ex.getMessage());
                this.getPlugin().printError(ex);
            }
        }
    }

    @Override
    public void disable() {
        for (AbstractHook hook : this.hooks.values()) {
            if (!hook.isSupported()) continue;
            try {
                TimingUtil t = TimingUtil.startNew();
                hook.disable();
                this.removeLoaded(hook);
                this.getPlugin().getLogger().info(" &8\u2022 &rSuccessfully disabled hook " + hook.getName() + " in " + t.stop().getExecutingTime() + "ms!");
            }
            catch (Exception ex) {
                this.getPlugin().getLogger().info(" &8\u2022 &cError with disabling hook " + hook.getName() + ", reason: " + ex.getMessage());
                this.getPlugin().printError(ex);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public static HookManager getInstance() {
        return instance;
    }

    public static interface StackerContainer {
        public void addItemsToList(Item var1, Collection<ItemStack> var2);

        public boolean isStacked(LivingEntity var1);
    }

    public static interface ModelContainer {
        public boolean hasModel(Entity var1);
    }
}

