/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.nms.v1_16_R3;

import java.util.IdentityHashMap;
import java.util.function.Function;
import net.minecraft.server.v1_16_R3.EntityBoat;
import net.minecraft.server.v1_16_R3.EntityMinecartChest;
import net.minecraft.server.v1_16_R3.EntityMinecartContainer;
import net.minecraft.server.v1_16_R3.EntityMinecartFurnace;
import net.minecraft.server.v1_16_R3.EntityMinecartHopper;
import net.minecraft.server.v1_16_R3.EntityMinecartRideable;
import net.minecraft.server.v1_16_R3.EntityMinecartTNT;
import net.minecraft.server.v1_16_R3.ItemStack;
import net.minecraft.server.v1_16_R3.Vec3D;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftBoat;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftMinecart;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftMinecartChest;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import xyz.lychee.lagfixer.modules.VehicleMotionReducerModule;
import xyz.lychee.lagfixer.nms.v1_16_R3.OptimizedEntities;

public class VehicleMotionReducer
extends VehicleMotionReducerModule.NMS
implements Listener {
    private static final IdentityHashMap<Class<? extends net.minecraft.server.v1_16_R3.Entity>, Function<net.minecraft.server.v1_16_R3.Entity, net.minecraft.server.v1_16_R3.Entity>> VEHICLES = new IdentityHashMap(7);

    public VehicleMotionReducer(VehicleMotionReducerModule module) {
        super(module);
    }

    @Override
    public boolean optimizeVehicle(Entity vehicle) {
        if (vehicle instanceof CraftBoat) {
            if (this.getModule().isBoat()) {
                return this.processEntity((net.minecraft.server.v1_16_R3.Entity)((CraftBoat)vehicle).getHandle());
            }
            return false;
        }
        if (!(vehicle instanceof CraftMinecart) || !this.getModule().isMinecart()) {
            return false;
        }
        if (vehicle instanceof CraftMinecartChest && this.getModule().isMinecart_remove_chest()) {
            EntityMinecartContainer mc = ((CraftMinecartChest)vehicle).getHandle();
            mc.clear();
            mc.die();
            return true;
        }
        return this.processEntity((net.minecraft.server.v1_16_R3.Entity)((CraftMinecart)vehicle).getHandle());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onSpawn(ChunkLoadEvent e) {
        Entity[] entities;
        for (Entity entity : entities = e.getChunk().getEntities()) {
            this.optimizeVehicle(entity);
        }
    }

    private boolean processEntity(net.minecraft.server.v1_16_R3.Entity original) {
        Function<net.minecraft.server.v1_16_R3.Entity, net.minecraft.server.v1_16_R3.Entity> function;
        if (original instanceof OptimizedEntities || (function = VEHICLES.get(original.getClass())) == null) {
            return false;
        }
        net.minecraft.server.v1_16_R3.Entity newVehicle = function.apply(original);
        newVehicle.setSilent(true);
        this.copyLocation(original, newVehicle);
        original.getWorld().addEntity(newVehicle);
        this.copyItems(original, newVehicle);
        original.die();
        return true;
    }

    private void copyItems(net.minecraft.server.v1_16_R3.Entity from, net.minecraft.server.v1_16_R3.Entity to) {
        if (from instanceof EntityMinecartContainer && to instanceof EntityMinecartContainer) {
            for (int i = 0; i < ((EntityMinecartContainer)from).getSize(); ++i) {
                ItemStack is = ((EntityMinecartContainer)from).getItem(i);
                if (is.isEmpty()) continue;
                ((EntityMinecartContainer)to).setItem(i, is.cloneItemStack());
            }
            ((EntityMinecartContainer)from).clear();
        }
    }

    private void copyLocation(net.minecraft.server.v1_16_R3.Entity from, net.minecraft.server.v1_16_R3.Entity to) {
        to.setPosition(from.lastX, from.lastY, from.lastZ);
        to.setMot(Vec3D.ORIGIN);
        to.lastX = from.lastX;
        to.lastY = from.lastY;
        to.lastZ = from.lastZ;
    }

    static {
        VEHICLES.put(EntityBoat.class, e -> new OptimizedEntities.OBoat((EntityBoat)e));
        VEHICLES.put(EntityMinecartChest.class, e -> new OptimizedEntities.OMinecartChest((EntityMinecartChest)e));
        VEHICLES.put(EntityMinecartHopper.class, e -> new OptimizedEntities.OMinecartHopper((EntityMinecartHopper)e));
        VEHICLES.put(EntityMinecartFurnace.class, e -> new OptimizedEntities.OMinecartFurnace((EntityMinecartFurnace)e));
        VEHICLES.put(EntityMinecartTNT.class, e -> new OptimizedEntities.OMinecartTNT((EntityMinecartTNT)e));
        VEHICLES.put(EntityMinecartRideable.class, e -> new OptimizedEntities.OMinecart((EntityMinecartRideable)e));
    }
}

