/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.nms.v1_17_R1;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.entity.vehicle.EntityMinecartContainer;
import net.minecraft.world.entity.vehicle.EntityMinecartFurnace;
import net.minecraft.world.entity.vehicle.EntityMinecartHopper;
import net.minecraft.world.entity.vehicle.EntityMinecartMobSpawner;
import net.minecraft.world.entity.vehicle.EntityMinecartRideable;
import net.minecraft.world.entity.vehicle.EntityMinecartTNT;
import net.minecraft.world.item.ItemStack;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftBoat;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftMinecart;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftMinecartChest;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.EntitiesLoadEvent;
import xyz.lychee.lagfixer.modules.VehicleMotionReducerModule;
import xyz.lychee.lagfixer.nms.v1_17_R1.OptimizedEntities;

public class VehicleMotionReducer
extends VehicleMotionReducerModule.NMS
implements Listener {
    private static final IdentityHashMap<Class<? extends net.minecraft.world.entity.Entity>, Function<net.minecraft.world.entity.Entity, net.minecraft.world.entity.Entity>> VEHICLES = new IdentityHashMap(7);

    public VehicleMotionReducer(VehicleMotionReducerModule module) {
        super(module);
    }

    @Override
    public boolean optimizeVehicle(Entity vehicle) {
        if (vehicle instanceof CraftBoat) {
            if (!this.getModule().isBoat()) {
                return false;
            }
            return this.processEntity((net.minecraft.world.entity.Entity)((CraftBoat)vehicle).getHandle());
        }
        if (vehicle instanceof CraftMinecart) {
            if (!this.getModule().isMinecart()) {
                return false;
            }
            if (vehicle instanceof CraftMinecartChest && this.getModule().isMinecart_remove_chest()) {
                EntityMinecartContainer mc = ((CraftMinecartChest)vehicle).getHandle();
                mc.clear();
                mc.bo();
                return true;
            }
            return this.processEntity((net.minecraft.world.entity.Entity)((CraftMinecart)vehicle).getHandle());
        }
        return false;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onSpawn(EntitiesLoadEvent e) {
        List entities = e.getEntities();
        for (Entity entity : entities) {
            this.optimizeVehicle(entity);
        }
    }

    private boolean processEntity(net.minecraft.world.entity.Entity original) {
        if (original instanceof OptimizedEntities) {
            return false;
        }
        Function<net.minecraft.world.entity.Entity, net.minecraft.world.entity.Entity> factory = VEHICLES.get(original.getClass());
        if (factory == null) {
            return false;
        }
        net.minecraft.world.entity.Entity newVehicle = factory.apply(original);
        this.copyLocation(original, newVehicle);
        original.t.addEntity(newVehicle);
        this.copyItems(original, newVehicle);
        original.bo();
        return true;
    }

    private void copyItems(net.minecraft.world.entity.Entity from, net.minecraft.world.entity.Entity to) {
        if (from instanceof EntityMinecartContainer && to instanceof EntityMinecartContainer) {
            for (int i = 0; i < ((EntityMinecartContainer)from).getSize(); ++i) {
                ItemStack is = ((EntityMinecartContainer)from).getItem(i);
                if (is.isEmpty()) continue;
                ((EntityMinecartContainer)to).setItem(i, is.cloneItemStack());
            }
            ((EntityMinecartContainer)from).clear();
        }
    }

    private void copyLocation(net.minecraft.world.entity.Entity from, net.minecraft.world.entity.Entity to) {
        to.setPosition(from.u, from.v, from.w);
        to.u = from.u;
        to.v = from.v;
        to.w = from.w;
        float yaw = Location.normalizeYaw((float)from.x);
        to.setYRot(yaw);
        to.x = yaw;
        to.setHeadRotation(yaw);
    }

    static {
        VEHICLES.put(EntityBoat.class, e -> new OptimizedEntities.OBoat((EntityBoat)e));
        VEHICLES.put(EntityMinecartChest.class, e -> new OptimizedEntities.OMinecartChest((EntityMinecartChest)e));
        VEHICLES.put(EntityMinecartHopper.class, e -> new OptimizedEntities.OMinecartHopper((EntityMinecartHopper)e));
        VEHICLES.put(EntityMinecartFurnace.class, e -> new OptimizedEntities.OMinecartFurnace((EntityMinecartFurnace)e));
        VEHICLES.put(EntityMinecartMobSpawner.class, e -> new OptimizedEntities.OMinecartSpawner((EntityMinecartMobSpawner)e));
        VEHICLES.put(EntityMinecartTNT.class, e -> new OptimizedEntities.OMinecartTNT((EntityMinecartTNT)e));
        VEHICLES.put(EntityMinecartRideable.class, e -> new OptimizedEntities.OMinecart((EntityMinecartRideable)e));
    }
}

