/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.managers;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.objects.AbstractManager;
import xyz.lychee.lagfixer.utils.MessageUtils;

public class UpdaterManager
extends AbstractManager
implements Listener {
    private static UpdaterManager instance;
    private final VersionComparator comparator = new VersionComparator();
    private final Gson gson = new Gson();
    private int compared = 0;
    private int difference = 0;
    private int behind = -1;
    private String latestVersion = "";
    private String currentVersion = "";
    private BukkitTask task;
    private boolean updater;

    public UpdaterManager(LagFixer plugin) {
        super(plugin);
        instance = this;
    }

    @EventHandler
    public void onClick(PlayerJoinEvent e) {
        if (e.getPlayer().isOp() && this.compared < 0 && this.updater) {
            SupportManager.getInstance().getFork().runLater(true, () -> MessageUtils.sendMessage(true, (CommandSender)e.getPlayer(), "\nPlugin needs update, latest version: &f" + this.latestVersion + "\n &8- &ehttps://modrinth.com/plugin/lagfixer/version/" + this.latestVersion + "\n"), 3L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void load() throws IOException {
        this.updater = this.getPlugin().getConfig().getBoolean("main.updater");
        this.task = SupportManager.getInstance().getFork().runTimer(true, () -> {
            try {
                this.currentVersion = this.getPlugin().getDescription().getVersion().split(" ")[0].trim();
                URL url = new URL("https://api.modrinth.com/v2/project/lagfixer/version");
                InputStreamReader reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);
                Type listType = new TypeToken<ArrayList<ModrinthVersion>>(){}.getType();
                List versions = (List)this.gson.fromJson((Reader)reader, listType);
                versions.removeIf(version -> version.getVersion_number().matches(".*[^0-9.].*"));
                if (!versions.isEmpty()) {
                    versions.sort((v1, v2) -> this.comparator.compare(v2.getVersion_number(), v1.getVersion_number()));
                    ModrinthVersion latest = (ModrinthVersion)versions.get(0);
                    this.latestVersion = latest.getVersion_number();
                    this.behind = this.calculateBuildsBehind(versions);
                } else {
                    this.latestVersion = this.getPlugin().getDescription().getVersion();
                    this.behind = 0;
                }
                this.difference = this.comparator.difference(this.currentVersion, this.latestVersion);
                this.compared = this.comparator.compare(this.currentVersion, this.latestVersion);
                if (this.difference >= 0 && this.difference < 2 || this.behind > 5) {
                    this.updater = true;
                }
            }
            catch (IOException ex) {
                this.getPlugin().printError(ex);
            }
            if (this.updater && this.compared < 0) {
                this.getPlugin().getLogger().info(String.format("\n&8\u2218\u208a\u2727\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2727\u208a\u2218\n&c&lLagFixer needs an update!\n&fVersion: &e&n%s&r -> &e&n%s&r\n&ahttps://modrinth.com/plugin/lagfixer/version/%s\n\n&6\u26a0 &7Updating this plugin is crucial! &6\u26a0\n&8\u2218\u208a\u2727\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2727\u208a\u2218", this.currentVersion, this.latestVersion, this.latestVersion));
            }
        }, 1L, 30L, TimeUnit.MINUTES);
        this.getPlugin().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
    }

    private int calculateBuildsBehind(List<ModrinthVersion> versions) {
        if (this.currentVersion.equals(this.latestVersion)) {
            return 0;
        }
        int currentIndex = -1;
        int latestIndex = -1;
        for (int i = 0; i < versions.size(); ++i) {
            ModrinthVersion version = versions.get(i);
            if (version.getVersion_number().equals(this.currentVersion)) {
                currentIndex = i;
            }
            if (!version.getVersion_number().equals(this.latestVersion)) continue;
            latestIndex = i;
        }
        if (currentIndex != -1 && latestIndex != -1) {
            return currentIndex - latestIndex;
        }
        return -1;
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.task != null && !this.task.isCancelled()) {
            this.task.cancel();
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public VersionComparator getComparator() {
        return this.comparator;
    }

    public Gson getGson() {
        return this.gson;
    }

    public int getCompared() {
        return this.compared;
    }

    public int getDifference() {
        return this.difference;
    }

    public int getBehind() {
        return this.behind;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public BukkitTask getTask() {
        return this.task;
    }

    public boolean isUpdater() {
        return this.updater;
    }

    public static UpdaterManager getInstance() {
        return instance;
    }

    public static class VersionComparator
    implements Comparator<String> {
        @Override
        public int compare(String current, String latest) {
            String[] parts1 = current.split("\\.");
            String[] parts2 = latest.split("\\.");
            int length = Math.max(parts1.length, parts2.length);
            for (int i = 0; i < length; ++i) {
                int num2;
                int num1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
                int n = num2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
                if (num1 == num2) continue;
                return Integer.compare(num1, num2);
            }
            return 0;
        }

        public int difference(String current, String latest) {
            String[] parts1 = current.split("\\.");
            String[] parts2 = latest.split("\\.");
            int length = Math.max(parts1.length, parts2.length);
            for (int i = 0; i < length; ++i) {
                int num2;
                int num1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
                int n = num2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
                if (num1 >= num2) continue;
                return i;
            }
            return -1;
        }
    }

    public static class ModrinthVersion {
        private List<String> game_versions;
        private List<String> loaders;
        private String id;
        private String project_id;
        private String author_id;
        private boolean featured;
        private String name;
        private String version_number;
        private String changelog;
        private String changelog_url;
        private String date_published;
        private int downloads;
        private String version_type;
        private String status;
        private String requested_status;
        private List<VersionFile> files;
        private List<Dependency> dependencies;

        public List<String> getGame_versions() {
            return this.game_versions;
        }

        public List<String> getLoaders() {
            return this.loaders;
        }

        public String getId() {
            return this.id;
        }

        public String getProject_id() {
            return this.project_id;
        }

        public String getAuthor_id() {
            return this.author_id;
        }

        public boolean isFeatured() {
            return this.featured;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion_number() {
            return this.version_number;
        }

        public String getChangelog() {
            return this.changelog;
        }

        public String getChangelog_url() {
            return this.changelog_url;
        }

        public String getDate_published() {
            return this.date_published;
        }

        public int getDownloads() {
            return this.downloads;
        }

        public String getVersion_type() {
            return this.version_type;
        }

        public String getStatus() {
            return this.status;
        }

        public String getRequested_status() {
            return this.requested_status;
        }

        public List<VersionFile> getFiles() {
            return this.files;
        }

        public List<Dependency> getDependencies() {
            return this.dependencies;
        }

        public void setGame_versions(List<String> game_versions) {
            this.game_versions = game_versions;
        }

        public void setLoaders(List<String> loaders) {
            this.loaders = loaders;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setProject_id(String project_id) {
            this.project_id = project_id;
        }

        public void setAuthor_id(String author_id) {
            this.author_id = author_id;
        }

        public void setFeatured(boolean featured) {
            this.featured = featured;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setVersion_number(String version_number) {
            this.version_number = version_number;
        }

        public void setChangelog(String changelog) {
            this.changelog = changelog;
        }

        public void setChangelog_url(String changelog_url) {
            this.changelog_url = changelog_url;
        }

        public void setDate_published(String date_published) {
            this.date_published = date_published;
        }

        public void setDownloads(int downloads) {
            this.downloads = downloads;
        }

        public void setVersion_type(String version_type) {
            this.version_type = version_type;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public void setRequested_status(String requested_status) {
            this.requested_status = requested_status;
        }

        public void setFiles(List<VersionFile> files) {
            this.files = files;
        }

        public void setDependencies(List<Dependency> dependencies) {
            this.dependencies = dependencies;
        }
    }

    public static class Dependency {
        public String version_id;
        public String project_id;
        public String file_name;
        public String dependency_type;

        public String getVersion_id() {
            return this.version_id;
        }

        public String getProject_id() {
            return this.project_id;
        }

        public String getFile_name() {
            return this.file_name;
        }

        public String getDependency_type() {
            return this.dependency_type;
        }

        public void setVersion_id(String version_id) {
            this.version_id = version_id;
        }

        public void setProject_id(String project_id) {
            this.project_id = project_id;
        }

        public void setFile_name(String file_name) {
            this.file_name = file_name;
        }

        public void setDependency_type(String dependency_type) {
            this.dependency_type = dependency_type;
        }
    }

    public static class VersionFile {
        private Map<String, String> hashes;
        private String url;
        private String filename;
        private boolean primary;
        private int size;
        private String file_type;

        public Map<String, String> getHashes() {
            return this.hashes;
        }

        public String getUrl() {
            return this.url;
        }

        public String getFilename() {
            return this.filename;
        }

        public boolean isPrimary() {
            return this.primary;
        }

        public int getSize() {
            return this.size;
        }

        public String getFile_type() {
            return this.file_type;
        }

        public void setHashes(Map<String, String> hashes) {
            this.hashes = hashes;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public void setPrimary(boolean primary) {
            this.primary = primary;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public void setFile_type(String file_type) {
            this.file_type = file_type;
        }
    }
}

