/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.menu;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.commands.MenuCommand;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.objects.AbstractMenu;
import xyz.lychee.lagfixer.objects.AbstractModule;
import xyz.lychee.lagfixer.utils.MessageUtils;

public class ConfigMenu
extends AbstractMenu {
    private final Map<UUID, ConfigChange> playerChanges = new HashMap<UUID, ConfigChange>();
    private final AbstractModule module;
    private final File configFile;

    public ConfigMenu(LagFixer plugin, ConfigurationSection defSection, int size, AbstractModule module) {
        super(plugin, size, MessageUtils.fixColors(null, "&8[&e&l\u26a1&8] &fConfig! &8| &eLagFixer"), -1, true);
        this.module = module;
        this.configFile = new File(this.getPlugin().getDataFolder(), "modules/" + module.getName() + ".yml");
        for (int i = size - 9; i < size - 1; ++i) {
            if (this.getInv().getItem(i) != null) continue;
            this.getInv().setItem(i, ConfigMenu.getBorder());
        }
        this.getInv().setItem(size - 1, ConfigMenu.getBack());
        this.itemClickEvent(size - 5, () -> this.module.isLoaded() ? ConfigMenu.getEnabled() : ConfigMenu.getDisabled(), null);
        int slot = 0;
        for (Map.Entry entry : defSection.getValues(true).entrySet()) {
            if (entry.getValue() instanceof ConfigurationSection) continue;
            String key = (String)entry.getKey();
            Object currentValue = this.module.getSection().get(key);
            ConfigChange change = new ConfigChange(this.module, key, currentValue);
            this.itemClickEvent(slot++, () -> {
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(MessageUtils.fixColors(null, "&7Current value:"));
                if (currentValue instanceof Collection) {
                    for (Object obj : (Collection)currentValue) {
                        lore.add(MessageUtils.fixColors(null, " &8{*} &e" + obj));
                    }
                } else {
                    lore.add(MessageUtils.fixColors(null, " &8{*} &e" + currentValue));
                }
                lore.add("");
                lore.add(MessageUtils.fixColors(null, "&bRight click for default value!"));
                lore.add(MessageUtils.fixColors(null, "&aLeft click to change value!"));
                ItemStack item = this.module.getBaseSkull().clone();
                ItemMeta meta = item.getItemMeta();
                if (meta != null) {
                    meta.setDisplayName(MessageUtils.fixColors(null, "&f&lKey: &e&l" + key));
                    meta.setLore(lore);
                    item.setItemMeta(meta);
                }
                return item;
            }, e -> {
                HumanEntity human = e.getWhoClicked();
                if (e.isRightClick()) {
                    Object defaultValue = change.getModule().getSection().getDefaultSection().get(change.getKey());
                    MessageUtils.sendMessage(true, (CommandSender)human, "&fDefault value of &e" + change.getKey() + " &fis:\n &8{*} &e" + defaultValue);
                } else {
                    human.closeInventory();
                    this.playerChanges.put(human.getUniqueId(), change);
                    MessageUtils.sendMessage(true, (CommandSender)human, "Enter new value (-cancel to cancel):");
                    if (change.getValue() instanceof Collection) {
                        MessageUtils.sendMessage(false, (CommandSender)human, "&fExisting values will be toggled.");
                    }
                }
            });
        }
    }

    @Override
    public void update() {
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent e) {
        Player player = e.getPlayer();
        ConfigChange change = this.playerChanges.remove(player.getUniqueId());
        if (change == null) {
            return;
        }
        e.setCancelled(true);
        if (e.getMessage().equalsIgnoreCase("-cancel") || e.getMessage().equalsIgnoreCase("cancel")) {
            this.openModuleMenu(player, change.getModule());
            MessageUtils.sendMessage(true, (CommandSender)player, "Config editor cancelled!");
            return;
        }
        try {
            this.updateConfigValue(change, e.getMessage());
            change.getModule().getConfig().save(this.configFile);
            change.getModule().loadAllConfig();
            Object newValue = change.getModule().getSection().get(change.getKey());
            MessageUtils.sendMessage(true, (CommandSender)player, "&fConfiguration saved!\n &8{*} &e" + change.getValue() + " &8\u2192 &e" + newValue);
            change.getModule().getMenu().updateAll();
            this.openModuleMenu(player, change.getModule());
        }
        catch (Exception ex) {
            MessageUtils.sendMessage(true, (CommandSender)player, "&cError saving configuration!");
        }
    }

    private void updateConfigValue(ConfigChange change, String message) {
        String key;
        ConfigurationSection section = change.getModule().getSection();
        if (section.isString(key = change.getKey())) {
            section.set(key, (Object)message);
        } else if (section.isInt(key)) {
            section.set(key, (Object)Integer.parseInt(message));
        } else if (section.isDouble(key)) {
            section.set(key, (Object)Double.parseDouble(message));
        } else if (section.isLong(key)) {
            section.set(key, (Object)Long.parseLong(message));
        } else if (section.isBoolean(key)) {
            section.set(key, (Object)Boolean.parseBoolean(message));
        } else if (section.isList(key)) {
            List list = section.getStringList(key);
            if (list.contains(message)) {
                list.remove(message);
            } else {
                list.add(message);
            }
            section.set(key, (Object)list);
        }
    }

    private void openModuleMenu(Player player, AbstractModule module) {
        SupportManager.getInstance().getFork().runNow(false, player.getLocation(), () -> player.openInventory(module.getMenu().getInv()));
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        this.playerChanges.remove(e.getPlayer().getUniqueId());
    }

    @Override
    public void handleClick(InventoryClickEvent e, ItemStack item) {
        int topSize;
        if (item.getType() != Material.PLAYER_HEAD) {
            return;
        }
        HumanEntity human = e.getWhoClicked();
        int slot = e.getSlot();
        if (slot == (topSize = e.getView().getTopInventory().getSize()) - 5) {
            try {
                boolean newState = !this.module.isLoaded();
                String path = this.module.getName() + ".enabled";
                if (newState) {
                    this.module.load();
                    this.module.loadAllConfig();
                    MessageUtils.sendMessage(true, (CommandSender)human, "Enabled module &e" + this.module.getName());
                } else {
                    this.module.disable();
                    MessageUtils.sendMessage(true, (CommandSender)human, "Disabled module &e" + this.module.getName());
                }
                this.module.setLoaded(newState);
                this.module.getConfig().set(path, (Object)newState);
                this.module.getConfig().save(this.configFile);
                this.updateAll();
            }
            catch (Exception ex) {
                MessageUtils.sendMessage(true, (CommandSender)human, "Error toggling module!");
                this.getPlugin().printError(ex);
            }
        }
    }

    @Override
    public AbstractMenu previousMenu() {
        return MenuCommand.getInstance().getModulesMenu();
    }

    public static class ConfigChange {
        private final AbstractModule module;
        private final String key;
        private final Object value;

        public ConfigChange(AbstractModule module, String key, Object value) {
            this.module = module;
            this.key = key;
            this.value = value;
        }

        public AbstractModule getModule() {
            return this.module;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigChange)) {
                return false;
            }
            ConfigChange other = (ConfigChange)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AbstractModule this$module = this.getModule();
            AbstractModule other$module = other.getModule();
            if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConfigChange;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AbstractModule $module = this.getModule();
            result = result * 59 + ($module == null ? 43 : $module.hashCode());
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "ConfigMenu.ConfigChange(module=" + this.getModule() + ", key=" + this.getKey() + ", value=" + this.getValue() + ")";
        }
    }
}

