/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import xyz.lychee.lagfixer.managers.CommandManager;
import xyz.lychee.lagfixer.managers.ModuleManager;
import xyz.lychee.lagfixer.modules.WorldCleanerModule;
import xyz.lychee.lagfixer.utils.MessageUtils;

public class ClearCommand
extends CommandManager.Subcommand {
    public ClearCommand(CommandManager commandManager) {
        super(commandManager, "clear", "clear entities using rules in WorldCleaner", new String[0]);
    }

    @Override
    public void load() {
    }

    @Override
    public void unload() {
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String[] args) {
        String type;
        if (args.length < 1) {
            MessageUtils.sendMessage(true, sender, "&7Usage: &f/lagfixer clear <items|creatures|projectiles>");
            return true;
        }
        WorldCleanerModule module = ModuleManager.getInstance().get(WorldCleanerModule.class);
        if (module == null || !module.isLoaded()) {
            MessageUtils.sendMessage(true, sender, "&7WorldCleaner module is disabled!");
            return true;
        }
        return switch (type = args[0].toLowerCase()) {
            case "items" -> {
                ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
                for (World w : module.getAllowedWorlds()) {
                    module.getWorldCleaner().purgeItems(w, futures);
                }
                yield MessageUtils.sendMessage(true, sender, "&7Successfully removed items.");
            }
            case "creatures" -> {
                ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
                for (World w : module.getAllowedWorlds()) {
                    module.getWorldCleaner().purgeCreatures(w, futures);
                }
                yield MessageUtils.sendMessage(true, sender, "&7Successfully removed creatures.");
            }
            case "projectiles" -> {
                ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
                for (World w : module.getAllowedWorlds()) {
                    module.getWorldCleaner().purgeProjectiles(w, futures);
                }
                yield MessageUtils.sendMessage(true, sender, "&7Successfully removed projectiles.");
            }
            default -> MessageUtils.sendMessage(true, sender, "&7Invalid clear type: &f" + type);
        };
    }

    @Override
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String[] args) {
        if (args.length == 1) {
            return Arrays.asList("items", "creatures", "projectiles");
        }
        return Collections.emptyList();
    }
}

