/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.managers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.HumanEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.Language;
import xyz.lychee.lagfixer.commands.BenchmarkCommand;
import xyz.lychee.lagfixer.commands.ClearCommand;
import xyz.lychee.lagfixer.commands.MapCommand;
import xyz.lychee.lagfixer.commands.MenuCommand;
import xyz.lychee.lagfixer.commands.MonitorCommand;
import xyz.lychee.lagfixer.commands.PingCommand;
import xyz.lychee.lagfixer.commands.ReloadCommand;
import xyz.lychee.lagfixer.objects.AbstractManager;
import xyz.lychee.lagfixer.utils.MessageUtils;

public class CommandManager
extends AbstractManager {
    private static CommandManager instance;
    private final HashMap<String, Subcommand> subcommands = new HashMap();
    private final HashMap<String, Subcommand> subcommandsWithAliases = new HashMap();
    private Command command;
    private String permission;

    public CommandManager(LagFixer plugin) {
        super(plugin);
        instance = this;
        this.registerSubcommands(new BenchmarkCommand(this), new ClearCommand(this), new MapCommand(this), new MenuCommand(this), new MonitorCommand(this), new PingCommand(this), new ReloadCommand(this));
    }

    public void registerSubcommands(Subcommand ... subcommands) {
        for (Subcommand subcommand : subcommands) {
            this.subcommands.put(subcommand.getName(), subcommand);
            this.subcommandsWithAliases.put(subcommand.getName(), subcommand);
            if (subcommand.getAliases() == null) continue;
            for (String alias : subcommand.getAliases()) {
                this.subcommandsWithAliases.put(alias, subcommand);
            }
        }
    }

    @Override
    public void load() {
        for (Subcommand subcommand : this.subcommands.values()) {
            subcommand.load();
        }
        this.permission = this.getPlugin().getConfig().getString("main.command.permission");
        this.command = new Command(this.getPlugin().getConfig().getStringList("main.command.aliases"));
        Bukkit.getCommandMap().register(this.command.getName(), (org.bukkit.command.Command)this.command);
    }

    @Override
    public void disable() {
        for (Subcommand subcommand : this.subcommands.values()) {
            subcommand.unload();
        }
        if (this.command != null) {
            this.command.unregister(Bukkit.getCommandMap());
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public HashMap<String, Subcommand> getSubcommands() {
        return this.subcommands;
    }

    public HashMap<String, Subcommand> getSubcommandsWithAliases() {
        return this.subcommandsWithAliases;
    }

    public Command getCommand() {
        return this.command;
    }

    public String getPermission() {
        return this.permission;
    }

    public static CommandManager getInstance() {
        return instance;
    }

    public static abstract class Subcommand {
        private final CommandManager commandManager;
        private final String name;
        private final String description;
        private final String[] aliases;

        public Subcommand(CommandManager commandManager, String name, String description, String ... aliases) {
            this.commandManager = commandManager;
            this.name = name;
            this.description = description;
            this.aliases = aliases;
        }

        public abstract void load();

        public abstract void unload();

        public abstract boolean execute(@NotNull CommandSender var1, @NotNull String[] var2);

        @Nullable
        public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String[] args) {
            return Collections.emptyList();
        }

        public CommandManager getCommandManager() {
            return this.commandManager;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String[] getAliases() {
            return this.aliases;
        }
    }

    public class Command
    extends BukkitCommand {
        public Command(List<String> aliases) {
            super("lagfixer", "Main lagfixer command", "/lagfixer <" + String.join((CharSequence)"|", CommandManager.this.subcommands.keySet()) + ">", aliases);
        }

        public boolean execute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
            Subcommand cmd;
            if (!sender.hasPermission(CommandManager.this.permission)) {
                Component text = Language.getMainValue("no_access", true, Placeholder.unparsed((String)"permission", (String)CommandManager.this.permission));
                if (text == null) {
                    return false;
                }
                sender.sendMessage(text);
                return false;
            }
            if (args.length > 0 && (cmd = CommandManager.this.subcommandsWithAliases.get(args[0].toLowerCase())) != null) {
                String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
                cmd.execute(sender, subArgs);
                return false;
            }
            StringBuilder help = new StringBuilder("Subcommands list:\n");
            for (Subcommand subCommand : CommandManager.this.subcommands.values()) {
                help.append("&8{*} &f/lagfixer &e").append(subCommand.getName()).append(" &8- &7").append(subCommand.getDescription()).append("\n");
            }
            return MessageUtils.sendMessage(true, sender, help.toString());
        }

        @NotNull
        public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) {
            if (args.length == 1) {
                ArrayList<String> completions = new ArrayList<String>(CommandManager.this.subcommandsWithAliases.keySet());
                if (!args[0].isEmpty()) {
                    completions.removeIf(str -> !str.startsWith(args[0]));
                }
                Collections.sort(completions);
                return completions;
            }
            if (args.length >= 2) {
                String[] subArgs;
                List<String> tabComplete;
                String subCommandName = args[0].toLowerCase();
                Subcommand subCommand = CommandManager.this.subcommandsWithAliases.get(subCommandName);
                if (subCommand != null && (tabComplete = subCommand.tabComplete(sender, subArgs = Arrays.copyOfRange(args, 1, args.length))) != null && !tabComplete.isEmpty()) {
                    return tabComplete;
                }
                return Bukkit.getOnlinePlayers().stream().map(HumanEntity::getName).filter(s -> s.startsWith(args[1])).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
    }
}

