/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.modules;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerRiptideEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.managers.ModuleManager;
import xyz.lychee.lagfixer.objects.AbstractModule;
import xyz.lychee.lagfixer.utils.FastRandom;

public class AbilityLimiterModule
extends AbstractModule
implements Listener {
    private int trident_cooldown;
    private int elytra_cooldown;
    private double trident_speed;
    private double elytra_speed;
    private int trident_durability;
    private int elytra_durability;

    public AbilityLimiterModule(LagFixer plugin, ModuleManager manager) {
        super(plugin, manager, AbstractModule.Impact.MEDIUM, "AbilityLimiter", new String[]{"Limits rapid Trident and Elytra usage to prevent excessive chunk loading.", "Frequent high-speed travel can cause server lag and instability.", "AbilityLimiter allows adjusting the speed reduction to balance performance and player experience.", "Activating AbilityLimiter ensures smoother world loading, stable server performance, and controlled mobility."}, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTZmM2YwMzM0Yzk0MzhlOGM3NGMwZjIxNjdiMDkxN2QwZDQ2ZDk3MzYzNjk2NGY5MDI3NDJlZDU1NmZiMDc4MiJ9fX0=");
    }

    @EventHandler
    public void onPlayerRiptide(PlayerRiptideEvent e) {
        if (!this.canContinue(e.getPlayer().getWorld())) {
            return;
        }
        e.getPlayer().setCooldown(Material.TRIDENT, this.trident_cooldown);
        this.damageItem(e.getPlayer(), e.getItem(), this.trident_durability);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent e) {
        Action action;
        ItemStack firework;
        if (!this.canContinue(e.getPlayer().getWorld())) {
            return;
        }
        Player player = e.getPlayer();
        ItemStack chestplate = player.getInventory().getChestplate();
        if (chestplate != null && chestplate.getType() == Material.ELYTRA && (firework = e.getItem()) != null && firework.getType() == Material.FIREWORK_ROCKET && ((action = e.getAction()) == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK) && player.isGliding() && !player.hasCooldown(Material.FIREWORK_ROCKET)) {
            int duration;
            player.setCooldown(Material.FIREWORK_ROCKET, this.elytra_cooldown);
            if (firework.getAmount() > 1) {
                firework.setAmount(firework.getAmount() - 1);
            } else {
                player.getInventory().remove(firework);
            }
            ItemMeta meta = firework.getItemMeta();
            if (meta instanceof FireworkMeta) {
                switch (((FireworkMeta)meta).getPower()) {
                    case 2: {
                        duration = 5;
                        break;
                    }
                    case 3: {
                        duration = 9;
                        break;
                    }
                    default: {
                        duration = 3;
                        break;
                    }
                }
            } else {
                duration = 3;
            }
            AtomicInteger ai = new AtomicInteger();
            Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this.getPlugin(), task -> {
                if (player.isGliding()) {
                    player.setVelocity(player.getLocation().getDirection().normalize().multiply(this.elytra_speed + (double)ai.get() / 9.0));
                    if (ai.incrementAndGet() >= duration) {
                        task.cancel();
                    }
                    return;
                }
                task.cancel();
            }, 50L, 200L, TimeUnit.MILLISECONDS);
            this.damageItem(player, chestplate, this.elytra_durability);
        }
    }

    public void damageItem(Player player, ItemStack is, int defaultDuraLoss) {
        if (defaultDuraLoss < 1 || player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        ItemMeta meta = is.getItemMeta();
        if (meta == null) {
            return;
        }
        int duraLoss = defaultDuraLoss;
        if (meta.hasEnchant(Enchantment.DURABILITY)) {
            FastRandom random = new FastRandom();
            float lossChance = 100.0f / (float)(is.getEnchantmentLevel(Enchantment.DURABILITY) + 1);
            for (int i = 0; i < defaultDuraLoss; ++i) {
                if (!(random.nextFloat() * 100.0f < lossChance)) continue;
                ++duraLoss;
            }
        }
        if (!meta.isUnbreakable()) {
            int newDurability = is.getDurability() + duraLoss;
            short maxDurability = is.getType().getMaxDurability();
            is.setDurability((short)Math.min(newDurability, maxDurability));
        }
    }

    @Override
    public void load() {
        this.getPlugin().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
    }

    @Override
    public boolean loadConfig() {
        this.elytra_cooldown = this.getSection().getInt("elytra_boost.cooldown") * 20;
        this.elytra_speed = this.getSection().getDouble("elytra_boost.speed_multiplier") * 1.5;
        this.elytra_durability = this.getSection().getInt("elytra_boost.additional_durability_loss");
        this.trident_cooldown = this.getSection().getInt("trident_riptide.cooldown") * 20;
        this.trident_speed = this.getSection().getDouble("trident_riptide.speed_multiplier") * 0.65;
        this.trident_durability = this.getSection().getInt("trident_riptide.additional_durability_loss");
        return true;
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }
}

