/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.modules;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.plugin.Plugin;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.managers.HookManager;
import xyz.lychee.lagfixer.managers.ModuleManager;
import xyz.lychee.lagfixer.objects.AbstractModule;
import xyz.lychee.lagfixer.utils.ReflectionUtils;

public class EntityLimiterModule
extends AbstractModule
implements Listener {
    private final EnumSet<CreatureSpawnEvent.SpawnReason> reasons = EnumSet.noneOf(CreatureSpawnEvent.SpawnReason.class);
    private final EnumSet<EntityType> whitelist = EnumSet.noneOf(EntityType.class);
    private NMS entityLimiter;
    private int locks;
    private ScheduledTask alerts_task;
    private ScheduledTask overflow_task;
    private boolean alerts;
    private boolean ignore_models;
    private int creatures;
    private int items;
    private int vehicles;
    private int projectiles;
    private boolean overflow_enabled;
    private int overflow_interval;
    private double overflow_multiplier;
    private boolean overflow_creatures;
    private boolean overflow_items;
    private boolean overflow_vehicles;
    private boolean overflow_projectiles;
    private boolean overflow_named;

    public EntityLimiterModule(LagFixer plugin, ModuleManager manager) {
        super(plugin, manager, AbstractModule.Impact.HIGH, "EntityLimiter", new String[]{"Restricts the number of entities per chunk.", "Essential for survival servers with expansive animal farms.", "Prevents excessive entity accumulation and associated performance issues.", "Maintains stable performance levels even in environments with high entity density."}, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZWRjMzZjOWNiNTBhNTI3YWE1NTYwN2EwZGY3MTg1YWQyMGFhYmFhOTAzZThkOWFiZmM3ODI2MDcwNTU0MGRlZiJ9fX0=");
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onSpawn(CreatureSpawnEvent e) {
        if (this.creatures < 1 || !this.canContinue(e.getLocation().getWorld()) || !this.reasons.contains(e.getSpawnReason()) || this.whitelist.contains(e.getEntityType())) {
            return;
        }
        if (this.countEntities(e.getLocation().getChunk(), ent -> ent instanceof Mob) >= (long)this.creatures && (this.ignore_models || HookManager.getInstance().getModel().hasModel((Entity)e.getEntity()))) {
            e.setCancelled(true);
            ++this.locks;
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent e) {
        if (this.items < 1 || !this.canContinue(e.getItemDrop().getWorld()) || this.whitelist.contains(e.getItemDrop().getType())) {
            return;
        }
        if (this.countEntities(e.getItemDrop().getLocation().getChunk(), ent -> ent instanceof Item) >= (long)this.items) {
            e.setCancelled(true);
            ++this.locks;
        }
    }

    @EventHandler
    public void onVehicle(VehicleCreateEvent e) {
        if (this.vehicles < 1 || !this.canContinue(e.getVehicle().getWorld()) || this.whitelist.contains(e.getVehicle().getType())) {
            return;
        }
        if (this.countEntities(e.getVehicle().getLocation().getChunk(), ent -> ent instanceof Vehicle) >= (long)this.vehicles) {
            e.setCancelled(true);
            ++this.locks;
        }
    }

    @EventHandler
    public void onLaunch(ProjectileLaunchEvent e) {
        if (this.projectiles < 1 || !this.canContinue(e.getLocation().getWorld()) || this.whitelist.contains(e.getEntityType())) {
            return;
        }
        if (this.countEntities(e.getLocation().getChunk(), ent -> ent instanceof Projectile) >= (long)this.projectiles) {
            e.setCancelled(true);
            ++this.locks;
        }
    }

    public long countEntities(Chunk c, Predicate<Entity> predicate) {
        if (!c.isLoaded()) {
            return 0L;
        }
        Entity[] entities = c.getEntities();
        int count = 0;
        for (Entity entity : entities) {
            if (!predicate.test(entity) || this.whitelist.contains(entity.getType())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void load() {
        this.getPlugin().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
        if (this.alerts) {
            this.alerts_task = Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this.getPlugin(), t -> {
                if (this.locks > 75) {
                    this.getPlugin().getLogger().info("Entity limiter cancelled " + this.locks + " events!");
                    this.locks = 0;
                }
            }, 2L, 2L, TimeUnit.SECONDS);
        }
        if (this.overflow_enabled && this.entityLimiter != null) {
            this.overflow_interval = this.getSection().getInt("perchunk.overflow_purge.interval");
            this.overflow_task = Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this.getPlugin(), t -> this.getAllowedWorlds().forEach(w -> this.entityLimiter.overflowPurge((World)w)), (long)this.overflow_interval, (long)this.overflow_interval, TimeUnit.SECONDS);
        }
    }

    @Override
    public boolean loadConfig() {
        this.entityLimiter = (NMS)ReflectionUtils.createInstance("EntityLimiter", this);
        this.alerts = this.getSection().getBoolean("alerts");
        this.ignore_models = HookManager.getInstance().noneModels() || this.getSection().getBoolean("ignore_models");
        this.creatures = this.getSection().getInt("creatures");
        this.items = this.getSection().getInt("items");
        this.vehicles = this.getSection().getInt("vehicles");
        this.projectiles = this.getSection().getInt("projectiles");
        ReflectionUtils.convertEnums(CreatureSpawnEvent.SpawnReason.class, this.reasons, this.getSection().getStringList("reasons"));
        ReflectionUtils.convertEnums(EntityType.class, this.whitelist, this.getSection().getStringList("whitelist"));
        this.overflow_interval = this.getSection().getInt("overflow_purge.interval");
        boolean bl = this.overflow_enabled = this.overflow_interval > 0 && this.getSection().getBoolean("overflow_purge.enabled");
        if (this.overflow_enabled) {
            this.overflow_multiplier = this.getSection().getDouble("overflow_purge.limit_multiplier");
            this.overflow_creatures = this.creatures > 0 && this.getSection().getBoolean("overflow_purge.types.creatures");
            this.overflow_items = this.items > 0 && this.getSection().getBoolean("overflow_purge.types.items");
            this.overflow_vehicles = this.vehicles > 0 && this.getSection().getBoolean("overflow_purge.types.vehicles");
            this.overflow_projectiles = this.projectiles > 0 && this.getSection().getBoolean("overflow_purge.types.projectiles");
            this.overflow_named = this.getSection().getBoolean("overflow_purge.types.named");
        }
        return this.entityLimiter != null;
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.alerts_task != null) {
            this.alerts_task.cancel();
        }
        if (this.overflow_task != null) {
            this.overflow_task.cancel();
        }
    }

    public EnumSet<CreatureSpawnEvent.SpawnReason> getReasons() {
        return this.reasons;
    }

    public EnumSet<EntityType> getWhitelist() {
        return this.whitelist;
    }

    public NMS getEntityLimiter() {
        return this.entityLimiter;
    }

    public int getLocks() {
        return this.locks;
    }

    public ScheduledTask getAlerts_task() {
        return this.alerts_task;
    }

    public ScheduledTask getOverflow_task() {
        return this.overflow_task;
    }

    public boolean isAlerts() {
        return this.alerts;
    }

    public boolean isIgnore_models() {
        return this.ignore_models;
    }

    public int getCreatures() {
        return this.creatures;
    }

    public int getItems() {
        return this.items;
    }

    public int getVehicles() {
        return this.vehicles;
    }

    public int getProjectiles() {
        return this.projectiles;
    }

    public boolean isOverflow_enabled() {
        return this.overflow_enabled;
    }

    public int getOverflow_interval() {
        return this.overflow_interval;
    }

    public double getOverflow_multiplier() {
        return this.overflow_multiplier;
    }

    public boolean isOverflow_creatures() {
        return this.overflow_creatures;
    }

    public boolean isOverflow_items() {
        return this.overflow_items;
    }

    public boolean isOverflow_vehicles() {
        return this.overflow_vehicles;
    }

    public boolean isOverflow_projectiles() {
        return this.overflow_projectiles;
    }

    public boolean isOverflow_named() {
        return this.overflow_named;
    }

    public void setEntityLimiter(NMS entityLimiter) {
        this.entityLimiter = entityLimiter;
    }

    public void setLocks(int locks) {
        this.locks = locks;
    }

    public void setAlerts_task(ScheduledTask alerts_task) {
        this.alerts_task = alerts_task;
    }

    public void setOverflow_task(ScheduledTask overflow_task) {
        this.overflow_task = overflow_task;
    }

    public void setAlerts(boolean alerts) {
        this.alerts = alerts;
    }

    public void setIgnore_models(boolean ignore_models) {
        this.ignore_models = ignore_models;
    }

    public void setCreatures(int creatures) {
        this.creatures = creatures;
    }

    public void setItems(int items) {
        this.items = items;
    }

    public void setVehicles(int vehicles) {
        this.vehicles = vehicles;
    }

    public void setProjectiles(int projectiles) {
        this.projectiles = projectiles;
    }

    public void setOverflow_enabled(boolean overflow_enabled) {
        this.overflow_enabled = overflow_enabled;
    }

    public void setOverflow_interval(int overflow_interval) {
        this.overflow_interval = overflow_interval;
    }

    public void setOverflow_multiplier(double overflow_multiplier) {
        this.overflow_multiplier = overflow_multiplier;
    }

    public void setOverflow_creatures(boolean overflow_creatures) {
        this.overflow_creatures = overflow_creatures;
    }

    public void setOverflow_items(boolean overflow_items) {
        this.overflow_items = overflow_items;
    }

    public void setOverflow_vehicles(boolean overflow_vehicles) {
        this.overflow_vehicles = overflow_vehicles;
    }

    public void setOverflow_projectiles(boolean overflow_projectiles) {
        this.overflow_projectiles = overflow_projectiles;
    }

    public void setOverflow_named(boolean overflow_named) {
        this.overflow_named = overflow_named;
    }

    public static abstract class NMS {
        private final EntityLimiterModule module;

        public NMS(EntityLimiterModule module) {
            this.module = module;
        }

        public abstract void overflowPurge(World var1);

        public EntityLimiterModule getModule() {
            return this.module;
        }
    }
}

